// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The node auto repair configuration for the node group.
 */
public class NodeRepairConfig private constructor(builder: Builder) {
    /**
     * Specifies whether to enable node auto repair for the node group. Node auto repair is disabled by default.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * Specify the maximum number of nodes that can be repaired concurrently or in parallel, expressed as a count of unhealthy nodes. This gives you finer-grained control over the pace of node replacements. When using this, you cannot also set `maxParallelNodesRepairedPercentage` at the same time.
     */
    public val maxParallelNodesRepairedCount: kotlin.Int? = builder.maxParallelNodesRepairedCount
    /**
     * Specify the maximum number of nodes that can be repaired concurrently or in parallel, expressed as a percentage of unhealthy nodes. This gives you finer-grained control over the pace of node replacements. When using this, you cannot also set `maxParallelNodesRepairedCount` at the same time.
     */
    public val maxParallelNodesRepairedPercentage: kotlin.Int? = builder.maxParallelNodesRepairedPercentage
    /**
     * Specify a count threshold of unhealthy nodes, above which node auto repair actions will stop. When using this, you cannot also set `maxUnhealthyNodeThresholdPercentage` at the same time.
     */
    public val maxUnhealthyNodeThresholdCount: kotlin.Int? = builder.maxUnhealthyNodeThresholdCount
    /**
     * Specify a percentage threshold of unhealthy nodes, above which node auto repair actions will stop. When using this, you cannot also set `maxUnhealthyNodeThresholdCount` at the same time.
     */
    public val maxUnhealthyNodeThresholdPercentage: kotlin.Int? = builder.maxUnhealthyNodeThresholdPercentage
    /**
     * Specify granular overrides for specific repair actions. These overrides control the repair action and the repair delay time before a node is considered eligible for repair. If you use this, you must specify all the values.
     */
    public val nodeRepairConfigOverrides: List<NodeRepairConfigOverrides>? = builder.nodeRepairConfigOverrides

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.NodeRepairConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NodeRepairConfig(")
        append("enabled=$enabled,")
        append("maxParallelNodesRepairedCount=$maxParallelNodesRepairedCount,")
        append("maxParallelNodesRepairedPercentage=$maxParallelNodesRepairedPercentage,")
        append("maxUnhealthyNodeThresholdCount=$maxUnhealthyNodeThresholdCount,")
        append("maxUnhealthyNodeThresholdPercentage=$maxUnhealthyNodeThresholdPercentage,")
        append("nodeRepairConfigOverrides=$nodeRepairConfigOverrides")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (maxParallelNodesRepairedCount ?: 0)
        result = 31 * result + (maxParallelNodesRepairedPercentage ?: 0)
        result = 31 * result + (maxUnhealthyNodeThresholdCount ?: 0)
        result = 31 * result + (maxUnhealthyNodeThresholdPercentage ?: 0)
        result = 31 * result + (nodeRepairConfigOverrides?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NodeRepairConfig

        if (enabled != other.enabled) return false
        if (maxParallelNodesRepairedCount != other.maxParallelNodesRepairedCount) return false
        if (maxParallelNodesRepairedPercentage != other.maxParallelNodesRepairedPercentage) return false
        if (maxUnhealthyNodeThresholdCount != other.maxUnhealthyNodeThresholdCount) return false
        if (maxUnhealthyNodeThresholdPercentage != other.maxUnhealthyNodeThresholdPercentage) return false
        if (nodeRepairConfigOverrides != other.nodeRepairConfigOverrides) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.NodeRepairConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether to enable node auto repair for the node group. Node auto repair is disabled by default.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * Specify the maximum number of nodes that can be repaired concurrently or in parallel, expressed as a count of unhealthy nodes. This gives you finer-grained control over the pace of node replacements. When using this, you cannot also set `maxParallelNodesRepairedPercentage` at the same time.
         */
        public var maxParallelNodesRepairedCount: kotlin.Int? = null
        /**
         * Specify the maximum number of nodes that can be repaired concurrently or in parallel, expressed as a percentage of unhealthy nodes. This gives you finer-grained control over the pace of node replacements. When using this, you cannot also set `maxParallelNodesRepairedCount` at the same time.
         */
        public var maxParallelNodesRepairedPercentage: kotlin.Int? = null
        /**
         * Specify a count threshold of unhealthy nodes, above which node auto repair actions will stop. When using this, you cannot also set `maxUnhealthyNodeThresholdPercentage` at the same time.
         */
        public var maxUnhealthyNodeThresholdCount: kotlin.Int? = null
        /**
         * Specify a percentage threshold of unhealthy nodes, above which node auto repair actions will stop. When using this, you cannot also set `maxUnhealthyNodeThresholdCount` at the same time.
         */
        public var maxUnhealthyNodeThresholdPercentage: kotlin.Int? = null
        /**
         * Specify granular overrides for specific repair actions. These overrides control the repair action and the repair delay time before a node is considered eligible for repair. If you use this, you must specify all the values.
         */
        public var nodeRepairConfigOverrides: List<NodeRepairConfigOverrides>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.NodeRepairConfig) : this() {
            this.enabled = x.enabled
            this.maxParallelNodesRepairedCount = x.maxParallelNodesRepairedCount
            this.maxParallelNodesRepairedPercentage = x.maxParallelNodesRepairedPercentage
            this.maxUnhealthyNodeThresholdCount = x.maxUnhealthyNodeThresholdCount
            this.maxUnhealthyNodeThresholdPercentage = x.maxUnhealthyNodeThresholdPercentage
            this.nodeRepairConfigOverrides = x.nodeRepairConfigOverrides
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.NodeRepairConfig = NodeRepairConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
