// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreatePodIdentityAssociationRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The name of the cluster to create the EKS Pod Identity association in.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * Disable the automatic sessions tags that are appended by EKS Pod Identity.
     *
     * EKS Pod Identity adds a pre-defined set of session tags when it assumes the role. You can use these tags to author a single role that can work across resources by allowing access to Amazon Web Services resources based on matching tags. By default, EKS Pod Identity attaches six tags, including tags for cluster name, namespace, and service account name. For the list of tags added by EKS Pod Identity, see [List of session tags added by EKS Pod Identity](https://docs.aws.amazon.com/eks/latest/userguide/pod-id-abac.html#pod-id-abac-tags) in the *Amazon EKS User Guide*.
     *
     * Amazon Web Services compresses inline session policies, managed policy ARNs, and session tags into a packed binary format that has a separate limit. If you receive a `PackedPolicyTooLarge` error indicating the packed binary format has exceeded the size limit, you can attempt to reduce the size by disabling the session tags added by EKS Pod Identity.
     */
    public val disableSessionTags: kotlin.Boolean? = builder.disableSessionTags
    /**
     * The name of the Kubernetes namespace inside the cluster to create the EKS Pod Identity association in. The service account and the Pods that use the service account must be in this namespace.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The Amazon Resource Name (ARN) of the IAM role to associate with the service account. The EKS Pod Identity agent manages credentials to assume this role for applications in the containers in the Pods that use this service account.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
     */
    public val serviceAccount: kotlin.String? = builder.serviceAccount
    /**
     * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource – 50
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length – 128 Unicode characters in UTF-8
     * + Maximum value length – 256 Unicode characters in UTF-8
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case-sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The Amazon Resource Name (ARN) of the target IAM role to associate with the service account. This role is assumed by using the EKS Pod Identity association role, then the credentials for this role are injected into the Pod.
     *
     * When you run applications on Amazon EKS, your application might need to access Amazon Web Services resources from a different role that exists in the same or different Amazon Web Services account. For example, your application running in “Account A” might need to access resources, such as Amazon S3 buckets in “Account B” or within “Account A” itself. You can create a association to access Amazon Web Services resources in “Account B” by creating two IAM roles: a role in “Account A” and a role in “Account B” (which can be the same or different account), each with the necessary trust and permission policies. After you provide these roles in the *IAM role* and *Target IAM role* fields, EKS will perform role chaining to ensure your application gets the required permissions. This means Role A will assume Role B, allowing your Pods to securely access resources like S3 buckets in the target account.
     */
    public val targetRoleArn: kotlin.String? = builder.targetRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.CreatePodIdentityAssociationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePodIdentityAssociationRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("clusterName=$clusterName,")
        append("disableSessionTags=$disableSessionTags,")
        append("namespace=$namespace,")
        append("roleArn=$roleArn,")
        append("serviceAccount=$serviceAccount,")
        append("tags=$tags,")
        append("targetRoleArn=$targetRoleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (disableSessionTags?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (serviceAccount?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePodIdentityAssociationRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (clusterName != other.clusterName) return false
        if (disableSessionTags != other.disableSessionTags) return false
        if (namespace != other.namespace) return false
        if (roleArn != other.roleArn) return false
        if (serviceAccount != other.serviceAccount) return false
        if (tags != other.tags) return false
        if (targetRoleArn != other.targetRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.CreatePodIdentityAssociationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The name of the cluster to create the EKS Pod Identity association in.
         */
        public var clusterName: kotlin.String? = null
        /**
         * Disable the automatic sessions tags that are appended by EKS Pod Identity.
         *
         * EKS Pod Identity adds a pre-defined set of session tags when it assumes the role. You can use these tags to author a single role that can work across resources by allowing access to Amazon Web Services resources based on matching tags. By default, EKS Pod Identity attaches six tags, including tags for cluster name, namespace, and service account name. For the list of tags added by EKS Pod Identity, see [List of session tags added by EKS Pod Identity](https://docs.aws.amazon.com/eks/latest/userguide/pod-id-abac.html#pod-id-abac-tags) in the *Amazon EKS User Guide*.
         *
         * Amazon Web Services compresses inline session policies, managed policy ARNs, and session tags into a packed binary format that has a separate limit. If you receive a `PackedPolicyTooLarge` error indicating the packed binary format has exceeded the size limit, you can attempt to reduce the size by disabling the session tags added by EKS Pod Identity.
         */
        public var disableSessionTags: kotlin.Boolean? = null
        /**
         * The name of the Kubernetes namespace inside the cluster to create the EKS Pod Identity association in. The service account and the Pods that use the service account must be in this namespace.
         */
        public var namespace: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role to associate with the service account. The EKS Pod Identity agent manages credentials to assume this role for applications in the containers in the Pods that use this service account.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
         */
        public var serviceAccount: kotlin.String? = null
        /**
         * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource – 50
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length – 128 Unicode characters in UTF-8
         * + Maximum value length – 256 Unicode characters in UTF-8
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case-sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         */
        public var tags: Map<String, String>? = null
        /**
         * The Amazon Resource Name (ARN) of the target IAM role to associate with the service account. This role is assumed by using the EKS Pod Identity association role, then the credentials for this role are injected into the Pod.
         *
         * When you run applications on Amazon EKS, your application might need to access Amazon Web Services resources from a different role that exists in the same or different Amazon Web Services account. For example, your application running in “Account A” might need to access resources, such as Amazon S3 buckets in “Account B” or within “Account A” itself. You can create a association to access Amazon Web Services resources in “Account B” by creating two IAM roles: a role in “Account A” and a role in “Account B” (which can be the same or different account), each with the necessary trust and permission policies. After you provide these roles in the *IAM role* and *Target IAM role* fields, EKS will perform role chaining to ensure your application gets the required permissions. This means Role A will assume Role B, allowing your Pods to securely access resources like S3 buckets in the target account.
         */
        public var targetRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.CreatePodIdentityAssociationRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.clusterName = x.clusterName
            this.disableSessionTags = x.disableSessionTags
            this.namespace = x.namespace
            this.roleArn = x.roleArn
            this.serviceAccount = x.serviceAccount
            this.tags = x.tags
            this.targetRoleArn = x.targetRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.CreatePodIdentityAssociationRequest = CreatePodIdentityAssociationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
