// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A type of EKS Pod Identity association owned by an Amazon EKS add-on.
 *
 * Each association maps a role to a service account in a namespace in the cluster.
 *
 * For more information, see [Attach an IAM Role to an Amazon EKS add-on using EKS Pod Identity](https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html) in the *Amazon EKS User Guide*.
 */
public class AddonPodIdentityAssociations private constructor(builder: Builder) {
    /**
     * The ARN of an IAM Role.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The name of a Kubernetes Service Account.
     */
    public val serviceAccount: kotlin.String = requireNotNull(builder.serviceAccount) { "A non-null value must be provided for serviceAccount" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.AddonPodIdentityAssociations = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddonPodIdentityAssociations(")
        append("roleArn=$roleArn,")
        append("serviceAccount=$serviceAccount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn.hashCode()
        result = 31 * result + (serviceAccount.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddonPodIdentityAssociations

        if (roleArn != other.roleArn) return false
        if (serviceAccount != other.serviceAccount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.AddonPodIdentityAssociations = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of an IAM Role.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The name of a Kubernetes Service Account.
         */
        public var serviceAccount: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.AddonPodIdentityAssociations) : this() {
            this.roleArn = x.roleArn
            this.serviceAccount = x.serviceAccount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.AddonPodIdentityAssociations = AddonPodIdentityAssociations(this)

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            if (serviceAccount == null) serviceAccount = ""
            return this
        }
    }
}
