// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An Amazon EKS add-on. For more information, see [Amazon EKS add-ons](https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html) in the *Amazon EKS User Guide*.
 */
public class Addon private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the add-on.
     */
    public val addonArn: kotlin.String? = builder.addonArn
    /**
     * The name of the add-on.
     */
    public val addonName: kotlin.String? = builder.addonName
    /**
     * The version of the add-on.
     */
    public val addonVersion: kotlin.String? = builder.addonVersion
    /**
     * The name of your cluster.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * The configuration values that you provided.
     */
    public val configurationValues: kotlin.String? = builder.configurationValues
    /**
     * The Unix epoch timestamp at object creation.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * An object that represents the health of the add-on.
     */
    public val health: aws.sdk.kotlin.services.eks.model.AddonHealth? = builder.health
    /**
     * Information about an Amazon EKS add-on from the Amazon Web Services Marketplace.
     */
    public val marketplaceInformation: aws.sdk.kotlin.services.eks.model.MarketplaceInformation? = builder.marketplaceInformation
    /**
     * The Unix epoch timestamp for the last modification to the object.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedAt
    /**
     * The namespace configuration for the addon. This specifies the Kubernetes namespace where the addon is installed.
     */
    public val namespaceConfig: aws.sdk.kotlin.services.eks.model.AddonNamespaceConfigResponse? = builder.namespaceConfig
    /**
     * The owner of the add-on.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * An array of EKS Pod Identity associations owned by the add-on. Each association maps a role to a service account in a namespace in the cluster.
     *
     * For more information, see [Attach an IAM Role to an Amazon EKS add-on using EKS Pod Identity](https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html) in the *Amazon EKS User Guide*.
     */
    public val podIdentityAssociations: List<String>? = builder.podIdentityAssociations
    /**
     * The publisher of the add-on.
     */
    public val publisher: kotlin.String? = builder.publisher
    /**
     * The Amazon Resource Name (ARN) of the IAM role that's bound to the Kubernetes `ServiceAccount` object that the add-on uses.
     */
    public val serviceAccountRoleArn: kotlin.String? = builder.serviceAccountRoleArn
    /**
     * The status of the add-on.
     */
    public val status: aws.sdk.kotlin.services.eks.model.AddonStatus? = builder.status
    /**
     * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.Addon = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Addon(")
        append("addonArn=$addonArn,")
        append("addonName=$addonName,")
        append("addonVersion=$addonVersion,")
        append("clusterName=$clusterName,")
        append("configurationValues=$configurationValues,")
        append("createdAt=$createdAt,")
        append("health=$health,")
        append("marketplaceInformation=$marketplaceInformation,")
        append("modifiedAt=$modifiedAt,")
        append("namespaceConfig=$namespaceConfig,")
        append("owner=$owner,")
        append("podIdentityAssociations=$podIdentityAssociations,")
        append("publisher=$publisher,")
        append("serviceAccountRoleArn=$serviceAccountRoleArn,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addonArn?.hashCode() ?: 0
        result = 31 * result + (addonName?.hashCode() ?: 0)
        result = 31 * result + (addonVersion?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (configurationValues?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (health?.hashCode() ?: 0)
        result = 31 * result + (marketplaceInformation?.hashCode() ?: 0)
        result = 31 * result + (modifiedAt?.hashCode() ?: 0)
        result = 31 * result + (namespaceConfig?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (podIdentityAssociations?.hashCode() ?: 0)
        result = 31 * result + (publisher?.hashCode() ?: 0)
        result = 31 * result + (serviceAccountRoleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Addon

        if (addonArn != other.addonArn) return false
        if (addonName != other.addonName) return false
        if (addonVersion != other.addonVersion) return false
        if (clusterName != other.clusterName) return false
        if (configurationValues != other.configurationValues) return false
        if (createdAt != other.createdAt) return false
        if (health != other.health) return false
        if (marketplaceInformation != other.marketplaceInformation) return false
        if (modifiedAt != other.modifiedAt) return false
        if (namespaceConfig != other.namespaceConfig) return false
        if (owner != other.owner) return false
        if (podIdentityAssociations != other.podIdentityAssociations) return false
        if (publisher != other.publisher) return false
        if (serviceAccountRoleArn != other.serviceAccountRoleArn) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.Addon = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the add-on.
         */
        public var addonArn: kotlin.String? = null
        /**
         * The name of the add-on.
         */
        public var addonName: kotlin.String? = null
        /**
         * The version of the add-on.
         */
        public var addonVersion: kotlin.String? = null
        /**
         * The name of your cluster.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The configuration values that you provided.
         */
        public var configurationValues: kotlin.String? = null
        /**
         * The Unix epoch timestamp at object creation.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object that represents the health of the add-on.
         */
        public var health: aws.sdk.kotlin.services.eks.model.AddonHealth? = null
        /**
         * Information about an Amazon EKS add-on from the Amazon Web Services Marketplace.
         */
        public var marketplaceInformation: aws.sdk.kotlin.services.eks.model.MarketplaceInformation? = null
        /**
         * The Unix epoch timestamp for the last modification to the object.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The namespace configuration for the addon. This specifies the Kubernetes namespace where the addon is installed.
         */
        public var namespaceConfig: aws.sdk.kotlin.services.eks.model.AddonNamespaceConfigResponse? = null
        /**
         * The owner of the add-on.
         */
        public var owner: kotlin.String? = null
        /**
         * An array of EKS Pod Identity associations owned by the add-on. Each association maps a role to a service account in a namespace in the cluster.
         *
         * For more information, see [Attach an IAM Role to an Amazon EKS add-on using EKS Pod Identity](https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html) in the *Amazon EKS User Guide*.
         */
        public var podIdentityAssociations: List<String>? = null
        /**
         * The publisher of the add-on.
         */
        public var publisher: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that's bound to the Kubernetes `ServiceAccount` object that the add-on uses.
         */
        public var serviceAccountRoleArn: kotlin.String? = null
        /**
         * The status of the add-on.
         */
        public var status: aws.sdk.kotlin.services.eks.model.AddonStatus? = null
        /**
         * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.Addon) : this() {
            this.addonArn = x.addonArn
            this.addonName = x.addonName
            this.addonVersion = x.addonVersion
            this.clusterName = x.clusterName
            this.configurationValues = x.configurationValues
            this.createdAt = x.createdAt
            this.health = x.health
            this.marketplaceInformation = x.marketplaceInformation
            this.modifiedAt = x.modifiedAt
            this.namespaceConfig = x.namespaceConfig
            this.owner = x.owner
            this.podIdentityAssociations = x.podIdentityAssociations
            this.publisher = x.publisher
            this.serviceAccountRoleArn = x.serviceAccountRoleArn
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.Addon = Addon(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.AddonHealth] inside the given [block]
         */
        public fun health(block: aws.sdk.kotlin.services.eks.model.AddonHealth.Builder.() -> kotlin.Unit) {
            this.health = aws.sdk.kotlin.services.eks.model.AddonHealth.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.MarketplaceInformation] inside the given [block]
         */
        public fun marketplaceInformation(block: aws.sdk.kotlin.services.eks.model.MarketplaceInformation.Builder.() -> kotlin.Unit) {
            this.marketplaceInformation = aws.sdk.kotlin.services.eks.model.MarketplaceInformation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.AddonNamespaceConfigResponse] inside the given [block]
         */
        public fun namespaceConfig(block: aws.sdk.kotlin.services.eks.model.AddonNamespaceConfigResponse.Builder.() -> kotlin.Unit) {
            this.namespaceConfig = aws.sdk.kotlin.services.eks.model.AddonNamespaceConfigResponse.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
