// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An access policy includes permissions that allow Amazon EKS to authorize an IAM principal to work with Kubernetes objects on your cluster. The policies are managed by Amazon EKS, but they're not IAM policies. You can't view the permissions in the policies using the API. The permissions for many of the policies are similar to the Kubernetes `cluster-admin`, `admin`, `edit`, and `view` cluster roles. For more information about these cluster roles, see [User-facing roles](https://kubernetes.io/docs/reference/access-authn-authz/rbac/#user-facing-roles) in the Kubernetes documentation. To view the contents of the policies, see [Access policy permissions](https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions) in the *Amazon EKS User Guide*.
 */
public class AccessPolicy private constructor(builder: Builder) {
    /**
     * The ARN of the access policy.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The name of the access policy.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.AccessPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessPolicy(")
        append("arn=$arn,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessPolicy

        if (arn != other.arn) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.AccessPolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the access policy.
         */
        public var arn: kotlin.String? = null
        /**
         * The name of the access policy.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.AccessPolicy) : this() {
            this.arn = x.arn
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.AccessPolicy = AccessPolicy(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
