// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.serde

import aws.sdk.kotlin.services.eks.model.AssociateIdentityProviderConfigRequest
import aws.sdk.kotlin.services.eks.model.OidcIdentityProviderConfigRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class AssociateIdentityProviderConfigOperationSerializer: HttpSerializer.NonStreaming<AssociateIdentityProviderConfigRequest> {
    override fun serialize(context: ExecutionContext, input: AssociateIdentityProviderConfigRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.clusterName) { "clusterName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("clusters"))
                add(PercentEncoding.SmithyLabel.encode(input.clusterName))
                add(PercentEncoding.Path.encode("identity-provider-configs"))
                add(PercentEncoding.Path.encode("associate"))
            }
        }

        val payload = serializeAssociateIdentityProviderConfigOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeAssociateIdentityProviderConfigOperationBody(context: ExecutionContext, input: AssociateIdentityProviderConfigRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val OIDC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("oidc"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(OIDC_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.oidc?.let { field(OIDC_DESCRIPTOR, it, ::serializeOidcIdentityProviderConfigRequestDocument) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
