// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.serde

import aws.sdk.kotlin.services.eks.model.AccessScope
import aws.sdk.kotlin.services.eks.model.AssociateAccessPolicyRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class AssociateAccessPolicyOperationSerializer: HttpSerializer.NonStreaming<AssociateAccessPolicyRequest> {
    override fun serialize(context: ExecutionContext, input: AssociateAccessPolicyRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.clusterName) { "clusterName is bound to the URI and must not be null" }
            requireNotNull(input.principalArn) { "principalArn is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("clusters"))
                add(PercentEncoding.SmithyLabel.encode(input.clusterName))
                add(PercentEncoding.Path.encode("access-entries"))
                add(PercentEncoding.SmithyLabel.encode(input.principalArn))
                add(PercentEncoding.Path.encode("access-policies"))
            }
        }

        val payload = serializeAssociateAccessPolicyOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeAssociateAccessPolicyOperationBody(context: ExecutionContext, input: AssociateAccessPolicyRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCESSSCOPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accessScope"))
    val POLICYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policyArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSSCOPE_DESCRIPTOR)
        field(POLICYARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accessScope?.let { field(ACCESSSCOPE_DESCRIPTOR, it, ::serializeAccessScopeDocument) }
        input.policyArn?.let { field(POLICYARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
