// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object representing an Amazon EKS cluster VPC configuration response.
 */
public class VpcConfigResponse private constructor(builder: Builder) {
    /**
     * The cluster security group that was created by Amazon EKS for the cluster. Managed node groups use this security group for control-plane-to-data-plane communication.
     */
    public val clusterSecurityGroupId: kotlin.String? = builder.clusterSecurityGroupId
    /**
     * This parameter indicates whether the Amazon EKS private API server endpoint is enabled. If the Amazon EKS private API server endpoint is enabled, Kubernetes API requests that originate from within your cluster's VPC use the private VPC endpoint instead of traversing the internet. If this value is disabled and you have nodes or Fargate pods in the cluster, then ensure that `publicAccessCidrs` includes the necessary CIDR blocks for communication with the nodes or Fargate pods. For more information, see [Cluster API server endpoint](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
     */
    public val endpointPrivateAccess: kotlin.Boolean = builder.endpointPrivateAccess
    /**
     * Whether the public API server endpoint is enabled.
     */
    public val endpointPublicAccess: kotlin.Boolean = builder.endpointPublicAccess
    /**
     * The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint. Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The default value is `0.0.0.0/0` and additionally `::/0` for dual-stack `IPv6` clusters. If you've disabled private endpoint access, make sure that you specify the necessary CIDR blocks for every node and Fargate `Pod` in the cluster. For more information, see [Cluster API server endpoint](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
     *
     * Note that the public endpoints are dual-stack for only `IPv6` clusters that are made after October 2024. You can't add `IPv6` CIDR blocks to `IPv4` clusters or `IPv6` clusters that were made before October 2024.
     */
    public val publicAccessCidrs: List<String>? = builder.publicAccessCidrs
    /**
     * The security groups associated with the cross-account elastic network interfaces that are used to allow communication between your nodes and the Kubernetes control plane.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The subnets associated with your cluster.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The VPC associated with your cluster.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.VpcConfigResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcConfigResponse(")
        append("clusterSecurityGroupId=$clusterSecurityGroupId,")
        append("endpointPrivateAccess=$endpointPrivateAccess,")
        append("endpointPublicAccess=$endpointPublicAccess,")
        append("publicAccessCidrs=$publicAccessCidrs,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterSecurityGroupId?.hashCode() ?: 0
        result = 31 * result + (endpointPrivateAccess.hashCode())
        result = 31 * result + (endpointPublicAccess.hashCode())
        result = 31 * result + (publicAccessCidrs?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcConfigResponse

        if (clusterSecurityGroupId != other.clusterSecurityGroupId) return false
        if (endpointPrivateAccess != other.endpointPrivateAccess) return false
        if (endpointPublicAccess != other.endpointPublicAccess) return false
        if (publicAccessCidrs != other.publicAccessCidrs) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.VpcConfigResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The cluster security group that was created by Amazon EKS for the cluster. Managed node groups use this security group for control-plane-to-data-plane communication.
         */
        public var clusterSecurityGroupId: kotlin.String? = null
        /**
         * This parameter indicates whether the Amazon EKS private API server endpoint is enabled. If the Amazon EKS private API server endpoint is enabled, Kubernetes API requests that originate from within your cluster's VPC use the private VPC endpoint instead of traversing the internet. If this value is disabled and you have nodes or Fargate pods in the cluster, then ensure that `publicAccessCidrs` includes the necessary CIDR blocks for communication with the nodes or Fargate pods. For more information, see [Cluster API server endpoint](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
         */
        public var endpointPrivateAccess: kotlin.Boolean = false
        /**
         * Whether the public API server endpoint is enabled.
         */
        public var endpointPublicAccess: kotlin.Boolean = false
        /**
         * The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint. Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The default value is `0.0.0.0/0` and additionally `::/0` for dual-stack `IPv6` clusters. If you've disabled private endpoint access, make sure that you specify the necessary CIDR blocks for every node and Fargate `Pod` in the cluster. For more information, see [Cluster API server endpoint](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
         *
         * Note that the public endpoints are dual-stack for only `IPv6` clusters that are made after October 2024. You can't add `IPv6` CIDR blocks to `IPv4` clusters or `IPv6` clusters that were made before October 2024.
         */
        public var publicAccessCidrs: List<String>? = null
        /**
         * The security groups associated with the cross-account elastic network interfaces that are used to allow communication between your nodes and the Kubernetes control plane.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The subnets associated with your cluster.
         */
        public var subnetIds: List<String>? = null
        /**
         * The VPC associated with your cluster.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.VpcConfigResponse) : this() {
            this.clusterSecurityGroupId = x.clusterSecurityGroupId
            this.endpointPrivateAccess = x.endpointPrivateAccess
            this.endpointPublicAccess = x.endpointPublicAccess
            this.publicAccessCidrs = x.publicAccessCidrs
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.VpcConfigResponse = VpcConfigResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
