// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateNodegroupVersionRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The name of your cluster.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * Force the update if any `Pod` on the existing node group can't be drained due to a `Pod` disruption budget issue. If an update fails because all Pods can't be drained, you can force the update after it fails to terminate the old node whether or not any `Pod` is running on the node.
     */
    public val force: kotlin.Boolean? = builder.force
    /**
     * An object representing a node group's launch template specification. You can only update a node group using a launch template if the node group was originally deployed with a launch template. When updating, you must specify the same launch template ID or name that was used to create the node group.
     */
    public val launchTemplate: aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification? = builder.launchTemplate
    /**
     * The name of the managed node group to update.
     */
    public val nodegroupName: kotlin.String? = builder.nodegroupName
    /**
     * The AMI version of the Amazon EKS optimized AMI to use for the update. By default, the latest available AMI version for the node group's Kubernetes version is used. For information about Linux versions, see [Amazon EKS optimized Amazon Linux AMI versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html) in the *Amazon EKS User Guide*. Amazon EKS managed node groups support the November 2022 and later releases of the Windows AMIs. For information about Windows versions, see [Amazon EKS optimized Windows AMI versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-ami-versions-windows.html) in the *Amazon EKS User Guide*.
     *
     * If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `releaseVersion`, or the node group update will fail. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    public val releaseVersion: kotlin.String? = builder.releaseVersion
    /**
     * The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the node group does not change. You can specify the Kubernetes version of the cluster to update the node group to the latest AMI version of the cluster's Kubernetes version. If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `version`, or the node group update will fail. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.UpdateNodegroupVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateNodegroupVersionRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("clusterName=$clusterName,")
        append("force=$force,")
        append("launchTemplate=$launchTemplate,")
        append("nodegroupName=$nodegroupName,")
        append("releaseVersion=$releaseVersion,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (force?.hashCode() ?: 0)
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        result = 31 * result + (nodegroupName?.hashCode() ?: 0)
        result = 31 * result + (releaseVersion?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateNodegroupVersionRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (clusterName != other.clusterName) return false
        if (force != other.force) return false
        if (launchTemplate != other.launchTemplate) return false
        if (nodegroupName != other.nodegroupName) return false
        if (releaseVersion != other.releaseVersion) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.UpdateNodegroupVersionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The name of your cluster.
         */
        public var clusterName: kotlin.String? = null
        /**
         * Force the update if any `Pod` on the existing node group can't be drained due to a `Pod` disruption budget issue. If an update fails because all Pods can't be drained, you can force the update after it fails to terminate the old node whether or not any `Pod` is running on the node.
         */
        public var force: kotlin.Boolean? = null
        /**
         * An object representing a node group's launch template specification. You can only update a node group using a launch template if the node group was originally deployed with a launch template. When updating, you must specify the same launch template ID or name that was used to create the node group.
         */
        public var launchTemplate: aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification? = null
        /**
         * The name of the managed node group to update.
         */
        public var nodegroupName: kotlin.String? = null
        /**
         * The AMI version of the Amazon EKS optimized AMI to use for the update. By default, the latest available AMI version for the node group's Kubernetes version is used. For information about Linux versions, see [Amazon EKS optimized Amazon Linux AMI versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html) in the *Amazon EKS User Guide*. Amazon EKS managed node groups support the November 2022 and later releases of the Windows AMIs. For information about Windows versions, see [Amazon EKS optimized Windows AMI versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-ami-versions-windows.html) in the *Amazon EKS User Guide*.
         *
         * If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `releaseVersion`, or the node group update will fail. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        public var releaseVersion: kotlin.String? = null
        /**
         * The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the node group does not change. You can specify the Kubernetes version of the cluster to update the node group to the latest AMI version of the cluster's Kubernetes version. If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `version`, or the node group update will fail. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.UpdateNodegroupVersionRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.clusterName = x.clusterName
            this.force = x.force
            this.launchTemplate = x.launchTemplate
            this.nodegroupName = x.nodegroupName
            this.releaseVersion = x.releaseVersion
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.UpdateNodegroupVersionRequest = UpdateNodegroupVersionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification] inside the given [block]
         */
        public fun launchTemplate(block: aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
