// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateClusterConfigRequest private constructor(builder: Builder) {
    /**
     * The access configuration for the cluster.
     */
    public val accessConfig: aws.sdk.kotlin.services.eks.model.UpdateAccessConfigRequest? = builder.accessConfig
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Update the configuration of the compute capability of your EKS Auto Mode cluster. For example, enable the capability.
     */
    public val computeConfig: aws.sdk.kotlin.services.eks.model.ComputeConfigRequest? = builder.computeConfig
    /**
     * Specifies whether to enable or disable deletion protection for the cluster. When enabled (`true`), the cluster cannot be deleted until deletion protection is explicitly disabled. When disabled (`false`), the cluster can be deleted normally.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The Kubernetes network configuration for the cluster.
     */
    public val kubernetesNetworkConfig: aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest? = builder.kubernetesNetworkConfig
    /**
     * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs . By default, cluster control plane logs aren't exported to CloudWatch Logs . For more information, see [Amazon EKS cluster control plane logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html) in the **Amazon EKS User Guide**.
     *
     * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see [CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
     */
    public val logging: aws.sdk.kotlin.services.eks.model.Logging? = builder.logging
    /**
     * The name of the Amazon EKS cluster to update.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The configuration in the cluster for EKS Hybrid Nodes. You can add, change, or remove this configuration after the cluster is created.
     */
    public val remoteNetworkConfig: aws.sdk.kotlin.services.eks.model.RemoteNetworkConfigRequest? = builder.remoteNetworkConfig
    /**
     * An object representing the VPC configuration to use for an Amazon EKS cluster.
     */
    public val resourcesVpcConfig: aws.sdk.kotlin.services.eks.model.VpcConfigRequest? = builder.resourcesVpcConfig
    /**
     * Update the configuration of the block storage capability of your EKS Auto Mode cluster. For example, enable the capability.
     */
    public val storageConfig: aws.sdk.kotlin.services.eks.model.StorageConfigRequest? = builder.storageConfig
    /**
     * You can enable or disable extended support for clusters currently on standard support. You cannot disable extended support once it starts. You must enable extended support before your cluster exits standard support.
     */
    public val upgradePolicy: aws.sdk.kotlin.services.eks.model.UpgradePolicyRequest? = builder.upgradePolicy
    /**
     * Enable or disable ARC zonal shift for the cluster. If zonal shift is enabled, Amazon Web Services configures zonal autoshift for the cluster.
     *
     * Zonal shift is a feature of Amazon Application Recovery Controller (ARC). ARC zonal shift is designed to be a temporary measure that allows you to move traffic for a resource away from an impaired AZ until the zonal shift expires or you cancel it. You can extend the zonal shift if necessary.
     *
     * You can start a zonal shift for an EKS cluster, or you can allow Amazon Web Services to do it for you by enabling *zonal autoshift*. This shift updates the flow of east-to-west network traffic in your cluster to only consider network endpoints for Pods running on worker nodes in healthy AZs. Additionally, any ALB or NLB handling ingress traffic for applications in your EKS cluster will automatically route traffic to targets in the healthy AZs. For more information about zonal shift in EKS, see [Learn about Amazon Application Recovery Controller (ARC) Zonal Shift in Amazon EKS](https://docs.aws.amazon.com/eks/latest/userguide/zone-shift.html) in the **Amazon EKS User Guide**.
     */
    public val zonalShiftConfig: aws.sdk.kotlin.services.eks.model.ZonalShiftConfigRequest? = builder.zonalShiftConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.UpdateClusterConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateClusterConfigRequest(")
        append("accessConfig=$accessConfig,")
        append("clientRequestToken=$clientRequestToken,")
        append("computeConfig=$computeConfig,")
        append("deletionProtection=$deletionProtection,")
        append("kubernetesNetworkConfig=$kubernetesNetworkConfig,")
        append("logging=$logging,")
        append("name=$name,")
        append("remoteNetworkConfig=$remoteNetworkConfig,")
        append("resourcesVpcConfig=$resourcesVpcConfig,")
        append("storageConfig=$storageConfig,")
        append("upgradePolicy=$upgradePolicy,")
        append("zonalShiftConfig=$zonalShiftConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessConfig?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (computeConfig?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (kubernetesNetworkConfig?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (remoteNetworkConfig?.hashCode() ?: 0)
        result = 31 * result + (resourcesVpcConfig?.hashCode() ?: 0)
        result = 31 * result + (storageConfig?.hashCode() ?: 0)
        result = 31 * result + (upgradePolicy?.hashCode() ?: 0)
        result = 31 * result + (zonalShiftConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateClusterConfigRequest

        if (accessConfig != other.accessConfig) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (computeConfig != other.computeConfig) return false
        if (deletionProtection != other.deletionProtection) return false
        if (kubernetesNetworkConfig != other.kubernetesNetworkConfig) return false
        if (logging != other.logging) return false
        if (name != other.name) return false
        if (remoteNetworkConfig != other.remoteNetworkConfig) return false
        if (resourcesVpcConfig != other.resourcesVpcConfig) return false
        if (storageConfig != other.storageConfig) return false
        if (upgradePolicy != other.upgradePolicy) return false
        if (zonalShiftConfig != other.zonalShiftConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.UpdateClusterConfigRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The access configuration for the cluster.
         */
        public var accessConfig: aws.sdk.kotlin.services.eks.model.UpdateAccessConfigRequest? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Update the configuration of the compute capability of your EKS Auto Mode cluster. For example, enable the capability.
         */
        public var computeConfig: aws.sdk.kotlin.services.eks.model.ComputeConfigRequest? = null
        /**
         * Specifies whether to enable or disable deletion protection for the cluster. When enabled (`true`), the cluster cannot be deleted until deletion protection is explicitly disabled. When disabled (`false`), the cluster can be deleted normally.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The Kubernetes network configuration for the cluster.
         */
        public var kubernetesNetworkConfig: aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest? = null
        /**
         * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs . By default, cluster control plane logs aren't exported to CloudWatch Logs . For more information, see [Amazon EKS cluster control plane logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html) in the **Amazon EKS User Guide**.
         *
         * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see [CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
         */
        public var logging: aws.sdk.kotlin.services.eks.model.Logging? = null
        /**
         * The name of the Amazon EKS cluster to update.
         */
        public var name: kotlin.String? = null
        /**
         * The configuration in the cluster for EKS Hybrid Nodes. You can add, change, or remove this configuration after the cluster is created.
         */
        public var remoteNetworkConfig: aws.sdk.kotlin.services.eks.model.RemoteNetworkConfigRequest? = null
        /**
         * An object representing the VPC configuration to use for an Amazon EKS cluster.
         */
        public var resourcesVpcConfig: aws.sdk.kotlin.services.eks.model.VpcConfigRequest? = null
        /**
         * Update the configuration of the block storage capability of your EKS Auto Mode cluster. For example, enable the capability.
         */
        public var storageConfig: aws.sdk.kotlin.services.eks.model.StorageConfigRequest? = null
        /**
         * You can enable or disable extended support for clusters currently on standard support. You cannot disable extended support once it starts. You must enable extended support before your cluster exits standard support.
         */
        public var upgradePolicy: aws.sdk.kotlin.services.eks.model.UpgradePolicyRequest? = null
        /**
         * Enable or disable ARC zonal shift for the cluster. If zonal shift is enabled, Amazon Web Services configures zonal autoshift for the cluster.
         *
         * Zonal shift is a feature of Amazon Application Recovery Controller (ARC). ARC zonal shift is designed to be a temporary measure that allows you to move traffic for a resource away from an impaired AZ until the zonal shift expires or you cancel it. You can extend the zonal shift if necessary.
         *
         * You can start a zonal shift for an EKS cluster, or you can allow Amazon Web Services to do it for you by enabling *zonal autoshift*. This shift updates the flow of east-to-west network traffic in your cluster to only consider network endpoints for Pods running on worker nodes in healthy AZs. Additionally, any ALB or NLB handling ingress traffic for applications in your EKS cluster will automatically route traffic to targets in the healthy AZs. For more information about zonal shift in EKS, see [Learn about Amazon Application Recovery Controller (ARC) Zonal Shift in Amazon EKS](https://docs.aws.amazon.com/eks/latest/userguide/zone-shift.html) in the **Amazon EKS User Guide**.
         */
        public var zonalShiftConfig: aws.sdk.kotlin.services.eks.model.ZonalShiftConfigRequest? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.UpdateClusterConfigRequest) : this() {
            this.accessConfig = x.accessConfig
            this.clientRequestToken = x.clientRequestToken
            this.computeConfig = x.computeConfig
            this.deletionProtection = x.deletionProtection
            this.kubernetesNetworkConfig = x.kubernetesNetworkConfig
            this.logging = x.logging
            this.name = x.name
            this.remoteNetworkConfig = x.remoteNetworkConfig
            this.resourcesVpcConfig = x.resourcesVpcConfig
            this.storageConfig = x.storageConfig
            this.upgradePolicy = x.upgradePolicy
            this.zonalShiftConfig = x.zonalShiftConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.UpdateClusterConfigRequest = UpdateClusterConfigRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.UpdateAccessConfigRequest] inside the given [block]
         */
        public fun accessConfig(block: aws.sdk.kotlin.services.eks.model.UpdateAccessConfigRequest.Builder.() -> kotlin.Unit) {
            this.accessConfig = aws.sdk.kotlin.services.eks.model.UpdateAccessConfigRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.ComputeConfigRequest] inside the given [block]
         */
        public fun computeConfig(block: aws.sdk.kotlin.services.eks.model.ComputeConfigRequest.Builder.() -> kotlin.Unit) {
            this.computeConfig = aws.sdk.kotlin.services.eks.model.ComputeConfigRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest] inside the given [block]
         */
        public fun kubernetesNetworkConfig(block: aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest.Builder.() -> kotlin.Unit) {
            this.kubernetesNetworkConfig = aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.Logging] inside the given [block]
         */
        public fun logging(block: aws.sdk.kotlin.services.eks.model.Logging.Builder.() -> kotlin.Unit) {
            this.logging = aws.sdk.kotlin.services.eks.model.Logging.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.RemoteNetworkConfigRequest] inside the given [block]
         */
        public fun remoteNetworkConfig(block: aws.sdk.kotlin.services.eks.model.RemoteNetworkConfigRequest.Builder.() -> kotlin.Unit) {
            this.remoteNetworkConfig = aws.sdk.kotlin.services.eks.model.RemoteNetworkConfigRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.VpcConfigRequest] inside the given [block]
         */
        public fun resourcesVpcConfig(block: aws.sdk.kotlin.services.eks.model.VpcConfigRequest.Builder.() -> kotlin.Unit) {
            this.resourcesVpcConfig = aws.sdk.kotlin.services.eks.model.VpcConfigRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.StorageConfigRequest] inside the given [block]
         */
        public fun storageConfig(block: aws.sdk.kotlin.services.eks.model.StorageConfigRequest.Builder.() -> kotlin.Unit) {
            this.storageConfig = aws.sdk.kotlin.services.eks.model.StorageConfigRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.UpgradePolicyRequest] inside the given [block]
         */
        public fun upgradePolicy(block: aws.sdk.kotlin.services.eks.model.UpgradePolicyRequest.Builder.() -> kotlin.Unit) {
            this.upgradePolicy = aws.sdk.kotlin.services.eks.model.UpgradePolicyRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.ZonalShiftConfigRequest] inside the given [block]
         */
        public fun zonalShiftConfig(block: aws.sdk.kotlin.services.eks.model.ZonalShiftConfigRequest.Builder.() -> kotlin.Unit) {
            this.zonalShiftConfig = aws.sdk.kotlin.services.eks.model.ZonalShiftConfigRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
