// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * These errors are usually caused by a server-side issue.
 */
public class ServerException private constructor(builder: Builder) : EksException(builder.message) {

    /**
     * The Amazon EKS add-on name associated with the exception.
     */
    public val addonName: kotlin.String? = builder.addonName
    /**
     * The Amazon EKS cluster associated with the exception.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * The Amazon EKS managed node group associated with the exception.
     */
    public val nodegroupName: kotlin.String? = builder.nodegroupName
    /**
     * The Amazon EKS subscription ID with the exception.
     */
    public val subscriptionId: kotlin.String? = builder.subscriptionId

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Server
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.ServerException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerException(")
        append("addonName=$addonName,")
        append("clusterName=$clusterName,")
        append("message=$message,")
        append("nodegroupName=$nodegroupName,")
        append("subscriptionId=$subscriptionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addonName?.hashCode() ?: 0
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (nodegroupName?.hashCode() ?: 0)
        result = 31 * result + (subscriptionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerException

        if (addonName != other.addonName) return false
        if (clusterName != other.clusterName) return false
        if (message != other.message) return false
        if (nodegroupName != other.nodegroupName) return false
        if (subscriptionId != other.subscriptionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.ServerException = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon EKS add-on name associated with the exception.
         */
        public var addonName: kotlin.String? = null
        /**
         * The Amazon EKS cluster associated with the exception.
         */
        public var clusterName: kotlin.String? = null
        /**
         * These errors are usually caused by a server-side issue.
         */
        public var message: kotlin.String? = null
        /**
         * The Amazon EKS managed node group associated with the exception.
         */
        public var nodegroupName: kotlin.String? = null
        /**
         * The Amazon EKS subscription ID with the exception.
         */
        public var subscriptionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.ServerException) : this() {
            this.addonName = x.addonName
            this.clusterName = x.clusterName
            this.message = x.message
            this.nodegroupName = x.nodegroupName
            this.subscriptionId = x.subscriptionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.ServerException = ServerException(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
