// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A network CIDR that can contain pods that run Kubernetes webhooks on hybrid nodes.
 *
 * These CIDR blocks are determined by configuring your Container Network Interface (CNI) plugin. We recommend the Calico CNI or Cilium CNI. Note that the Amazon VPC CNI plugin for Kubernetes isn't available for on-premises and edge locations.
 *
 * Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example, ` 10.2.0.0/16`).
 *
 * It must satisfy the following requirements:
 * + Each block must be within an `IPv4` RFC-1918 network range. Minimum allowed size is /32, maximum allowed size is /8. Publicly-routable addresses aren't supported.
 * + Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of the Kubernetes service IP range.
 */
public class RemotePodNetwork private constructor(builder: Builder) {
    /**
     * A network CIDR that can contain pods that run Kubernetes webhooks on hybrid nodes.
     *
     * These CIDR blocks are determined by configuring your Container Network Interface (CNI) plugin. We recommend the Calico CNI or Cilium CNI. Note that the Amazon VPC CNI plugin for Kubernetes isn't available for on-premises and edge locations.
     *
     * Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example, ` 10.2.0.0/16`).
     *
     * It must satisfy the following requirements:
     * + Each block must be within an `IPv4` RFC-1918 network range. Minimum allowed size is /32, maximum allowed size is /8. Publicly-routable addresses aren't supported.
     * + Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of the Kubernetes service IP range.
     */
    public val cidrs: List<String>? = builder.cidrs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.RemotePodNetwork = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RemotePodNetwork(")
        append("cidrs=$cidrs")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrs?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RemotePodNetwork

        if (cidrs != other.cidrs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.RemotePodNetwork = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A network CIDR that can contain pods that run Kubernetes webhooks on hybrid nodes.
         *
         * These CIDR blocks are determined by configuring your Container Network Interface (CNI) plugin. We recommend the Calico CNI or Cilium CNI. Note that the Amazon VPC CNI plugin for Kubernetes isn't available for on-premises and edge locations.
         *
         * Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example, ` 10.2.0.0/16`).
         *
         * It must satisfy the following requirements:
         * + Each block must be within an `IPv4` RFC-1918 network range. Minimum allowed size is /32, maximum allowed size is /8. Publicly-routable addresses aren't supported.
         * + Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of the Kubernetes service IP range.
         */
        public var cidrs: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.RemotePodNetwork) : this() {
            this.cidrs = x.cidrs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.RemotePodNetwork = RemotePodNetwork(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
