// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object representing the remote access configuration for the managed node group.
 */
public class RemoteAccessConfig private constructor(builder: Builder) {
    /**
     * The Amazon EC2 SSH key name that provides access for SSH communication with the nodes in the managed node group. For more information, see [Amazon EC2 key pairs and Linux instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html) in the *Amazon Elastic Compute Cloud User Guide for Linux Instances*. For Windows, an Amazon EC2 SSH key is used to obtain the RDP password. For more information, see [Amazon EC2 key pairs and Windows instances](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-key-pairs.html) in the *Amazon Elastic Compute Cloud User Guide for Windows Instances*.
     */
    public val ec2SshKey: kotlin.String? = builder.ec2SshKey
    /**
     * The security group IDs that are allowed SSH access (port 22) to the nodes. For Windows, the port is 3389. If you specify an Amazon EC2 SSH key but don't specify a source security group when you create a managed node group, then the port on the nodes is opened to the internet (`0.0.0.0/0`). For more information, see [Security Groups for Your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) in the *Amazon Virtual Private Cloud User Guide*.
     */
    public val sourceSecurityGroups: List<String>? = builder.sourceSecurityGroups

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.RemoteAccessConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RemoteAccessConfig(")
        append("ec2SshKey=$ec2SshKey,")
        append("sourceSecurityGroups=$sourceSecurityGroups")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ec2SshKey?.hashCode() ?: 0
        result = 31 * result + (sourceSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RemoteAccessConfig

        if (ec2SshKey != other.ec2SshKey) return false
        if (sourceSecurityGroups != other.sourceSecurityGroups) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.RemoteAccessConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon EC2 SSH key name that provides access for SSH communication with the nodes in the managed node group. For more information, see [Amazon EC2 key pairs and Linux instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html) in the *Amazon Elastic Compute Cloud User Guide for Linux Instances*. For Windows, an Amazon EC2 SSH key is used to obtain the RDP password. For more information, see [Amazon EC2 key pairs and Windows instances](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-key-pairs.html) in the *Amazon Elastic Compute Cloud User Guide for Windows Instances*.
         */
        public var ec2SshKey: kotlin.String? = null
        /**
         * The security group IDs that are allowed SSH access (port 22) to the nodes. For Windows, the port is 3389. If you specify an Amazon EC2 SSH key but don't specify a source security group when you create a managed node group, then the port on the nodes is opened to the internet (`0.0.0.0/0`). For more information, see [Security Groups for Your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) in the *Amazon Virtual Private Cloud User Guide*.
         */
        public var sourceSecurityGroups: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.RemoteAccessConfig) : this() {
            this.ec2SshKey = x.ec2SshKey
            this.sourceSecurityGroups = x.sourceSecurityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.RemoteAccessConfig = RemoteAccessConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
