// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object representing the configuration for an OpenID Connect (OIDC) identity provider.
 */
public class OidcIdentityProviderConfig private constructor(builder: Builder) {
    /**
     * This is also known as *audience*. The ID of the client application that makes authentication requests to the OIDC identity provider.
     */
    public val clientId: kotlin.String? = builder.clientId
    /**
     * The name of your cluster.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * The JSON web token (JWT) claim that the provider uses to return your groups.
     */
    public val groupsClaim: kotlin.String? = builder.groupsClaim
    /**
     * The prefix that is prepended to group claims to prevent clashes with existing names (such as `system:` groups). For example, the value` oidc:` creates group names like `oidc:engineering` and `oidc:infra`. The prefix can't contain `system:`
     */
    public val groupsPrefix: kotlin.String? = builder.groupsPrefix
    /**
     * The ARN of the configuration.
     */
    public val identityProviderConfigArn: kotlin.String? = builder.identityProviderConfigArn
    /**
     * The name of the configuration.
     */
    public val identityProviderConfigName: kotlin.String? = builder.identityProviderConfigName
    /**
     * The URL of the OIDC identity provider that allows the API server to discover public signing keys for verifying tokens.
     */
    public val issuerUrl: kotlin.String? = builder.issuerUrl
    /**
     * The key-value pairs that describe required claims in the identity token. If set, each claim is verified to be present in the token with a matching value.
     */
    public val requiredClaims: Map<String, String>? = builder.requiredClaims
    /**
     * The status of the OIDC identity provider.
     */
    public val status: aws.sdk.kotlin.services.eks.model.ConfigStatus? = builder.status
    /**
     * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The JSON Web token (JWT) claim that is used as the username.
     */
    public val usernameClaim: kotlin.String? = builder.usernameClaim
    /**
     * The prefix that is prepended to username claims to prevent clashes with existing names. The prefix can't contain `system:`
     */
    public val usernamePrefix: kotlin.String? = builder.usernamePrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.OidcIdentityProviderConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OidcIdentityProviderConfig(")
        append("clientId=$clientId,")
        append("clusterName=$clusterName,")
        append("groupsClaim=$groupsClaim,")
        append("groupsPrefix=$groupsPrefix,")
        append("identityProviderConfigArn=$identityProviderConfigArn,")
        append("identityProviderConfigName=$identityProviderConfigName,")
        append("issuerUrl=$issuerUrl,")
        append("requiredClaims=$requiredClaims,")
        append("status=$status,")
        append("tags=$tags,")
        append("usernameClaim=$usernameClaim,")
        append("usernamePrefix=$usernamePrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientId?.hashCode() ?: 0
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (groupsClaim?.hashCode() ?: 0)
        result = 31 * result + (groupsPrefix?.hashCode() ?: 0)
        result = 31 * result + (identityProviderConfigArn?.hashCode() ?: 0)
        result = 31 * result + (identityProviderConfigName?.hashCode() ?: 0)
        result = 31 * result + (issuerUrl?.hashCode() ?: 0)
        result = 31 * result + (requiredClaims?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (usernameClaim?.hashCode() ?: 0)
        result = 31 * result + (usernamePrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OidcIdentityProviderConfig

        if (clientId != other.clientId) return false
        if (clusterName != other.clusterName) return false
        if (groupsClaim != other.groupsClaim) return false
        if (groupsPrefix != other.groupsPrefix) return false
        if (identityProviderConfigArn != other.identityProviderConfigArn) return false
        if (identityProviderConfigName != other.identityProviderConfigName) return false
        if (issuerUrl != other.issuerUrl) return false
        if (requiredClaims != other.requiredClaims) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (usernameClaim != other.usernameClaim) return false
        if (usernamePrefix != other.usernamePrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.OidcIdentityProviderConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This is also known as *audience*. The ID of the client application that makes authentication requests to the OIDC identity provider.
         */
        public var clientId: kotlin.String? = null
        /**
         * The name of your cluster.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The JSON web token (JWT) claim that the provider uses to return your groups.
         */
        public var groupsClaim: kotlin.String? = null
        /**
         * The prefix that is prepended to group claims to prevent clashes with existing names (such as `system:` groups). For example, the value` oidc:` creates group names like `oidc:engineering` and `oidc:infra`. The prefix can't contain `system:`
         */
        public var groupsPrefix: kotlin.String? = null
        /**
         * The ARN of the configuration.
         */
        public var identityProviderConfigArn: kotlin.String? = null
        /**
         * The name of the configuration.
         */
        public var identityProviderConfigName: kotlin.String? = null
        /**
         * The URL of the OIDC identity provider that allows the API server to discover public signing keys for verifying tokens.
         */
        public var issuerUrl: kotlin.String? = null
        /**
         * The key-value pairs that describe required claims in the identity token. If set, each claim is verified to be present in the token with a matching value.
         */
        public var requiredClaims: Map<String, String>? = null
        /**
         * The status of the OIDC identity provider.
         */
        public var status: aws.sdk.kotlin.services.eks.model.ConfigStatus? = null
        /**
         * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         */
        public var tags: Map<String, String>? = null
        /**
         * The JSON Web token (JWT) claim that is used as the username.
         */
        public var usernameClaim: kotlin.String? = null
        /**
         * The prefix that is prepended to username claims to prevent clashes with existing names. The prefix can't contain `system:`
         */
        public var usernamePrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.OidcIdentityProviderConfig) : this() {
            this.clientId = x.clientId
            this.clusterName = x.clusterName
            this.groupsClaim = x.groupsClaim
            this.groupsPrefix = x.groupsPrefix
            this.identityProviderConfigArn = x.identityProviderConfigArn
            this.identityProviderConfigName = x.identityProviderConfigName
            this.issuerUrl = x.issuerUrl
            this.requiredClaims = x.requiredClaims
            this.status = x.status
            this.tags = x.tags
            this.usernameClaim = x.usernameClaim
            this.usernamePrefix = x.usernamePrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.OidcIdentityProviderConfig = OidcIdentityProviderConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
