// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListUpdatesRequest private constructor(builder: Builder) {
    /**
     * The names of the installed add-ons that have available updates.
     */
    public val addonName: kotlin.String? = builder.addonName
    /**
     * The maximum number of results, returned in paginated output. You receive `maxResults` in a single page, along with a `nextToken` response element. You can see the remaining results of the initial request by sending another request with the returned `nextToken` value. This value can be between 1 and 100. If you don't use this parameter, 100 results and a `nextToken` value, if applicable, are returned.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The name of the Amazon EKS cluster to list updates for.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The `nextToken` value returned from a previous paginated request, where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is null when there are no more results to return.
     *
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the Amazon EKS managed node group to list updates for.
     */
    public val nodegroupName: kotlin.String? = builder.nodegroupName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.ListUpdatesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListUpdatesRequest(")
        append("addonName=$addonName,")
        append("maxResults=$maxResults,")
        append("name=$name,")
        append("nextToken=$nextToken,")
        append("nodegroupName=$nodegroupName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addonName?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (nodegroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListUpdatesRequest

        if (addonName != other.addonName) return false
        if (maxResults != other.maxResults) return false
        if (name != other.name) return false
        if (nextToken != other.nextToken) return false
        if (nodegroupName != other.nodegroupName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.ListUpdatesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The names of the installed add-ons that have available updates.
         */
        public var addonName: kotlin.String? = null
        /**
         * The maximum number of results, returned in paginated output. You receive `maxResults` in a single page, along with a `nextToken` response element. You can see the remaining results of the initial request by sending another request with the returned `nextToken` value. This value can be between 1 and 100. If you don't use this parameter, 100 results and a `nextToken` value, if applicable, are returned.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The name of the Amazon EKS cluster to list updates for.
         */
        public var name: kotlin.String? = null
        /**
         * The `nextToken` value returned from a previous paginated request, where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is null when there are no more results to return.
         *
         * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name of the Amazon EKS managed node group to list updates for.
         */
        public var nodegroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.ListUpdatesRequest) : this() {
            this.addonName = x.addonName
            this.maxResults = x.maxResults
            this.name = x.name
            this.nextToken = x.nextToken
            this.nodegroupName = x.nodegroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.ListUpdatesRequest = ListUpdatesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
