// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Kubernetes network configuration for the cluster.
 */
public class KubernetesNetworkConfigRequest private constructor(builder: Builder) {
    /**
     * Request to enable or disable the load balancing capability on your EKS Auto Mode cluster. For more information, see EKS Auto Mode load balancing capability in the *Amazon EKS User Guide*.
     */
    public val elasticLoadBalancing: aws.sdk.kotlin.services.eks.model.ElasticLoadBalancing? = builder.elasticLoadBalancing
    /**
     * Specify which IP family is used to assign Kubernetes pod and service IP addresses. If you don't specify a value, `ipv4` is used by default. You can only specify an IP family when you create a cluster and can't change this value once the cluster is created. If you specify `ipv6`, the VPC and subnets that you specify for cluster creation must have both `IPv4` and `IPv6` CIDR blocks assigned to them. You can't specify `ipv6` for clusters in China Regions.
     *
     * You can only specify `ipv6` for `1.21` and later clusters that use version `1.10.1` or later of the Amazon VPC CNI add-on. If you specify `ipv6`, then ensure that your VPC meets the requirements listed in the considerations listed in [Assigning IPv6 addresses to pods and services](https://docs.aws.amazon.com/eks/latest/userguide/cni-ipv6.html) in the *Amazon EKS User Guide*. Kubernetes assigns services `IPv6` addresses from the unique local address range `(fc00::/7)`. You can't specify a custom `IPv6` CIDR block. Pod addresses are assigned from the subnet's `IPv6` CIDR.
     */
    public val ipFamily: aws.sdk.kotlin.services.eks.model.IpFamily? = builder.ipFamily
    /**
     * Don't specify a value if you select `ipv6` for **ipFamily**. The CIDR block to assign Kubernetes service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the `10.100.0.0/16` or `172.20.0.0/16` CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. The block must meet the following requirements:
     * + Within one of the following private IP address blocks: `10.0.0.0/8`, `172.16.0.0/12`, or `192.168.0.0/16`.
     * + Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.
     * + Between `/24` and `/12`.
     *
     * You can only specify a custom CIDR block when you create a cluster. You can't change this value after the cluster is created.
     */
    public val serviceIpv4Cidr: kotlin.String? = builder.serviceIpv4Cidr

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KubernetesNetworkConfigRequest(")
        append("elasticLoadBalancing=$elasticLoadBalancing,")
        append("ipFamily=$ipFamily,")
        append("serviceIpv4Cidr=$serviceIpv4Cidr")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = elasticLoadBalancing?.hashCode() ?: 0
        result = 31 * result + (ipFamily?.hashCode() ?: 0)
        result = 31 * result + (serviceIpv4Cidr?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KubernetesNetworkConfigRequest

        if (elasticLoadBalancing != other.elasticLoadBalancing) return false
        if (ipFamily != other.ipFamily) return false
        if (serviceIpv4Cidr != other.serviceIpv4Cidr) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Request to enable or disable the load balancing capability on your EKS Auto Mode cluster. For more information, see EKS Auto Mode load balancing capability in the *Amazon EKS User Guide*.
         */
        public var elasticLoadBalancing: aws.sdk.kotlin.services.eks.model.ElasticLoadBalancing? = null
        /**
         * Specify which IP family is used to assign Kubernetes pod and service IP addresses. If you don't specify a value, `ipv4` is used by default. You can only specify an IP family when you create a cluster and can't change this value once the cluster is created. If you specify `ipv6`, the VPC and subnets that you specify for cluster creation must have both `IPv4` and `IPv6` CIDR blocks assigned to them. You can't specify `ipv6` for clusters in China Regions.
         *
         * You can only specify `ipv6` for `1.21` and later clusters that use version `1.10.1` or later of the Amazon VPC CNI add-on. If you specify `ipv6`, then ensure that your VPC meets the requirements listed in the considerations listed in [Assigning IPv6 addresses to pods and services](https://docs.aws.amazon.com/eks/latest/userguide/cni-ipv6.html) in the *Amazon EKS User Guide*. Kubernetes assigns services `IPv6` addresses from the unique local address range `(fc00::/7)`. You can't specify a custom `IPv6` CIDR block. Pod addresses are assigned from the subnet's `IPv6` CIDR.
         */
        public var ipFamily: aws.sdk.kotlin.services.eks.model.IpFamily? = null
        /**
         * Don't specify a value if you select `ipv6` for **ipFamily**. The CIDR block to assign Kubernetes service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the `10.100.0.0/16` or `172.20.0.0/16` CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. The block must meet the following requirements:
         * + Within one of the following private IP address blocks: `10.0.0.0/8`, `172.16.0.0/12`, or `192.168.0.0/16`.
         * + Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.
         * + Between `/24` and `/12`.
         *
         * You can only specify a custom CIDR block when you create a cluster. You can't change this value after the cluster is created.
         */
        public var serviceIpv4Cidr: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest) : this() {
            this.elasticLoadBalancing = x.elasticLoadBalancing
            this.ipFamily = x.ipFamily
            this.serviceIpv4Cidr = x.serviceIpv4Cidr
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest = KubernetesNetworkConfigRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.ElasticLoadBalancing] inside the given [block]
         */
        public fun elasticLoadBalancing(block: aws.sdk.kotlin.services.eks.model.ElasticLoadBalancing.Builder.() -> kotlin.Unit) {
            this.elasticLoadBalancing = aws.sdk.kotlin.services.eks.model.ElasticLoadBalancing.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
