// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The criteria to use for the insights.
 */
public class InsightsFilter private constructor(builder: Builder) {
    /**
     * The categories to use to filter insights. The following lists the available categories:
     * + `UPGRADE_READINESS`: Amazon EKS identifies issues that could impact your ability to upgrade to new versions of Kubernetes. These are called upgrade insights.
     * + `MISCONFIGURATION`: Amazon EKS identifies misconfiguration in your EKS Hybrid Nodes setup that could impair functionality of your cluster or workloads. These are called configuration insights.
     */
    public val categories: List<Category>? = builder.categories
    /**
     * The Kubernetes versions to use to filter the insights.
     */
    public val kubernetesVersions: List<String>? = builder.kubernetesVersions
    /**
     * The statuses to use to filter the insights.
     */
    public val statuses: List<InsightStatusValue>? = builder.statuses

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.InsightsFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InsightsFilter(")
        append("categories=$categories,")
        append("kubernetesVersions=$kubernetesVersions,")
        append("statuses=$statuses")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = categories?.hashCode() ?: 0
        result = 31 * result + (kubernetesVersions?.hashCode() ?: 0)
        result = 31 * result + (statuses?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InsightsFilter

        if (categories != other.categories) return false
        if (kubernetesVersions != other.kubernetesVersions) return false
        if (statuses != other.statuses) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.InsightsFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The categories to use to filter insights. The following lists the available categories:
         * + `UPGRADE_READINESS`: Amazon EKS identifies issues that could impact your ability to upgrade to new versions of Kubernetes. These are called upgrade insights.
         * + `MISCONFIGURATION`: Amazon EKS identifies misconfiguration in your EKS Hybrid Nodes setup that could impair functionality of your cluster or workloads. These are called configuration insights.
         */
        public var categories: List<Category>? = null
        /**
         * The Kubernetes versions to use to filter the insights.
         */
        public var kubernetesVersions: List<String>? = null
        /**
         * The statuses to use to filter the insights.
         */
        public var statuses: List<InsightStatusValue>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.InsightsFilter) : this() {
            this.categories = x.categories
            this.kubernetesVersions = x.kubernetesVersions
            this.statuses = x.statuses
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.InsightsFilter = InsightsFilter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
