// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A check that provides recommendations to remedy potential upgrade-impacting issues.
 */
public class Insight private constructor(builder: Builder) {
    /**
     * Links to sources that provide additional context on the insight.
     */
    public val additionalInfo: Map<String, String>? = builder.additionalInfo
    /**
     * The category of the insight.
     */
    public val category: aws.sdk.kotlin.services.eks.model.Category? = builder.category
    /**
     * Summary information that relates to the category of the insight. Currently only returned with certain insights having category `UPGRADE_READINESS`.
     */
    public val categorySpecificSummary: aws.sdk.kotlin.services.eks.model.InsightCategorySpecificSummary? = builder.categorySpecificSummary
    /**
     * The description of the insight which includes alert criteria, remediation recommendation, and additional resources (contains Markdown).
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the insight.
     */
    public val id: kotlin.String? = builder.id
    /**
     * An object containing more detail on the status of the insight resource.
     */
    public val insightStatus: aws.sdk.kotlin.services.eks.model.InsightStatus? = builder.insightStatus
    /**
     * The Kubernetes minor version associated with an insight if applicable.
     */
    public val kubernetesVersion: kotlin.String? = builder.kubernetesVersion
    /**
     * The time Amazon EKS last successfully completed a refresh of this insight check on the cluster.
     */
    public val lastRefreshTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRefreshTime
    /**
     * The time the status of the insight last changed.
     */
    public val lastTransitionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastTransitionTime
    /**
     * The name of the insight.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A summary of how to remediate the finding of this insight if applicable.
     */
    public val recommendation: kotlin.String? = builder.recommendation
    /**
     * The details about each resource listed in the insight check result.
     */
    public val resources: List<InsightResourceDetail>? = builder.resources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.Insight = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Insight(")
        append("additionalInfo=$additionalInfo,")
        append("category=$category,")
        append("categorySpecificSummary=$categorySpecificSummary,")
        append("description=$description,")
        append("id=$id,")
        append("insightStatus=$insightStatus,")
        append("kubernetesVersion=$kubernetesVersion,")
        append("lastRefreshTime=$lastRefreshTime,")
        append("lastTransitionTime=$lastTransitionTime,")
        append("name=$name,")
        append("recommendation=$recommendation,")
        append("resources=$resources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInfo?.hashCode() ?: 0
        result = 31 * result + (category?.hashCode() ?: 0)
        result = 31 * result + (categorySpecificSummary?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (insightStatus?.hashCode() ?: 0)
        result = 31 * result + (kubernetesVersion?.hashCode() ?: 0)
        result = 31 * result + (lastRefreshTime?.hashCode() ?: 0)
        result = 31 * result + (lastTransitionTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (recommendation?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Insight

        if (additionalInfo != other.additionalInfo) return false
        if (category != other.category) return false
        if (categorySpecificSummary != other.categorySpecificSummary) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (insightStatus != other.insightStatus) return false
        if (kubernetesVersion != other.kubernetesVersion) return false
        if (lastRefreshTime != other.lastRefreshTime) return false
        if (lastTransitionTime != other.lastTransitionTime) return false
        if (name != other.name) return false
        if (recommendation != other.recommendation) return false
        if (resources != other.resources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.Insight = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Links to sources that provide additional context on the insight.
         */
        public var additionalInfo: Map<String, String>? = null
        /**
         * The category of the insight.
         */
        public var category: aws.sdk.kotlin.services.eks.model.Category? = null
        /**
         * Summary information that relates to the category of the insight. Currently only returned with certain insights having category `UPGRADE_READINESS`.
         */
        public var categorySpecificSummary: aws.sdk.kotlin.services.eks.model.InsightCategorySpecificSummary? = null
        /**
         * The description of the insight which includes alert criteria, remediation recommendation, and additional resources (contains Markdown).
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the insight.
         */
        public var id: kotlin.String? = null
        /**
         * An object containing more detail on the status of the insight resource.
         */
        public var insightStatus: aws.sdk.kotlin.services.eks.model.InsightStatus? = null
        /**
         * The Kubernetes minor version associated with an insight if applicable.
         */
        public var kubernetesVersion: kotlin.String? = null
        /**
         * The time Amazon EKS last successfully completed a refresh of this insight check on the cluster.
         */
        public var lastRefreshTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time the status of the insight last changed.
         */
        public var lastTransitionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the insight.
         */
        public var name: kotlin.String? = null
        /**
         * A summary of how to remediate the finding of this insight if applicable.
         */
        public var recommendation: kotlin.String? = null
        /**
         * The details about each resource listed in the insight check result.
         */
        public var resources: List<InsightResourceDetail>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.Insight) : this() {
            this.additionalInfo = x.additionalInfo
            this.category = x.category
            this.categorySpecificSummary = x.categorySpecificSummary
            this.description = x.description
            this.id = x.id
            this.insightStatus = x.insightStatus
            this.kubernetesVersion = x.kubernetesVersion
            this.lastRefreshTime = x.lastRefreshTime
            this.lastTransitionTime = x.lastTransitionTime
            this.name = x.name
            this.recommendation = x.recommendation
            this.resources = x.resources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.Insight = Insight(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.InsightCategorySpecificSummary] inside the given [block]
         */
        public fun categorySpecificSummary(block: aws.sdk.kotlin.services.eks.model.InsightCategorySpecificSummary.Builder.() -> kotlin.Unit) {
            this.categorySpecificSummary = aws.sdk.kotlin.services.eks.model.InsightCategorySpecificSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.InsightStatus] inside the given [block]
         */
        public fun insightStatus(block: aws.sdk.kotlin.services.eks.model.InsightStatus.Builder.() -> kotlin.Unit) {
            this.insightStatus = aws.sdk.kotlin.services.eks.model.InsightStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
