// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An EKS Anywhere subscription authorizing the customer to support for licensed clusters and access to EKS Anywhere Curated Packages.
 */
public class EksAnywhereSubscription private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the subscription.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A boolean indicating whether or not a subscription will auto renew when it expires.
     */
    public val autoRenew: kotlin.Boolean = builder.autoRenew
    /**
     * The Unix timestamp in seconds for when the subscription was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Unix timestamp in seconds for when the subscription is effective.
     */
    public val effectiveDate: aws.smithy.kotlin.runtime.time.Instant? = builder.effectiveDate
    /**
     * The Unix timestamp in seconds for when the subscription will expire or auto renew, depending on the auto renew configuration of the subscription object.
     */
    public val expirationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationDate
    /**
     * UUID identifying a subscription.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Amazon Web Services License Manager ARN associated with the subscription.
     */
    public val licenseArns: List<String>? = builder.licenseArns
    /**
     * The number of licenses included in a subscription. Valid values are between 1 and 100.
     */
    public val licenseQuantity: kotlin.Int = builder.licenseQuantity
    /**
     * The type of licenses included in the subscription. Valid value is CLUSTER. With the CLUSTER license type, each license covers support for a single EKS Anywhere cluster.
     */
    public val licenseType: aws.sdk.kotlin.services.eks.model.EksAnywhereSubscriptionLicenseType? = builder.licenseType
    /**
     * Includes all of the claims in the license token necessary to validate the license for extended support.
     */
    public val licenses: List<License>? = builder.licenses
    /**
     * The status of a subscription.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The metadata for a subscription to assist with categorization and organization. Each tag consists of a key and an optional value. Subscription tags do not propagate to any other resources associated with the subscription.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * An EksAnywhereSubscriptionTerm object.
     */
    public val term: aws.sdk.kotlin.services.eks.model.EksAnywhereSubscriptionTerm? = builder.term

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.EksAnywhereSubscription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EksAnywhereSubscription(")
        append("arn=$arn,")
        append("autoRenew=$autoRenew,")
        append("createdAt=$createdAt,")
        append("effectiveDate=$effectiveDate,")
        append("expirationDate=$expirationDate,")
        append("id=$id,")
        append("licenseArns=$licenseArns,")
        append("licenseQuantity=$licenseQuantity,")
        append("licenseType=$licenseType,")
        append("licenses=$licenses,")
        append("status=$status,")
        append("tags=$tags,")
        append("term=$term")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (autoRenew.hashCode())
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (effectiveDate?.hashCode() ?: 0)
        result = 31 * result + (expirationDate?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (licenseArns?.hashCode() ?: 0)
        result = 31 * result + (licenseQuantity)
        result = 31 * result + (licenseType?.hashCode() ?: 0)
        result = 31 * result + (licenses?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (term?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EksAnywhereSubscription

        if (arn != other.arn) return false
        if (autoRenew != other.autoRenew) return false
        if (createdAt != other.createdAt) return false
        if (effectiveDate != other.effectiveDate) return false
        if (expirationDate != other.expirationDate) return false
        if (id != other.id) return false
        if (licenseArns != other.licenseArns) return false
        if (licenseQuantity != other.licenseQuantity) return false
        if (licenseType != other.licenseType) return false
        if (licenses != other.licenses) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (term != other.term) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.EksAnywhereSubscription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the subscription.
         */
        public var arn: kotlin.String? = null
        /**
         * A boolean indicating whether or not a subscription will auto renew when it expires.
         */
        public var autoRenew: kotlin.Boolean = false
        /**
         * The Unix timestamp in seconds for when the subscription was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Unix timestamp in seconds for when the subscription is effective.
         */
        public var effectiveDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Unix timestamp in seconds for when the subscription will expire or auto renew, depending on the auto renew configuration of the subscription object.
         */
        public var expirationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * UUID identifying a subscription.
         */
        public var id: kotlin.String? = null
        /**
         * Amazon Web Services License Manager ARN associated with the subscription.
         */
        public var licenseArns: List<String>? = null
        /**
         * The number of licenses included in a subscription. Valid values are between 1 and 100.
         */
        public var licenseQuantity: kotlin.Int = 0
        /**
         * The type of licenses included in the subscription. Valid value is CLUSTER. With the CLUSTER license type, each license covers support for a single EKS Anywhere cluster.
         */
        public var licenseType: aws.sdk.kotlin.services.eks.model.EksAnywhereSubscriptionLicenseType? = null
        /**
         * Includes all of the claims in the license token necessary to validate the license for extended support.
         */
        public var licenses: List<License>? = null
        /**
         * The status of a subscription.
         */
        public var status: kotlin.String? = null
        /**
         * The metadata for a subscription to assist with categorization and organization. Each tag consists of a key and an optional value. Subscription tags do not propagate to any other resources associated with the subscription.
         */
        public var tags: Map<String, String>? = null
        /**
         * An EksAnywhereSubscriptionTerm object.
         */
        public var term: aws.sdk.kotlin.services.eks.model.EksAnywhereSubscriptionTerm? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.EksAnywhereSubscription) : this() {
            this.arn = x.arn
            this.autoRenew = x.autoRenew
            this.createdAt = x.createdAt
            this.effectiveDate = x.effectiveDate
            this.expirationDate = x.expirationDate
            this.id = x.id
            this.licenseArns = x.licenseArns
            this.licenseQuantity = x.licenseQuantity
            this.licenseType = x.licenseType
            this.licenses = x.licenses
            this.status = x.status
            this.tags = x.tags
            this.term = x.term
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.EksAnywhereSubscription = EksAnywhereSubscription(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.EksAnywhereSubscriptionTerm] inside the given [block]
         */
        public fun term(block: aws.sdk.kotlin.services.eks.model.EksAnywhereSubscriptionTerm.Builder.() -> kotlin.Unit) {
            this.term = aws.sdk.kotlin.services.eks.model.EksAnywhereSubscriptionTerm.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
