// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeAddonVersionsRequest private constructor(builder: Builder) {
    /**
     * The name of the add-on. The name must match one of the names returned by `ListAddons`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html).
     */
    public val addonName: kotlin.String? = builder.addonName
    /**
     * The Kubernetes versions that you can use the add-on with.
     */
    public val kubernetesVersion: kotlin.String? = builder.kubernetesVersion
    /**
     * The maximum number of results, returned in paginated output. You receive `maxResults` in a single page, along with a `nextToken` response element. You can see the remaining results of the initial request by sending another request with the returned `nextToken` value. This value can be between 1 and 100. If you don't use this parameter, 100 results and a `nextToken` value, if applicable, are returned.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `nextToken` value returned from a previous paginated request, where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is null when there are no more results to return.
     *
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The owner of the add-on. For valid `owners`, don't specify a value for this property.
     */
    public val owners: List<String>? = builder.owners
    /**
     * The publisher of the add-on. For valid `publishers`, don't specify a value for this property.
     */
    public val publishers: List<String>? = builder.publishers
    /**
     * The type of the add-on. For valid `types`, don't specify a value for this property.
     */
    public val types: List<String>? = builder.types

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.DescribeAddonVersionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeAddonVersionsRequest(")
        append("addonName=$addonName,")
        append("kubernetesVersion=$kubernetesVersion,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("owners=$owners,")
        append("publishers=$publishers,")
        append("types=$types")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addonName?.hashCode() ?: 0
        result = 31 * result + (kubernetesVersion?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (owners?.hashCode() ?: 0)
        result = 31 * result + (publishers?.hashCode() ?: 0)
        result = 31 * result + (types?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeAddonVersionsRequest

        if (addonName != other.addonName) return false
        if (kubernetesVersion != other.kubernetesVersion) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (owners != other.owners) return false
        if (publishers != other.publishers) return false
        if (types != other.types) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.DescribeAddonVersionsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the add-on. The name must match one of the names returned by `ListAddons`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html).
         */
        public var addonName: kotlin.String? = null
        /**
         * The Kubernetes versions that you can use the add-on with.
         */
        public var kubernetesVersion: kotlin.String? = null
        /**
         * The maximum number of results, returned in paginated output. You receive `maxResults` in a single page, along with a `nextToken` response element. You can see the remaining results of the initial request by sending another request with the returned `nextToken` value. This value can be between 1 and 100. If you don't use this parameter, 100 results and a `nextToken` value, if applicable, are returned.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The `nextToken` value returned from a previous paginated request, where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is null when there are no more results to return.
         *
         * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The owner of the add-on. For valid `owners`, don't specify a value for this property.
         */
        public var owners: List<String>? = null
        /**
         * The publisher of the add-on. For valid `publishers`, don't specify a value for this property.
         */
        public var publishers: List<String>? = null
        /**
         * The type of the add-on. For valid `types`, don't specify a value for this property.
         */
        public var types: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.DescribeAddonVersionsRequest) : this() {
            this.addonName = x.addonName
            this.kubernetesVersion = x.kubernetesVersion
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.owners = x.owners
            this.publishers = x.publishers
            this.types = x.types
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.DescribeAddonVersionsRequest = DescribeAddonVersionsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
