// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateNodegroupRequest private constructor(builder: Builder) {
    /**
     * The AMI type for your node group. If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `amiType`, or the node group deployment will fail. If your launch template uses a Windows custom AMI, then add `eks:kube-proxy-windows` to your Windows nodes `rolearn` in the `aws-auth``ConfigMap`. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    public val amiType: aws.sdk.kotlin.services.eks.model.AmiTypes? = builder.amiType
    /**
     * The capacity type for your node group.
     */
    public val capacityType: aws.sdk.kotlin.services.eks.model.CapacityTypes? = builder.capacityType
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The name of your cluster.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * The root device disk size (in GiB) for your node group instances. The default disk size is 20 GiB for Linux and Bottlerocket. The default disk size is 50 GiB for Windows. If you specify `launchTemplate`, then don't specify `diskSize`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    public val diskSize: kotlin.Int? = builder.diskSize
    /**
     * Specify the instance types for a node group. If you specify a GPU instance type, make sure to also specify an applicable GPU AMI type with the `amiType` parameter. If you specify `launchTemplate`, then you can specify zero or one instance type in your launch template *or* you can specify 0-20 instance types for `instanceTypes`. If however, you specify an instance type in your launch template *and* specify any `instanceTypes`, the node group deployment will fail. If you don't specify an instance type in a launch template or for `instanceTypes`, then `t3.medium` is used, by default. If you specify `Spot` for `capacityType`, then we recommend specifying multiple values for `instanceTypes`. For more information, see [Managed node group capacity types](https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types) and [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    public val instanceTypes: List<String>? = builder.instanceTypes
    /**
     * The Kubernetes `labels` to apply to the nodes in the node group when they are created.
     */
    public val labels: Map<String, String>? = builder.labels
    /**
     * An object representing a node group's launch template specification. When using this object, don't directly specify `instanceTypes`, `diskSize`, or `remoteAccess`. You cannot later specify a different launch template ID or name than what was used to create the node group.
     *
     * Make sure that the launch template meets the requirements in `launchTemplateSpecification`. Also refer to [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    public val launchTemplate: aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification? = builder.launchTemplate
    /**
     * The node auto repair configuration for the node group.
     */
    public val nodeRepairConfig: aws.sdk.kotlin.services.eks.model.NodeRepairConfig? = builder.nodeRepairConfig
    /**
     * The Amazon Resource Name (ARN) of the IAM role to associate with your node group. The Amazon EKS worker node `kubelet` daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive permissions for these API calls through an IAM instance profile and associated policies. Before you can launch nodes and register them into a cluster, you must create an IAM role for those nodes to use when they are launched. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html) in the **Amazon EKS User Guide**. If you specify `launchTemplate`, then don't specify ` <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html">IamInstanceProfile</a> ` in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    public val nodeRole: kotlin.String? = builder.nodeRole
    /**
     * The unique name to give your node group.
     */
    public val nodegroupName: kotlin.String? = builder.nodegroupName
    /**
     * The AMI version of the Amazon EKS optimized AMI to use with your node group. By default, the latest available AMI version for the node group's current Kubernetes version is used. For information about Linux versions, see [Amazon EKS optimized Amazon Linux AMI versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html) in the *Amazon EKS User Guide*. Amazon EKS managed node groups support the November 2022 and later releases of the Windows AMIs. For information about Windows versions, see [Amazon EKS optimized Windows AMI versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-ami-versions-windows.html) in the *Amazon EKS User Guide*.
     *
     * If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `releaseVersion`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    public val releaseVersion: kotlin.String? = builder.releaseVersion
    /**
     * The remote access configuration to use with your node group. For Linux, the protocol is SSH. For Windows, the protocol is RDP. If you specify `launchTemplate`, then don't specify `remoteAccess`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    public val remoteAccess: aws.sdk.kotlin.services.eks.model.RemoteAccessConfig? = builder.remoteAccess
    /**
     * The scaling configuration details for the Auto Scaling group that is created for your node group.
     */
    public val scalingConfig: aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig? = builder.scalingConfig
    /**
     * The subnets to use for the Auto Scaling group that is created for your node group. If you specify `launchTemplate`, then don't specify ` <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html">SubnetId</a> ` in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    public val subnets: List<String>? = builder.subnets
    /**
     * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The Kubernetes taints to be applied to the nodes in the node group. For more information, see [Node taints on managed node groups](https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html).
     */
    public val taints: List<Taint>? = builder.taints
    /**
     * The node group update configuration.
     */
    public val updateConfig: aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig? = builder.updateConfig
    /**
     * The Kubernetes version to use for your managed nodes. By default, the Kubernetes version of the cluster is used, and this is the only accepted specified value. If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `version`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.CreateNodegroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateNodegroupRequest(")
        append("amiType=$amiType,")
        append("capacityType=$capacityType,")
        append("clientRequestToken=$clientRequestToken,")
        append("clusterName=$clusterName,")
        append("diskSize=$diskSize,")
        append("instanceTypes=$instanceTypes,")
        append("labels=$labels,")
        append("launchTemplate=$launchTemplate,")
        append("nodeRepairConfig=$nodeRepairConfig,")
        append("nodeRole=$nodeRole,")
        append("nodegroupName=$nodegroupName,")
        append("releaseVersion=$releaseVersion,")
        append("remoteAccess=$remoteAccess,")
        append("scalingConfig=$scalingConfig,")
        append("subnets=$subnets,")
        append("tags=$tags,")
        append("taints=$taints,")
        append("updateConfig=$updateConfig,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = amiType?.hashCode() ?: 0
        result = 31 * result + (capacityType?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (diskSize ?: 0)
        result = 31 * result + (instanceTypes?.hashCode() ?: 0)
        result = 31 * result + (labels?.hashCode() ?: 0)
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        result = 31 * result + (nodeRepairConfig?.hashCode() ?: 0)
        result = 31 * result + (nodeRole?.hashCode() ?: 0)
        result = 31 * result + (nodegroupName?.hashCode() ?: 0)
        result = 31 * result + (releaseVersion?.hashCode() ?: 0)
        result = 31 * result + (remoteAccess?.hashCode() ?: 0)
        result = 31 * result + (scalingConfig?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taints?.hashCode() ?: 0)
        result = 31 * result + (updateConfig?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateNodegroupRequest

        if (amiType != other.amiType) return false
        if (capacityType != other.capacityType) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (clusterName != other.clusterName) return false
        if (diskSize != other.diskSize) return false
        if (instanceTypes != other.instanceTypes) return false
        if (labels != other.labels) return false
        if (launchTemplate != other.launchTemplate) return false
        if (nodeRepairConfig != other.nodeRepairConfig) return false
        if (nodeRole != other.nodeRole) return false
        if (nodegroupName != other.nodegroupName) return false
        if (releaseVersion != other.releaseVersion) return false
        if (remoteAccess != other.remoteAccess) return false
        if (scalingConfig != other.scalingConfig) return false
        if (subnets != other.subnets) return false
        if (tags != other.tags) return false
        if (taints != other.taints) return false
        if (updateConfig != other.updateConfig) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.CreateNodegroupRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The AMI type for your node group. If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `amiType`, or the node group deployment will fail. If your launch template uses a Windows custom AMI, then add `eks:kube-proxy-windows` to your Windows nodes `rolearn` in the `aws-auth``ConfigMap`. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        public var amiType: aws.sdk.kotlin.services.eks.model.AmiTypes? = null
        /**
         * The capacity type for your node group.
         */
        public var capacityType: aws.sdk.kotlin.services.eks.model.CapacityTypes? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The name of your cluster.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The root device disk size (in GiB) for your node group instances. The default disk size is 20 GiB for Linux and Bottlerocket. The default disk size is 50 GiB for Windows. If you specify `launchTemplate`, then don't specify `diskSize`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        public var diskSize: kotlin.Int? = null
        /**
         * Specify the instance types for a node group. If you specify a GPU instance type, make sure to also specify an applicable GPU AMI type with the `amiType` parameter. If you specify `launchTemplate`, then you can specify zero or one instance type in your launch template *or* you can specify 0-20 instance types for `instanceTypes`. If however, you specify an instance type in your launch template *and* specify any `instanceTypes`, the node group deployment will fail. If you don't specify an instance type in a launch template or for `instanceTypes`, then `t3.medium` is used, by default. If you specify `Spot` for `capacityType`, then we recommend specifying multiple values for `instanceTypes`. For more information, see [Managed node group capacity types](https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types) and [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        public var instanceTypes: List<String>? = null
        /**
         * The Kubernetes `labels` to apply to the nodes in the node group when they are created.
         */
        public var labels: Map<String, String>? = null
        /**
         * An object representing a node group's launch template specification. When using this object, don't directly specify `instanceTypes`, `diskSize`, or `remoteAccess`. You cannot later specify a different launch template ID or name than what was used to create the node group.
         *
         * Make sure that the launch template meets the requirements in `launchTemplateSpecification`. Also refer to [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        public var launchTemplate: aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification? = null
        /**
         * The node auto repair configuration for the node group.
         */
        public var nodeRepairConfig: aws.sdk.kotlin.services.eks.model.NodeRepairConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role to associate with your node group. The Amazon EKS worker node `kubelet` daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive permissions for these API calls through an IAM instance profile and associated policies. Before you can launch nodes and register them into a cluster, you must create an IAM role for those nodes to use when they are launched. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html) in the **Amazon EKS User Guide**. If you specify `launchTemplate`, then don't specify ` <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html">IamInstanceProfile</a> ` in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        public var nodeRole: kotlin.String? = null
        /**
         * The unique name to give your node group.
         */
        public var nodegroupName: kotlin.String? = null
        /**
         * The AMI version of the Amazon EKS optimized AMI to use with your node group. By default, the latest available AMI version for the node group's current Kubernetes version is used. For information about Linux versions, see [Amazon EKS optimized Amazon Linux AMI versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html) in the *Amazon EKS User Guide*. Amazon EKS managed node groups support the November 2022 and later releases of the Windows AMIs. For information about Windows versions, see [Amazon EKS optimized Windows AMI versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-ami-versions-windows.html) in the *Amazon EKS User Guide*.
         *
         * If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `releaseVersion`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        public var releaseVersion: kotlin.String? = null
        /**
         * The remote access configuration to use with your node group. For Linux, the protocol is SSH. For Windows, the protocol is RDP. If you specify `launchTemplate`, then don't specify `remoteAccess`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        public var remoteAccess: aws.sdk.kotlin.services.eks.model.RemoteAccessConfig? = null
        /**
         * The scaling configuration details for the Auto Scaling group that is created for your node group.
         */
        public var scalingConfig: aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig? = null
        /**
         * The subnets to use for the Auto Scaling group that is created for your node group. If you specify `launchTemplate`, then don't specify ` <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html">SubnetId</a> ` in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        public var subnets: List<String>? = null
        /**
         * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         */
        public var tags: Map<String, String>? = null
        /**
         * The Kubernetes taints to be applied to the nodes in the node group. For more information, see [Node taints on managed node groups](https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html).
         */
        public var taints: List<Taint>? = null
        /**
         * The node group update configuration.
         */
        public var updateConfig: aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig? = null
        /**
         * The Kubernetes version to use for your managed nodes. By default, the Kubernetes version of the cluster is used, and this is the only accepted specified value. If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `version`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.CreateNodegroupRequest) : this() {
            this.amiType = x.amiType
            this.capacityType = x.capacityType
            this.clientRequestToken = x.clientRequestToken
            this.clusterName = x.clusterName
            this.diskSize = x.diskSize
            this.instanceTypes = x.instanceTypes
            this.labels = x.labels
            this.launchTemplate = x.launchTemplate
            this.nodeRepairConfig = x.nodeRepairConfig
            this.nodeRole = x.nodeRole
            this.nodegroupName = x.nodegroupName
            this.releaseVersion = x.releaseVersion
            this.remoteAccess = x.remoteAccess
            this.scalingConfig = x.scalingConfig
            this.subnets = x.subnets
            this.tags = x.tags
            this.taints = x.taints
            this.updateConfig = x.updateConfig
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.CreateNodegroupRequest = CreateNodegroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification] inside the given [block]
         */
        public fun launchTemplate(block: aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.NodeRepairConfig] inside the given [block]
         */
        public fun nodeRepairConfig(block: aws.sdk.kotlin.services.eks.model.NodeRepairConfig.Builder.() -> kotlin.Unit) {
            this.nodeRepairConfig = aws.sdk.kotlin.services.eks.model.NodeRepairConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.RemoteAccessConfig] inside the given [block]
         */
        public fun remoteAccess(block: aws.sdk.kotlin.services.eks.model.RemoteAccessConfig.Builder.() -> kotlin.Unit) {
            this.remoteAccess = aws.sdk.kotlin.services.eks.model.RemoteAccessConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig] inside the given [block]
         */
        public fun scalingConfig(block: aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig.Builder.() -> kotlin.Unit) {
            this.scalingConfig = aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig] inside the given [block]
         */
        public fun updateConfig(block: aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig.Builder.() -> kotlin.Unit) {
            this.updateConfig = aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
