// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateFargateProfileRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The name of your cluster.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * The name of the Fargate profile.
     */
    public val fargateProfileName: kotlin.String? = builder.fargateProfileName
    /**
     * The Amazon Resource Name (ARN) of the `Pod` execution role to use for a `Pod` that matches the selectors in the Fargate profile. The `Pod` execution role allows Fargate infrastructure to register with your cluster as a node, and it provides read access to Amazon ECR image repositories. For more information, see `Pod`[ execution role](https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html) in the *Amazon EKS User Guide*.
     */
    public val podExecutionRoleArn: kotlin.String? = builder.podExecutionRoleArn
    /**
     * The selectors to match for a `Pod` to use this Fargate profile. Each selector must have an associated Kubernetes `namespace`. Optionally, you can also specify `labels` for a `namespace`. You may specify up to five selectors in a Fargate profile.
     */
    public val selectors: List<FargateProfileSelector>? = builder.selectors
    /**
     * The IDs of subnets to launch a `Pod` into. A `Pod` running on Fargate isn't assigned a public IP address, so only private subnets (with no direct route to an Internet Gateway) are accepted for this parameter.
     */
    public val subnets: List<String>? = builder.subnets
    /**
     * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.CreateFargateProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFargateProfileRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("clusterName=$clusterName,")
        append("fargateProfileName=$fargateProfileName,")
        append("podExecutionRoleArn=$podExecutionRoleArn,")
        append("selectors=$selectors,")
        append("subnets=$subnets,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (fargateProfileName?.hashCode() ?: 0)
        result = 31 * result + (podExecutionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (selectors?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFargateProfileRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (clusterName != other.clusterName) return false
        if (fargateProfileName != other.fargateProfileName) return false
        if (podExecutionRoleArn != other.podExecutionRoleArn) return false
        if (selectors != other.selectors) return false
        if (subnets != other.subnets) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.CreateFargateProfileRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The name of your cluster.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The name of the Fargate profile.
         */
        public var fargateProfileName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the `Pod` execution role to use for a `Pod` that matches the selectors in the Fargate profile. The `Pod` execution role allows Fargate infrastructure to register with your cluster as a node, and it provides read access to Amazon ECR image repositories. For more information, see `Pod`[ execution role](https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html) in the *Amazon EKS User Guide*.
         */
        public var podExecutionRoleArn: kotlin.String? = null
        /**
         * The selectors to match for a `Pod` to use this Fargate profile. Each selector must have an associated Kubernetes `namespace`. Optionally, you can also specify `labels` for a `namespace`. You may specify up to five selectors in a Fargate profile.
         */
        public var selectors: List<FargateProfileSelector>? = null
        /**
         * The IDs of subnets to launch a `Pod` into. A `Pod` running on Fargate isn't assigned a public IP address, so only private subnets (with no direct route to an Internet Gateway) are accepted for this parameter.
         */
        public var subnets: List<String>? = null
        /**
         * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.CreateFargateProfileRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.clusterName = x.clusterName
            this.fargateProfileName = x.fargateProfileName
            this.podExecutionRoleArn = x.podExecutionRoleArn
            this.selectors = x.selectors
            this.subnets = x.subnets
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.CreateFargateProfileRequest = CreateFargateProfileRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
