// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateClusterRequest private constructor(builder: Builder) {
    /**
     * The access configuration for the cluster.
     */
    public val accessConfig: aws.sdk.kotlin.services.eks.model.CreateAccessConfigRequest? = builder.accessConfig
    /**
     * If you set this value to `False` when creating a cluster, the default networking add-ons will not be installed.
     *
     * The default networking add-ons include `vpc-cni`, `coredns`, and `kube-proxy`.
     *
     * Use this option when you plan to install third-party alternative add-ons or self-manage the default networking add-ons.
     */
    public val bootstrapSelfManagedAddons: kotlin.Boolean? = builder.bootstrapSelfManagedAddons
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Enable or disable the compute capability of EKS Auto Mode when creating your EKS Auto Mode cluster. If the compute capability is enabled, EKS Auto Mode will create and delete EC2 Managed Instances in your Amazon Web Services account
     */
    public val computeConfig: aws.sdk.kotlin.services.eks.model.ComputeConfigRequest? = builder.computeConfig
    /**
     * Indicates whether to enable deletion protection for the cluster. When enabled, the cluster cannot be deleted unless deletion protection is first disabled. This helps prevent accidental cluster deletion. Default value is `false`.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The encryption configuration for the cluster.
     */
    public val encryptionConfig: List<EncryptionConfig>? = builder.encryptionConfig
    /**
     * The Kubernetes network configuration for the cluster.
     */
    public val kubernetesNetworkConfig: aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest? = builder.kubernetesNetworkConfig
    /**
     * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs . By default, cluster control plane logs aren't exported to CloudWatch Logs . For more information, see [Amazon EKS Cluster control plane logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html) in the **Amazon EKS User Guide**.
     *
     * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see [CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
     */
    public val logging: aws.sdk.kotlin.services.eks.model.Logging? = builder.logging
    /**
     * The unique name to give to your cluster. The name can contain only alphanumeric characters (case-sensitive), hyphens, and underscores. It must start with an alphanumeric character and can't be longer than 100 characters. The name must be unique within the Amazon Web Services Region and Amazon Web Services account that you're creating the cluster in.
     */
    public val name: kotlin.String? = builder.name
    /**
     * An object representing the configuration of your local Amazon EKS cluster on an Amazon Web Services Outpost. Before creating a local cluster on an Outpost, review [Local clusters for Amazon EKS on Amazon Web Services Outposts](https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-local-cluster-overview.html) in the *Amazon EKS User Guide*. This object isn't available for creating Amazon EKS clusters on the Amazon Web Services cloud.
     */
    public val outpostConfig: aws.sdk.kotlin.services.eks.model.OutpostConfigRequest? = builder.outpostConfig
    /**
     * The configuration in the cluster for EKS Hybrid Nodes. You can add, change, or remove this configuration after the cluster is created.
     */
    public val remoteNetworkConfig: aws.sdk.kotlin.services.eks.model.RemoteNetworkConfigRequest? = builder.remoteNetworkConfig
    /**
     * The VPC configuration that's used by the cluster control plane. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see [Cluster VPC Considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) and [Cluster Security Group Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the *Amazon EKS User Guide*. You must specify at least two subnets. You can specify up to five security groups. However, we recommend that you use a dedicated security group for your cluster control plane.
     */
    public val resourcesVpcConfig: aws.sdk.kotlin.services.eks.model.VpcConfigRequest? = builder.resourcesVpcConfig
    /**
     * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to Amazon Web Services API operations on your behalf. For more information, see [Amazon EKS Service IAM Role](https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html) in the **Amazon EKS User Guide**.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Enable or disable the block storage capability of EKS Auto Mode when creating your EKS Auto Mode cluster. If the block storage capability is enabled, EKS Auto Mode will create and delete EBS volumes in your Amazon Web Services account.
     */
    public val storageConfig: aws.sdk.kotlin.services.eks.model.StorageConfigRequest? = builder.storageConfig
    /**
     * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * New clusters, by default, have extended support enabled. You can disable extended support when creating a cluster by setting this value to `STANDARD`.
     */
    public val upgradePolicy: aws.sdk.kotlin.services.eks.model.UpgradePolicyRequest? = builder.upgradePolicy
    /**
     * The desired Kubernetes version for your cluster. If you don't specify a value here, the default version available in Amazon EKS is used.
     *
     * The default version might not be the latest version available.
     */
    public val version: kotlin.String? = builder.version
    /**
     * Enable or disable ARC zonal shift for the cluster. If zonal shift is enabled, Amazon Web Services configures zonal autoshift for the cluster.
     *
     * Zonal shift is a feature of Amazon Application Recovery Controller (ARC). ARC zonal shift is designed to be a temporary measure that allows you to move traffic for a resource away from an impaired AZ until the zonal shift expires or you cancel it. You can extend the zonal shift if necessary.
     *
     * You can start a zonal shift for an Amazon EKS cluster, or you can allow Amazon Web Services to do it for you by enabling *zonal autoshift*. This shift updates the flow of east-to-west network traffic in your cluster to only consider network endpoints for Pods running on worker nodes in healthy AZs. Additionally, any ALB or NLB handling ingress traffic for applications in your Amazon EKS cluster will automatically route traffic to targets in the healthy AZs. For more information about zonal shift in EKS, see [Learn about Amazon Application Recovery Controller (ARC) Zonal Shift in Amazon EKS](https://docs.aws.amazon.com/eks/latest/userguide/zone-shift.html) in the **Amazon EKS User Guide**.
     */
    public val zonalShiftConfig: aws.sdk.kotlin.services.eks.model.ZonalShiftConfigRequest? = builder.zonalShiftConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.CreateClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClusterRequest(")
        append("accessConfig=$accessConfig,")
        append("bootstrapSelfManagedAddons=$bootstrapSelfManagedAddons,")
        append("clientRequestToken=$clientRequestToken,")
        append("computeConfig=$computeConfig,")
        append("deletionProtection=$deletionProtection,")
        append("encryptionConfig=$encryptionConfig,")
        append("kubernetesNetworkConfig=$kubernetesNetworkConfig,")
        append("logging=$logging,")
        append("name=$name,")
        append("outpostConfig=$outpostConfig,")
        append("remoteNetworkConfig=$remoteNetworkConfig,")
        append("resourcesVpcConfig=$resourcesVpcConfig,")
        append("roleArn=$roleArn,")
        append("storageConfig=$storageConfig,")
        append("tags=$tags,")
        append("upgradePolicy=$upgradePolicy,")
        append("version=$version,")
        append("zonalShiftConfig=$zonalShiftConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessConfig?.hashCode() ?: 0
        result = 31 * result + (bootstrapSelfManagedAddons?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (computeConfig?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfig?.hashCode() ?: 0)
        result = 31 * result + (kubernetesNetworkConfig?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outpostConfig?.hashCode() ?: 0)
        result = 31 * result + (remoteNetworkConfig?.hashCode() ?: 0)
        result = 31 * result + (resourcesVpcConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (storageConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (upgradePolicy?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (zonalShiftConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateClusterRequest

        if (accessConfig != other.accessConfig) return false
        if (bootstrapSelfManagedAddons != other.bootstrapSelfManagedAddons) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (computeConfig != other.computeConfig) return false
        if (deletionProtection != other.deletionProtection) return false
        if (encryptionConfig != other.encryptionConfig) return false
        if (kubernetesNetworkConfig != other.kubernetesNetworkConfig) return false
        if (logging != other.logging) return false
        if (name != other.name) return false
        if (outpostConfig != other.outpostConfig) return false
        if (remoteNetworkConfig != other.remoteNetworkConfig) return false
        if (resourcesVpcConfig != other.resourcesVpcConfig) return false
        if (roleArn != other.roleArn) return false
        if (storageConfig != other.storageConfig) return false
        if (tags != other.tags) return false
        if (upgradePolicy != other.upgradePolicy) return false
        if (version != other.version) return false
        if (zonalShiftConfig != other.zonalShiftConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.CreateClusterRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The access configuration for the cluster.
         */
        public var accessConfig: aws.sdk.kotlin.services.eks.model.CreateAccessConfigRequest? = null
        /**
         * If you set this value to `False` when creating a cluster, the default networking add-ons will not be installed.
         *
         * The default networking add-ons include `vpc-cni`, `coredns`, and `kube-proxy`.
         *
         * Use this option when you plan to install third-party alternative add-ons or self-manage the default networking add-ons.
         */
        public var bootstrapSelfManagedAddons: kotlin.Boolean? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Enable or disable the compute capability of EKS Auto Mode when creating your EKS Auto Mode cluster. If the compute capability is enabled, EKS Auto Mode will create and delete EC2 Managed Instances in your Amazon Web Services account
         */
        public var computeConfig: aws.sdk.kotlin.services.eks.model.ComputeConfigRequest? = null
        /**
         * Indicates whether to enable deletion protection for the cluster. When enabled, the cluster cannot be deleted unless deletion protection is first disabled. This helps prevent accidental cluster deletion. Default value is `false`.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The encryption configuration for the cluster.
         */
        public var encryptionConfig: List<EncryptionConfig>? = null
        /**
         * The Kubernetes network configuration for the cluster.
         */
        public var kubernetesNetworkConfig: aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest? = null
        /**
         * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs . By default, cluster control plane logs aren't exported to CloudWatch Logs . For more information, see [Amazon EKS Cluster control plane logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html) in the **Amazon EKS User Guide**.
         *
         * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see [CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
         */
        public var logging: aws.sdk.kotlin.services.eks.model.Logging? = null
        /**
         * The unique name to give to your cluster. The name can contain only alphanumeric characters (case-sensitive), hyphens, and underscores. It must start with an alphanumeric character and can't be longer than 100 characters. The name must be unique within the Amazon Web Services Region and Amazon Web Services account that you're creating the cluster in.
         */
        public var name: kotlin.String? = null
        /**
         * An object representing the configuration of your local Amazon EKS cluster on an Amazon Web Services Outpost. Before creating a local cluster on an Outpost, review [Local clusters for Amazon EKS on Amazon Web Services Outposts](https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-local-cluster-overview.html) in the *Amazon EKS User Guide*. This object isn't available for creating Amazon EKS clusters on the Amazon Web Services cloud.
         */
        public var outpostConfig: aws.sdk.kotlin.services.eks.model.OutpostConfigRequest? = null
        /**
         * The configuration in the cluster for EKS Hybrid Nodes. You can add, change, or remove this configuration after the cluster is created.
         */
        public var remoteNetworkConfig: aws.sdk.kotlin.services.eks.model.RemoteNetworkConfigRequest? = null
        /**
         * The VPC configuration that's used by the cluster control plane. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see [Cluster VPC Considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) and [Cluster Security Group Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the *Amazon EKS User Guide*. You must specify at least two subnets. You can specify up to five security groups. However, we recommend that you use a dedicated security group for your cluster control plane.
         */
        public var resourcesVpcConfig: aws.sdk.kotlin.services.eks.model.VpcConfigRequest? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to Amazon Web Services API operations on your behalf. For more information, see [Amazon EKS Service IAM Role](https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html) in the **Amazon EKS User Guide**.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Enable or disable the block storage capability of EKS Auto Mode when creating your EKS Auto Mode cluster. If the block storage capability is enabled, EKS Auto Mode will create and delete EBS volumes in your Amazon Web Services account.
         */
        public var storageConfig: aws.sdk.kotlin.services.eks.model.StorageConfigRequest? = null
        /**
         * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         */
        public var tags: Map<String, String>? = null
        /**
         * New clusters, by default, have extended support enabled. You can disable extended support when creating a cluster by setting this value to `STANDARD`.
         */
        public var upgradePolicy: aws.sdk.kotlin.services.eks.model.UpgradePolicyRequest? = null
        /**
         * The desired Kubernetes version for your cluster. If you don't specify a value here, the default version available in Amazon EKS is used.
         *
         * The default version might not be the latest version available.
         */
        public var version: kotlin.String? = null
        /**
         * Enable or disable ARC zonal shift for the cluster. If zonal shift is enabled, Amazon Web Services configures zonal autoshift for the cluster.
         *
         * Zonal shift is a feature of Amazon Application Recovery Controller (ARC). ARC zonal shift is designed to be a temporary measure that allows you to move traffic for a resource away from an impaired AZ until the zonal shift expires or you cancel it. You can extend the zonal shift if necessary.
         *
         * You can start a zonal shift for an Amazon EKS cluster, or you can allow Amazon Web Services to do it for you by enabling *zonal autoshift*. This shift updates the flow of east-to-west network traffic in your cluster to only consider network endpoints for Pods running on worker nodes in healthy AZs. Additionally, any ALB or NLB handling ingress traffic for applications in your Amazon EKS cluster will automatically route traffic to targets in the healthy AZs. For more information about zonal shift in EKS, see [Learn about Amazon Application Recovery Controller (ARC) Zonal Shift in Amazon EKS](https://docs.aws.amazon.com/eks/latest/userguide/zone-shift.html) in the **Amazon EKS User Guide**.
         */
        public var zonalShiftConfig: aws.sdk.kotlin.services.eks.model.ZonalShiftConfigRequest? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.CreateClusterRequest) : this() {
            this.accessConfig = x.accessConfig
            this.bootstrapSelfManagedAddons = x.bootstrapSelfManagedAddons
            this.clientRequestToken = x.clientRequestToken
            this.computeConfig = x.computeConfig
            this.deletionProtection = x.deletionProtection
            this.encryptionConfig = x.encryptionConfig
            this.kubernetesNetworkConfig = x.kubernetesNetworkConfig
            this.logging = x.logging
            this.name = x.name
            this.outpostConfig = x.outpostConfig
            this.remoteNetworkConfig = x.remoteNetworkConfig
            this.resourcesVpcConfig = x.resourcesVpcConfig
            this.roleArn = x.roleArn
            this.storageConfig = x.storageConfig
            this.tags = x.tags
            this.upgradePolicy = x.upgradePolicy
            this.version = x.version
            this.zonalShiftConfig = x.zonalShiftConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.CreateClusterRequest = CreateClusterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.CreateAccessConfigRequest] inside the given [block]
         */
        public fun accessConfig(block: aws.sdk.kotlin.services.eks.model.CreateAccessConfigRequest.Builder.() -> kotlin.Unit) {
            this.accessConfig = aws.sdk.kotlin.services.eks.model.CreateAccessConfigRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.ComputeConfigRequest] inside the given [block]
         */
        public fun computeConfig(block: aws.sdk.kotlin.services.eks.model.ComputeConfigRequest.Builder.() -> kotlin.Unit) {
            this.computeConfig = aws.sdk.kotlin.services.eks.model.ComputeConfigRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest] inside the given [block]
         */
        public fun kubernetesNetworkConfig(block: aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest.Builder.() -> kotlin.Unit) {
            this.kubernetesNetworkConfig = aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.Logging] inside the given [block]
         */
        public fun logging(block: aws.sdk.kotlin.services.eks.model.Logging.Builder.() -> kotlin.Unit) {
            this.logging = aws.sdk.kotlin.services.eks.model.Logging.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.OutpostConfigRequest] inside the given [block]
         */
        public fun outpostConfig(block: aws.sdk.kotlin.services.eks.model.OutpostConfigRequest.Builder.() -> kotlin.Unit) {
            this.outpostConfig = aws.sdk.kotlin.services.eks.model.OutpostConfigRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.RemoteNetworkConfigRequest] inside the given [block]
         */
        public fun remoteNetworkConfig(block: aws.sdk.kotlin.services.eks.model.RemoteNetworkConfigRequest.Builder.() -> kotlin.Unit) {
            this.remoteNetworkConfig = aws.sdk.kotlin.services.eks.model.RemoteNetworkConfigRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.VpcConfigRequest] inside the given [block]
         */
        public fun resourcesVpcConfig(block: aws.sdk.kotlin.services.eks.model.VpcConfigRequest.Builder.() -> kotlin.Unit) {
            this.resourcesVpcConfig = aws.sdk.kotlin.services.eks.model.VpcConfigRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.StorageConfigRequest] inside the given [block]
         */
        public fun storageConfig(block: aws.sdk.kotlin.services.eks.model.StorageConfigRequest.Builder.() -> kotlin.Unit) {
            this.storageConfig = aws.sdk.kotlin.services.eks.model.StorageConfigRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.UpgradePolicyRequest] inside the given [block]
         */
        public fun upgradePolicy(block: aws.sdk.kotlin.services.eks.model.UpgradePolicyRequest.Builder.() -> kotlin.Unit) {
            this.upgradePolicy = aws.sdk.kotlin.services.eks.model.UpgradePolicyRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.ZonalShiftConfigRequest] inside the given [block]
         */
        public fun zonalShiftConfig(block: aws.sdk.kotlin.services.eks.model.ZonalShiftConfigRequest.Builder.() -> kotlin.Unit) {
            this.zonalShiftConfig = aws.sdk.kotlin.services.eks.model.ZonalShiftConfigRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
