// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.serde

import aws.sdk.kotlin.services.eks.model.AddonPodIdentityConfiguration
import aws.sdk.kotlin.services.eks.model.DescribeAddonConfigurationResponse
import aws.sdk.kotlin.services.eks.model.EksException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeAddonConfigurationOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAddonConfigurationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAddonConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAddonConfigurationError(context, call, payload)
        }
        val builder = DescribeAddonConfigurationResponse.Builder()

        if (payload != null) {
            deserializeDescribeAddonConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAddonConfigurationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EksException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EksException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAddonConfigurationOperationBody(builder: DescribeAddonConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADDONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("addonName"))
    val ADDONVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("addonVersion"))
    val CONFIGURATIONSCHEMA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("configurationSchema"))
    val PODIDENTITYCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("podIdentityConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDONNAME_DESCRIPTOR)
        field(ADDONVERSION_DESCRIPTOR)
        field(CONFIGURATIONSCHEMA_DESCRIPTOR)
        field(PODIDENTITYCONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADDONNAME_DESCRIPTOR.index -> builder.addonName = deserializeString()
                ADDONVERSION_DESCRIPTOR.index -> builder.addonVersion = deserializeString()
                CONFIGURATIONSCHEMA_DESCRIPTOR.index -> builder.configurationSchema = deserializeString()
                PODIDENTITYCONFIGURATION_DESCRIPTOR.index -> builder.podIdentityConfiguration =
                    deserializer.deserializeList(PODIDENTITYCONFIGURATION_DESCRIPTOR) {
                        val col0 = mutableListOf<AddonPodIdentityConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAddonPodIdentityConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
