// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.serde

import aws.sdk.kotlin.services.eks.model.ComputeConfigRequest
import aws.sdk.kotlin.services.eks.model.CreateAccessConfigRequest
import aws.sdk.kotlin.services.eks.model.CreateClusterRequest
import aws.sdk.kotlin.services.eks.model.EncryptionConfig
import aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest
import aws.sdk.kotlin.services.eks.model.Logging
import aws.sdk.kotlin.services.eks.model.OutpostConfigRequest
import aws.sdk.kotlin.services.eks.model.RemoteNetworkConfigRequest
import aws.sdk.kotlin.services.eks.model.StorageConfigRequest
import aws.sdk.kotlin.services.eks.model.UpgradePolicyRequest
import aws.sdk.kotlin.services.eks.model.VpcConfigRequest
import aws.sdk.kotlin.services.eks.model.ZonalShiftConfigRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateClusterOperationSerializer: HttpSerializer.NonStreaming<CreateClusterRequest> {
    override fun serialize(context: ExecutionContext, input: CreateClusterRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/clusters"
        }

        val payload = serializeCreateClusterOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateClusterOperationBody(context: ExecutionContext, input: CreateClusterRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCESSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accessConfig"))
    val BOOTSTRAPSELFMANAGEDADDONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("bootstrapSelfManagedAddons"))
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val COMPUTECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("computeConfig"))
    val DELETIONPROTECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("deletionProtection"))
    val ENCRYPTIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("encryptionConfig"))
    val KUBERNETESNETWORKCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("kubernetesNetworkConfig"))
    val LOGGING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("logging"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OUTPOSTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("outpostConfig"))
    val REMOTENETWORKCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("remoteNetworkConfig"))
    val RESOURCESVPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("resourcesVpcConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val STORAGECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("storageConfig"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val UPGRADEPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("upgradePolicy"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("version"))
    val ZONALSHIFTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("zonalShiftConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSCONFIG_DESCRIPTOR)
        field(BOOTSTRAPSELFMANAGEDADDONS_DESCRIPTOR)
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(COMPUTECONFIG_DESCRIPTOR)
        field(DELETIONPROTECTION_DESCRIPTOR)
        field(ENCRYPTIONCONFIG_DESCRIPTOR)
        field(KUBERNETESNETWORKCONFIG_DESCRIPTOR)
        field(LOGGING_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OUTPOSTCONFIG_DESCRIPTOR)
        field(REMOTENETWORKCONFIG_DESCRIPTOR)
        field(RESOURCESVPCCONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STORAGECONFIG_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(UPGRADEPOLICY_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
        field(ZONALSHIFTCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accessConfig?.let { field(ACCESSCONFIG_DESCRIPTOR, it, ::serializeCreateAccessConfigRequestDocument) }
        input.bootstrapSelfManagedAddons?.let { field(BOOTSTRAPSELFMANAGEDADDONS_DESCRIPTOR, it) }
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.computeConfig?.let { field(COMPUTECONFIG_DESCRIPTOR, it, ::serializeComputeConfigRequestDocument) }
        input.deletionProtection?.let { field(DELETIONPROTECTION_DESCRIPTOR, it) }
        if (input.encryptionConfig != null) {
            listField(ENCRYPTIONCONFIG_DESCRIPTOR) {
                for (el0 in input.encryptionConfig) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeEncryptionConfigDocument))
                }
            }
        }
        input.kubernetesNetworkConfig?.let { field(KUBERNETESNETWORKCONFIG_DESCRIPTOR, it, ::serializeKubernetesNetworkConfigRequestDocument) }
        input.logging?.let { field(LOGGING_DESCRIPTOR, it, ::serializeLoggingDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.outpostConfig?.let { field(OUTPOSTCONFIG_DESCRIPTOR, it, ::serializeOutpostConfigRequestDocument) }
        input.remoteNetworkConfig?.let { field(REMOTENETWORKCONFIG_DESCRIPTOR, it, ::serializeRemoteNetworkConfigRequestDocument) }
        input.resourcesVpcConfig?.let { field(RESOURCESVPCCONFIG_DESCRIPTOR, it, ::serializeVpcConfigRequestDocument) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        input.storageConfig?.let { field(STORAGECONFIG_DESCRIPTOR, it, ::serializeStorageConfigRequestDocument) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.upgradePolicy?.let { field(UPGRADEPOLICY_DESCRIPTOR, it, ::serializeUpgradePolicyRequestDocument) }
        input.version?.let { field(VERSION_DESCRIPTOR, it) }
        input.zonalShiftConfig?.let { field(ZONALSHIFTCONFIG_DESCRIPTOR, it, ::serializeZonalShiftConfigRequestDocument) }
    }
    return serializer.toByteArray()
}
