// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration of your local Amazon EKS cluster on an Amazon Web Services Outpost. Before creating a cluster on an Outpost, review [Creating a local cluster on an Outpost](https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-local-cluster-create.html) in the *Amazon EKS User Guide*. This API isn't available for Amazon EKS clusters on the Amazon Web Services cloud.
 */
public class OutpostConfigRequest private constructor(builder: Builder) {
    /**
     * The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. Choose an instance type based on the number of nodes that your cluster will have. For more information, see [Capacity considerations](https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html) in the *Amazon EKS User Guide*.
     *
     * The instance type that you specify is used for all Kubernetes control plane instances. The instance type can't be changed after cluster creation. The control plane is not automatically scaled by Amazon EKS.
     */
    public val controlPlaneInstanceType: kotlin.String = requireNotNull(builder.controlPlaneInstanceType) { "A non-null value must be provided for controlPlaneInstanceType" }
    /**
     * An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on an Amazon Web Services Outpost. For more information, see [Capacity considerations](https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html) in the *Amazon EKS User Guide*.
     */
    public val controlPlanePlacement: aws.sdk.kotlin.services.eks.model.ControlPlanePlacementRequest? = builder.controlPlanePlacement
    /**
     * The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. Only a single Outpost ARN is supported.
     */
    public val outpostArns: List<String> = requireNotNull(builder.outpostArns) { "A non-null value must be provided for outpostArns" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.OutpostConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OutpostConfigRequest(")
        append("controlPlaneInstanceType=$controlPlaneInstanceType,")
        append("controlPlanePlacement=$controlPlanePlacement,")
        append("outpostArns=$outpostArns")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = controlPlaneInstanceType.hashCode()
        result = 31 * result + (controlPlanePlacement?.hashCode() ?: 0)
        result = 31 * result + (outpostArns.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OutpostConfigRequest

        if (controlPlaneInstanceType != other.controlPlaneInstanceType) return false
        if (controlPlanePlacement != other.controlPlanePlacement) return false
        if (outpostArns != other.outpostArns) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.OutpostConfigRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. Choose an instance type based on the number of nodes that your cluster will have. For more information, see [Capacity considerations](https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html) in the *Amazon EKS User Guide*.
         *
         * The instance type that you specify is used for all Kubernetes control plane instances. The instance type can't be changed after cluster creation. The control plane is not automatically scaled by Amazon EKS.
         */
        public var controlPlaneInstanceType: kotlin.String? = null
        /**
         * An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on an Amazon Web Services Outpost. For more information, see [Capacity considerations](https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html) in the *Amazon EKS User Guide*.
         */
        public var controlPlanePlacement: aws.sdk.kotlin.services.eks.model.ControlPlanePlacementRequest? = null
        /**
         * The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. Only a single Outpost ARN is supported.
         */
        public var outpostArns: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.OutpostConfigRequest) : this() {
            this.controlPlaneInstanceType = x.controlPlaneInstanceType
            this.controlPlanePlacement = x.controlPlanePlacement
            this.outpostArns = x.outpostArns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.OutpostConfigRequest = OutpostConfigRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.ControlPlanePlacementRequest] inside the given [block]
         */
        public fun controlPlanePlacement(block: aws.sdk.kotlin.services.eks.model.ControlPlanePlacementRequest.Builder.() -> kotlin.Unit) {
            this.controlPlanePlacement = aws.sdk.kotlin.services.eks.model.ControlPlanePlacementRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (controlPlaneInstanceType == null) controlPlaneInstanceType = ""
            if (outpostArns == null) outpostArns = emptyList()
            return this
        }
    }
}
