// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListPodIdentityAssociationsRequest private constructor(builder: Builder) {
    /**
     * The name of the cluster that the associations are in.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * The maximum number of EKS Pod Identity association results returned by `ListPodIdentityAssociations` in paginated output. When you use this parameter, `ListPodIdentityAssociations` returns only `maxResults` results in a single page along with a `nextToken` response element. You can see the remaining results of the initial request by sending another `ListPodIdentityAssociations` request with the returned `nextToken` value. This value can be between 1 and 100. If you don't use this parameter, `ListPodIdentityAssociations` returns up to 100 results and a `nextToken` value if applicable.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The name of the Kubernetes namespace inside the cluster that the associations are in.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The `nextToken` value returned from a previous paginated `ListUpdates` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value.
     *
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the Kubernetes service account that the associations use.
     */
    public val serviceAccount: kotlin.String? = builder.serviceAccount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.ListPodIdentityAssociationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPodIdentityAssociationsRequest(")
        append("clusterName=$clusterName,")
        append("maxResults=$maxResults,")
        append("namespace=$namespace,")
        append("nextToken=$nextToken,")
        append("serviceAccount=$serviceAccount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterName?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (serviceAccount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPodIdentityAssociationsRequest

        if (clusterName != other.clusterName) return false
        if (maxResults != other.maxResults) return false
        if (namespace != other.namespace) return false
        if (nextToken != other.nextToken) return false
        if (serviceAccount != other.serviceAccount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.ListPodIdentityAssociationsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the cluster that the associations are in.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The maximum number of EKS Pod Identity association results returned by `ListPodIdentityAssociations` in paginated output. When you use this parameter, `ListPodIdentityAssociations` returns only `maxResults` results in a single page along with a `nextToken` response element. You can see the remaining results of the initial request by sending another `ListPodIdentityAssociations` request with the returned `nextToken` value. This value can be between 1 and 100. If you don't use this parameter, `ListPodIdentityAssociations` returns up to 100 results and a `nextToken` value if applicable.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The name of the Kubernetes namespace inside the cluster that the associations are in.
         */
        public var namespace: kotlin.String? = null
        /**
         * The `nextToken` value returned from a previous paginated `ListUpdates` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value.
         *
         * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name of the Kubernetes service account that the associations use.
         */
        public var serviceAccount: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.ListPodIdentityAssociationsRequest) : this() {
            this.clusterName = x.clusterName
            this.maxResults = x.maxResults
            this.namespace = x.namespace
            this.nextToken = x.nextToken
            this.serviceAccount = x.serviceAccount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.ListPodIdentityAssociationsRequest = ListPodIdentityAssociationsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
