// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.serde

import aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification
import aws.sdk.kotlin.services.eks.model.UpdateNodegroupVersionRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateNodegroupVersionOperationSerializer: HttpSerializer.NonStreaming<UpdateNodegroupVersionRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateNodegroupVersionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.clusterName) { "clusterName is bound to the URI and must not be null" }
            requireNotNull(input.nodegroupName) { "nodegroupName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("clusters"))
                add(PercentEncoding.SmithyLabel.encode(input.clusterName))
                add(PercentEncoding.Path.encode("node-groups"))
                add(PercentEncoding.SmithyLabel.encode(input.nodegroupName))
                add(PercentEncoding.Path.encode("update-version"))
            }
        }

        val payload = serializeUpdateNodegroupVersionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateNodegroupVersionOperationBody(context: ExecutionContext, input: UpdateNodegroupVersionRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val FORCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("force"))
    val LAUNCHTEMPLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("launchTemplate"))
    val RELEASEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("releaseVersion"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(FORCE_DESCRIPTOR)
        field(LAUNCHTEMPLATE_DESCRIPTOR)
        field(RELEASEVERSION_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.force?.let { field(FORCE_DESCRIPTOR, it) }
        input.launchTemplate?.let { field(LAUNCHTEMPLATE_DESCRIPTOR, it, ::serializeLaunchTemplateSpecificationDocument) }
        input.releaseVersion?.let { field(RELEASEVERSION_DESCRIPTOR, it) }
        input.version?.let { field(VERSION_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
