// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.serde

import aws.sdk.kotlin.services.eks.model.ComputeConfigRequest
import aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest
import aws.sdk.kotlin.services.eks.model.Logging
import aws.sdk.kotlin.services.eks.model.RemoteNetworkConfigRequest
import aws.sdk.kotlin.services.eks.model.StorageConfigRequest
import aws.sdk.kotlin.services.eks.model.UpdateAccessConfigRequest
import aws.sdk.kotlin.services.eks.model.UpdateClusterConfigRequest
import aws.sdk.kotlin.services.eks.model.UpgradePolicyRequest
import aws.sdk.kotlin.services.eks.model.VpcConfigRequest
import aws.sdk.kotlin.services.eks.model.ZonalShiftConfigRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateClusterConfigOperationSerializer: HttpSerializer.NonStreaming<UpdateClusterConfigRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateClusterConfigRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.name) { "name is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("clusters"))
                add(PercentEncoding.SmithyLabel.encode(input.name))
                add(PercentEncoding.Path.encode("update-config"))
            }
        }

        val payload = serializeUpdateClusterConfigOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateClusterConfigOperationBody(context: ExecutionContext, input: UpdateClusterConfigRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCESSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accessConfig"))
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val COMPUTECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("computeConfig"))
    val DELETIONPROTECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("deletionProtection"))
    val KUBERNETESNETWORKCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("kubernetesNetworkConfig"))
    val LOGGING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("logging"))
    val REMOTENETWORKCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("remoteNetworkConfig"))
    val RESOURCESVPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("resourcesVpcConfig"))
    val STORAGECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("storageConfig"))
    val UPGRADEPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("upgradePolicy"))
    val ZONALSHIFTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("zonalShiftConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSCONFIG_DESCRIPTOR)
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(COMPUTECONFIG_DESCRIPTOR)
        field(DELETIONPROTECTION_DESCRIPTOR)
        field(KUBERNETESNETWORKCONFIG_DESCRIPTOR)
        field(LOGGING_DESCRIPTOR)
        field(REMOTENETWORKCONFIG_DESCRIPTOR)
        field(RESOURCESVPCCONFIG_DESCRIPTOR)
        field(STORAGECONFIG_DESCRIPTOR)
        field(UPGRADEPOLICY_DESCRIPTOR)
        field(ZONALSHIFTCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accessConfig?.let { field(ACCESSCONFIG_DESCRIPTOR, it, ::serializeUpdateAccessConfigRequestDocument) }
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.computeConfig?.let { field(COMPUTECONFIG_DESCRIPTOR, it, ::serializeComputeConfigRequestDocument) }
        input.deletionProtection?.let { field(DELETIONPROTECTION_DESCRIPTOR, it) }
        input.kubernetesNetworkConfig?.let { field(KUBERNETESNETWORKCONFIG_DESCRIPTOR, it, ::serializeKubernetesNetworkConfigRequestDocument) }
        input.logging?.let { field(LOGGING_DESCRIPTOR, it, ::serializeLoggingDocument) }
        input.remoteNetworkConfig?.let { field(REMOTENETWORKCONFIG_DESCRIPTOR, it, ::serializeRemoteNetworkConfigRequestDocument) }
        input.resourcesVpcConfig?.let { field(RESOURCESVPCCONFIG_DESCRIPTOR, it, ::serializeVpcConfigRequestDocument) }
        input.storageConfig?.let { field(STORAGECONFIG_DESCRIPTOR, it, ::serializeStorageConfigRequestDocument) }
        input.upgradePolicy?.let { field(UPGRADEPOLICY_DESCRIPTOR, it, ::serializeUpgradePolicyRequestDocument) }
        input.zonalShiftConfig?.let { field(ZONALSHIFTCONFIG_DESCRIPTOR, it, ::serializeZonalShiftConfigRequestDocument) }
    }
    return serializer.toByteArray()
}
