// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.serde

import aws.sdk.kotlin.services.eks.model.UpdateAccessEntryRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateAccessEntryOperationSerializer: HttpSerializer.NonStreaming<UpdateAccessEntryRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateAccessEntryRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.clusterName) { "clusterName is bound to the URI and must not be null" }
            requireNotNull(input.principalArn) { "principalArn is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("clusters"))
                add(PercentEncoding.SmithyLabel.encode(input.clusterName))
                add(PercentEncoding.Path.encode("access-entries"))
                add(PercentEncoding.SmithyLabel.encode(input.principalArn))
            }
        }

        val payload = serializeUpdateAccessEntryOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateAccessEntryOperationBody(context: ExecutionContext, input: UpdateAccessEntryRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val KUBERNETESGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("kubernetesGroups"))
    val USERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("username"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(KUBERNETESGROUPS_DESCRIPTOR)
        field(USERNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        if (input.kubernetesGroups != null) {
            listField(KUBERNETESGROUPS_DESCRIPTOR) {
                for (el0 in input.kubernetesGroups) {
                    serializeString(el0)
                }
            }
        }
        input.username?.let { field(USERNAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
