// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.serde

import aws.sdk.kotlin.services.eks.model.AddonNamespaceConfigRequest
import aws.sdk.kotlin.services.eks.model.AddonPodIdentityAssociations
import aws.sdk.kotlin.services.eks.model.CreateAddonRequest
import aws.sdk.kotlin.services.eks.model.ResolveConflicts
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateAddonOperationSerializer: HttpSerializer.NonStreaming<CreateAddonRequest> {
    override fun serialize(context: ExecutionContext, input: CreateAddonRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.clusterName) { "clusterName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("clusters"))
                add(PercentEncoding.SmithyLabel.encode(input.clusterName))
                add(PercentEncoding.Path.encode("addons"))
            }
        }

        val payload = serializeCreateAddonOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateAddonOperationBody(context: ExecutionContext, input: CreateAddonRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADDONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("addonName"))
    val ADDONVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("addonVersion"))
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val CONFIGURATIONVALUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("configurationValues"))
    val NAMESPACECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("namespaceConfig"))
    val PODIDENTITYASSOCIATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("podIdentityAssociations"))
    val RESOLVECONFLICTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("resolveConflicts"))
    val SERVICEACCOUNTROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serviceAccountRoleArn"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDONNAME_DESCRIPTOR)
        field(ADDONVERSION_DESCRIPTOR)
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(CONFIGURATIONVALUES_DESCRIPTOR)
        field(NAMESPACECONFIG_DESCRIPTOR)
        field(PODIDENTITYASSOCIATIONS_DESCRIPTOR)
        field(RESOLVECONFLICTS_DESCRIPTOR)
        field(SERVICEACCOUNTROLEARN_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.addonName?.let { field(ADDONNAME_DESCRIPTOR, it) }
        input.addonVersion?.let { field(ADDONVERSION_DESCRIPTOR, it) }
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.configurationValues?.let { field(CONFIGURATIONVALUES_DESCRIPTOR, it) }
        input.namespaceConfig?.let { field(NAMESPACECONFIG_DESCRIPTOR, it, ::serializeAddonNamespaceConfigRequestDocument) }
        if (input.podIdentityAssociations != null) {
            listField(PODIDENTITYASSOCIATIONS_DESCRIPTOR) {
                for (el0 in input.podIdentityAssociations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAddonPodIdentityAssociationsDocument))
                }
            }
        }
        input.resolveConflicts?.let { field(RESOLVECONFLICTS_DESCRIPTOR, it.value) }
        input.serviceAccountRoleArn?.let { field(SERVICEACCOUNTROLEARN_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
