// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.paginators

import aws.sdk.kotlin.services.eks.EksClient
import aws.sdk.kotlin.services.eks.model.AccessPolicy
import aws.sdk.kotlin.services.eks.model.AddonInfo
import aws.sdk.kotlin.services.eks.model.AssociatedAccessPolicy
import aws.sdk.kotlin.services.eks.model.ClusterVersionInformation
import aws.sdk.kotlin.services.eks.model.DescribeAddonVersionsRequest
import aws.sdk.kotlin.services.eks.model.DescribeAddonVersionsResponse
import aws.sdk.kotlin.services.eks.model.DescribeClusterVersionsRequest
import aws.sdk.kotlin.services.eks.model.DescribeClusterVersionsResponse
import aws.sdk.kotlin.services.eks.model.EksAnywhereSubscription
import aws.sdk.kotlin.services.eks.model.IdentityProviderConfig
import aws.sdk.kotlin.services.eks.model.InsightSummary
import aws.sdk.kotlin.services.eks.model.ListAccessEntriesRequest
import aws.sdk.kotlin.services.eks.model.ListAccessEntriesResponse
import aws.sdk.kotlin.services.eks.model.ListAccessPoliciesRequest
import aws.sdk.kotlin.services.eks.model.ListAccessPoliciesResponse
import aws.sdk.kotlin.services.eks.model.ListAddonsRequest
import aws.sdk.kotlin.services.eks.model.ListAddonsResponse
import aws.sdk.kotlin.services.eks.model.ListAssociatedAccessPoliciesRequest
import aws.sdk.kotlin.services.eks.model.ListAssociatedAccessPoliciesResponse
import aws.sdk.kotlin.services.eks.model.ListClustersRequest
import aws.sdk.kotlin.services.eks.model.ListClustersResponse
import aws.sdk.kotlin.services.eks.model.ListEksAnywhereSubscriptionsRequest
import aws.sdk.kotlin.services.eks.model.ListEksAnywhereSubscriptionsResponse
import aws.sdk.kotlin.services.eks.model.ListFargateProfilesRequest
import aws.sdk.kotlin.services.eks.model.ListFargateProfilesResponse
import aws.sdk.kotlin.services.eks.model.ListIdentityProviderConfigsRequest
import aws.sdk.kotlin.services.eks.model.ListIdentityProviderConfigsResponse
import aws.sdk.kotlin.services.eks.model.ListInsightsRequest
import aws.sdk.kotlin.services.eks.model.ListInsightsResponse
import aws.sdk.kotlin.services.eks.model.ListNodegroupsRequest
import aws.sdk.kotlin.services.eks.model.ListNodegroupsResponse
import aws.sdk.kotlin.services.eks.model.ListPodIdentityAssociationsRequest
import aws.sdk.kotlin.services.eks.model.ListPodIdentityAssociationsResponse
import aws.sdk.kotlin.services.eks.model.ListUpdatesRequest
import aws.sdk.kotlin.services.eks.model.ListUpdatesResponse
import aws.sdk.kotlin.services.eks.model.PodIdentityAssociationSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeAddonVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAddonVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAddonVersionsResponse]
 */
public fun EksClient.describeAddonVersionsPaginated(initialRequest: DescribeAddonVersionsRequest = DescribeAddonVersionsRequest { }): Flow<DescribeAddonVersionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAddonVersionsPaginated.describeAddonVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAddonVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAddonVersionsResponse]
 */
public fun EksClient.describeAddonVersionsPaginated(block: DescribeAddonVersionsRequest.Builder.() -> Unit): Flow<DescribeAddonVersionsResponse> =
    describeAddonVersionsPaginated(DescribeAddonVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAddonVersionsPaginated]
 * to access the nested member [AddonInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AddonInfo]
 */
@JvmName("describeAddonVersionsResponseAddonInfo")
public fun Flow<DescribeAddonVersionsResponse>.addons(): Flow<AddonInfo> =
    transform() { response ->
        response.addons?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeClusterVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeClusterVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterVersionsResponse]
 */
public fun EksClient.describeClusterVersionsPaginated(initialRequest: DescribeClusterVersionsRequest = DescribeClusterVersionsRequest { }): Flow<DescribeClusterVersionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeClusterVersionsPaginated.describeClusterVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeClusterVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClusterVersionsResponse]
 */
public fun EksClient.describeClusterVersionsPaginated(block: DescribeClusterVersionsRequest.Builder.() -> Unit): Flow<DescribeClusterVersionsResponse> =
    describeClusterVersionsPaginated(DescribeClusterVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeClusterVersionsPaginated]
 * to access the nested member [ClusterVersionInformation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ClusterVersionInformation]
 */
@JvmName("describeClusterVersionsResponseClusterVersionInformation")
public fun Flow<DescribeClusterVersionsResponse>.clusterVersions(): Flow<ClusterVersionInformation> =
    transform() { response ->
        response.clusterVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAccessEntriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessEntriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessEntriesResponse]
 */
public fun EksClient.listAccessEntriesPaginated(initialRequest: ListAccessEntriesRequest): Flow<ListAccessEntriesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessEntriesPaginated.listAccessEntries(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessEntriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessEntriesResponse]
 */
public fun EksClient.listAccessEntriesPaginated(block: ListAccessEntriesRequest.Builder.() -> Unit): Flow<ListAccessEntriesResponse> =
    listAccessEntriesPaginated(ListAccessEntriesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAccessEntriesPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listAccessEntriesResponseString")
public fun Flow<ListAccessEntriesResponse>.accessEntries(): Flow<String> =
    transform() { response ->
        response.accessEntries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAccessPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessPoliciesResponse]
 */
public fun EksClient.listAccessPoliciesPaginated(initialRequest: ListAccessPoliciesRequest = ListAccessPoliciesRequest { }): Flow<ListAccessPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessPoliciesPaginated.listAccessPolicies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessPoliciesResponse]
 */
public fun EksClient.listAccessPoliciesPaginated(block: ListAccessPoliciesRequest.Builder.() -> Unit): Flow<ListAccessPoliciesResponse> =
    listAccessPoliciesPaginated(ListAccessPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAccessPoliciesPaginated]
 * to access the nested member [AccessPolicy]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccessPolicy]
 */
@JvmName("listAccessPoliciesResponseAccessPolicy")
public fun Flow<ListAccessPoliciesResponse>.accessPolicies(): Flow<AccessPolicy> =
    transform() { response ->
        response.accessPolicies?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAddonsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAddonsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAddonsResponse]
 */
public fun EksClient.listAddonsPaginated(initialRequest: ListAddonsRequest): Flow<ListAddonsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAddonsPaginated.listAddons(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAddonsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAddonsResponse]
 */
public fun EksClient.listAddonsPaginated(block: ListAddonsRequest.Builder.() -> Unit): Flow<ListAddonsResponse> =
    listAddonsPaginated(ListAddonsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAddonsPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listAddonsResponseString")
public fun Flow<ListAddonsResponse>.addons(): Flow<String> =
    transform() { response ->
        response.addons?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAssociatedAccessPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssociatedAccessPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssociatedAccessPoliciesResponse]
 */
public fun EksClient.listAssociatedAccessPoliciesPaginated(initialRequest: ListAssociatedAccessPoliciesRequest): Flow<ListAssociatedAccessPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssociatedAccessPoliciesPaginated.listAssociatedAccessPolicies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAssociatedAccessPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssociatedAccessPoliciesResponse]
 */
public fun EksClient.listAssociatedAccessPoliciesPaginated(block: ListAssociatedAccessPoliciesRequest.Builder.() -> Unit): Flow<ListAssociatedAccessPoliciesResponse> =
    listAssociatedAccessPoliciesPaginated(ListAssociatedAccessPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAssociatedAccessPoliciesPaginated]
 * to access the nested member [AssociatedAccessPolicy]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AssociatedAccessPolicy]
 */
@JvmName("listAssociatedAccessPoliciesResponseAssociatedAccessPolicy")
public fun Flow<ListAssociatedAccessPoliciesResponse>.associatedAccessPolicies(): Flow<AssociatedAccessPolicy> =
    transform() { response ->
        response.associatedAccessPolicies?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
public fun EksClient.listClustersPaginated(initialRequest: ListClustersRequest = ListClustersRequest { }): Flow<ListClustersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClustersPaginated.listClusters(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
public fun EksClient.listClustersPaginated(block: ListClustersRequest.Builder.() -> Unit): Flow<ListClustersResponse> =
    listClustersPaginated(ListClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClustersPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listClustersResponseString")
public fun Flow<ListClustersResponse>.clusters(): Flow<String> =
    transform() { response ->
        response.clusters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEksAnywhereSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEksAnywhereSubscriptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEksAnywhereSubscriptionsResponse]
 */
public fun EksClient.listEksAnywhereSubscriptionsPaginated(initialRequest: ListEksAnywhereSubscriptionsRequest = ListEksAnywhereSubscriptionsRequest { }): Flow<ListEksAnywhereSubscriptionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEksAnywhereSubscriptionsPaginated.listEksAnywhereSubscriptions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEksAnywhereSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEksAnywhereSubscriptionsResponse]
 */
public fun EksClient.listEksAnywhereSubscriptionsPaginated(block: ListEksAnywhereSubscriptionsRequest.Builder.() -> Unit): Flow<ListEksAnywhereSubscriptionsResponse> =
    listEksAnywhereSubscriptionsPaginated(ListEksAnywhereSubscriptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEksAnywhereSubscriptionsPaginated]
 * to access the nested member [EksAnywhereSubscription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EksAnywhereSubscription]
 */
@JvmName("listEksAnywhereSubscriptionsResponseEksAnywhereSubscription")
public fun Flow<ListEksAnywhereSubscriptionsResponse>.subscriptions(): Flow<EksAnywhereSubscription> =
    transform() { response ->
        response.subscriptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFargateProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFargateProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFargateProfilesResponse]
 */
public fun EksClient.listFargateProfilesPaginated(initialRequest: ListFargateProfilesRequest): Flow<ListFargateProfilesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFargateProfilesPaginated.listFargateProfiles(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFargateProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFargateProfilesResponse]
 */
public fun EksClient.listFargateProfilesPaginated(block: ListFargateProfilesRequest.Builder.() -> Unit): Flow<ListFargateProfilesResponse> =
    listFargateProfilesPaginated(ListFargateProfilesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFargateProfilesPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listFargateProfilesResponseString")
public fun Flow<ListFargateProfilesResponse>.fargateProfileNames(): Flow<String> =
    transform() { response ->
        response.fargateProfileNames?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListIdentityProviderConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIdentityProviderConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentityProviderConfigsResponse]
 */
public fun EksClient.listIdentityProviderConfigsPaginated(initialRequest: ListIdentityProviderConfigsRequest): Flow<ListIdentityProviderConfigsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIdentityProviderConfigsPaginated.listIdentityProviderConfigs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListIdentityProviderConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentityProviderConfigsResponse]
 */
public fun EksClient.listIdentityProviderConfigsPaginated(block: ListIdentityProviderConfigsRequest.Builder.() -> Unit): Flow<ListIdentityProviderConfigsResponse> =
    listIdentityProviderConfigsPaginated(ListIdentityProviderConfigsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIdentityProviderConfigsPaginated]
 * to access the nested member [IdentityProviderConfig]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [IdentityProviderConfig]
 */
@JvmName("listIdentityProviderConfigsResponseIdentityProviderConfig")
public fun Flow<ListIdentityProviderConfigsResponse>.identityProviderConfigs(): Flow<IdentityProviderConfig> =
    transform() { response ->
        response.identityProviderConfigs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInsightsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInsightsResponse]
 */
public fun EksClient.listInsightsPaginated(initialRequest: ListInsightsRequest): Flow<ListInsightsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInsightsPaginated.listInsights(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInsightsResponse]
 */
public fun EksClient.listInsightsPaginated(block: ListInsightsRequest.Builder.() -> Unit): Flow<ListInsightsResponse> =
    listInsightsPaginated(ListInsightsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInsightsPaginated]
 * to access the nested member [InsightSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InsightSummary]
 */
@JvmName("listInsightsResponseInsightSummary")
public fun Flow<ListInsightsResponse>.insights(): Flow<InsightSummary> =
    transform() { response ->
        response.insights?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListNodegroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNodegroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNodegroupsResponse]
 */
public fun EksClient.listNodegroupsPaginated(initialRequest: ListNodegroupsRequest): Flow<ListNodegroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listNodegroupsPaginated.listNodegroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListNodegroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNodegroupsResponse]
 */
public fun EksClient.listNodegroupsPaginated(block: ListNodegroupsRequest.Builder.() -> Unit): Flow<ListNodegroupsResponse> =
    listNodegroupsPaginated(ListNodegroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listNodegroupsPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listNodegroupsResponseString")
public fun Flow<ListNodegroupsResponse>.nodegroups(): Flow<String> =
    transform() { response ->
        response.nodegroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPodIdentityAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPodIdentityAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPodIdentityAssociationsResponse]
 */
public fun EksClient.listPodIdentityAssociationsPaginated(initialRequest: ListPodIdentityAssociationsRequest): Flow<ListPodIdentityAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPodIdentityAssociationsPaginated.listPodIdentityAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPodIdentityAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPodIdentityAssociationsResponse]
 */
public fun EksClient.listPodIdentityAssociationsPaginated(block: ListPodIdentityAssociationsRequest.Builder.() -> Unit): Flow<ListPodIdentityAssociationsResponse> =
    listPodIdentityAssociationsPaginated(ListPodIdentityAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPodIdentityAssociationsPaginated]
 * to access the nested member [PodIdentityAssociationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PodIdentityAssociationSummary]
 */
@JvmName("listPodIdentityAssociationsResponsePodIdentityAssociationSummary")
public fun Flow<ListPodIdentityAssociationsResponse>.associations(): Flow<PodIdentityAssociationSummary> =
    transform() { response ->
        response.associations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUpdatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUpdatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUpdatesResponse]
 */
public fun EksClient.listUpdatesPaginated(initialRequest: ListUpdatesRequest): Flow<ListUpdatesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUpdatesPaginated.listUpdates(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListUpdatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUpdatesResponse]
 */
public fun EksClient.listUpdatesPaginated(block: ListUpdatesRequest.Builder.() -> Unit): Flow<ListUpdatesResponse> =
    listUpdatesPaginated(ListUpdatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUpdatesPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listUpdatesResponseString")
public fun Flow<ListUpdatesResponse>.updateIds(): Flow<String> =
    transform() { response ->
        response.updateIds?.forEach {
            emit(it)
        }
    }
