// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The summarized description of the association.
 *
 * Each summary is simplified by removing these fields compared to the full `PodIdentityAssociation`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_PodIdentityAssociation.html):
 * + The IAM role: `roleArn`
 * + The timestamp that the association was created at: `createdAt`
 * + The most recent timestamp that the association was modified at:. `modifiedAt`
 * + The tags on the association: `tags`
 */
public class PodIdentityAssociationSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the association.
     */
    public val associationArn: kotlin.String? = builder.associationArn
    /**
     * The ID of the association.
     */
    public val associationId: kotlin.String? = builder.associationId
    /**
     * The name of the cluster that the association is in.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * The name of the Kubernetes namespace inside the cluster to create the association in. The service account and the Pods that use the service account must be in this namespace.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * If defined, the association is owned by an Amazon EKS add-on.
     */
    public val ownerArn: kotlin.String? = builder.ownerArn
    /**
     * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
     */
    public val serviceAccount: kotlin.String? = builder.serviceAccount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.PodIdentityAssociationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PodIdentityAssociationSummary(")
        append("associationArn=$associationArn,")
        append("associationId=$associationId,")
        append("clusterName=$clusterName,")
        append("namespace=$namespace,")
        append("ownerArn=$ownerArn,")
        append("serviceAccount=$serviceAccount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationArn?.hashCode() ?: 0
        result = 31 * result + (associationId?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (ownerArn?.hashCode() ?: 0)
        result = 31 * result + (serviceAccount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PodIdentityAssociationSummary

        if (associationArn != other.associationArn) return false
        if (associationId != other.associationId) return false
        if (clusterName != other.clusterName) return false
        if (namespace != other.namespace) return false
        if (ownerArn != other.ownerArn) return false
        if (serviceAccount != other.serviceAccount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.PodIdentityAssociationSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the association.
         */
        public var associationArn: kotlin.String? = null
        /**
         * The ID of the association.
         */
        public var associationId: kotlin.String? = null
        /**
         * The name of the cluster that the association is in.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The name of the Kubernetes namespace inside the cluster to create the association in. The service account and the Pods that use the service account must be in this namespace.
         */
        public var namespace: kotlin.String? = null
        /**
         * If defined, the association is owned by an Amazon EKS add-on.
         */
        public var ownerArn: kotlin.String? = null
        /**
         * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
         */
        public var serviceAccount: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.PodIdentityAssociationSummary) : this() {
            this.associationArn = x.associationArn
            this.associationId = x.associationId
            this.clusterName = x.clusterName
            this.namespace = x.namespace
            this.ownerArn = x.ownerArn
            this.serviceAccount = x.serviceAccount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.PodIdentityAssociationSummary = PodIdentityAssociationSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
