// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Amazon EKS Pod Identity associations provide the ability to manage credentials for your applications, similar to the way that Amazon EC2 instance profiles provide credentials to Amazon EC2 instances.
 */
public class PodIdentityAssociation private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the association.
     */
    public val associationArn: kotlin.String? = builder.associationArn
    /**
     * The ID of the association.
     */
    public val associationId: kotlin.String? = builder.associationId
    /**
     * The name of the cluster that the association is in.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * The timestamp that the association was created at.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The state of the automatic sessions tags. The value of *true* disables these tags.
     *
     * EKS Pod Identity adds a pre-defined set of session tags when it assumes the role. You can use these tags to author a single role that can work across resources by allowing access to Amazon Web Services resources based on matching tags. By default, EKS Pod Identity attaches six tags, including tags for cluster name, namespace, and service account name. For the list of tags added by EKS Pod Identity, see [List of session tags added by EKS Pod Identity](https://docs.aws.amazon.com/eks/latest/userguide/pod-id-abac.html#pod-id-abac-tags) in the *Amazon EKS User Guide*.
     */
    public val disableSessionTags: kotlin.Boolean? = builder.disableSessionTags
    /**
     * The unique identifier for this EKS Pod Identity association for a target IAM role. You put this value in the trust policy of the target role, in a `Condition` to match the `sts.ExternalId`. This ensures that the target role can only be assumed by this association. This prevents the *confused deputy problem*. For more information about the confused deputy problem, see [The confused deputy problem](https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html) in the *IAM User Guide*.
     *
     * If you want to use the same target role with multiple associations or other roles, use independent statements in the trust policy to allow `sts:AssumeRole` access from each role.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * The most recent timestamp that the association was modified at.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedAt
    /**
     * The name of the Kubernetes namespace inside the cluster to create the association in. The service account and the Pods that use the service account must be in this namespace.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * If defined, the EKS Pod Identity association is owned by an Amazon EKS add-on.
     */
    public val ownerArn: kotlin.String? = builder.ownerArn
    /**
     * The Amazon Resource Name (ARN) of the IAM role to associate with the service account. The EKS Pod Identity agent manages credentials to assume this role for applications in the containers in the Pods that use this service account.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
     */
    public val serviceAccount: kotlin.String? = builder.serviceAccount
    /**
     * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource – 50
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length – 128 Unicode characters in UTF-8
     * + Maximum value length – 256 Unicode characters in UTF-8
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case-sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The Amazon Resource Name (ARN) of the target IAM role to associate with the service account. This role is assumed by using the EKS Pod Identity association role, then the credentials for this role are injected into the Pod.
     */
    public val targetRoleArn: kotlin.String? = builder.targetRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.PodIdentityAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PodIdentityAssociation(")
        append("associationArn=$associationArn,")
        append("associationId=$associationId,")
        append("clusterName=$clusterName,")
        append("createdAt=$createdAt,")
        append("disableSessionTags=$disableSessionTags,")
        append("externalId=$externalId,")
        append("modifiedAt=$modifiedAt,")
        append("namespace=$namespace,")
        append("ownerArn=$ownerArn,")
        append("roleArn=$roleArn,")
        append("serviceAccount=$serviceAccount,")
        append("tags=$tags,")
        append("targetRoleArn=$targetRoleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationArn?.hashCode() ?: 0
        result = 31 * result + (associationId?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (disableSessionTags?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (modifiedAt?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (ownerArn?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (serviceAccount?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PodIdentityAssociation

        if (associationArn != other.associationArn) return false
        if (associationId != other.associationId) return false
        if (clusterName != other.clusterName) return false
        if (createdAt != other.createdAt) return false
        if (disableSessionTags != other.disableSessionTags) return false
        if (externalId != other.externalId) return false
        if (modifiedAt != other.modifiedAt) return false
        if (namespace != other.namespace) return false
        if (ownerArn != other.ownerArn) return false
        if (roleArn != other.roleArn) return false
        if (serviceAccount != other.serviceAccount) return false
        if (tags != other.tags) return false
        if (targetRoleArn != other.targetRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.PodIdentityAssociation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the association.
         */
        public var associationArn: kotlin.String? = null
        /**
         * The ID of the association.
         */
        public var associationId: kotlin.String? = null
        /**
         * The name of the cluster that the association is in.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The timestamp that the association was created at.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the automatic sessions tags. The value of *true* disables these tags.
         *
         * EKS Pod Identity adds a pre-defined set of session tags when it assumes the role. You can use these tags to author a single role that can work across resources by allowing access to Amazon Web Services resources based on matching tags. By default, EKS Pod Identity attaches six tags, including tags for cluster name, namespace, and service account name. For the list of tags added by EKS Pod Identity, see [List of session tags added by EKS Pod Identity](https://docs.aws.amazon.com/eks/latest/userguide/pod-id-abac.html#pod-id-abac-tags) in the *Amazon EKS User Guide*.
         */
        public var disableSessionTags: kotlin.Boolean? = null
        /**
         * The unique identifier for this EKS Pod Identity association for a target IAM role. You put this value in the trust policy of the target role, in a `Condition` to match the `sts.ExternalId`. This ensures that the target role can only be assumed by this association. This prevents the *confused deputy problem*. For more information about the confused deputy problem, see [The confused deputy problem](https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html) in the *IAM User Guide*.
         *
         * If you want to use the same target role with multiple associations or other roles, use independent statements in the trust policy to allow `sts:AssumeRole` access from each role.
         */
        public var externalId: kotlin.String? = null
        /**
         * The most recent timestamp that the association was modified at.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the Kubernetes namespace inside the cluster to create the association in. The service account and the Pods that use the service account must be in this namespace.
         */
        public var namespace: kotlin.String? = null
        /**
         * If defined, the EKS Pod Identity association is owned by an Amazon EKS add-on.
         */
        public var ownerArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role to associate with the service account. The EKS Pod Identity agent manages credentials to assume this role for applications in the containers in the Pods that use this service account.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
         */
        public var serviceAccount: kotlin.String? = null
        /**
         * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource – 50
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length – 128 Unicode characters in UTF-8
         * + Maximum value length – 256 Unicode characters in UTF-8
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case-sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         */
        public var tags: Map<String, String>? = null
        /**
         * The Amazon Resource Name (ARN) of the target IAM role to associate with the service account. This role is assumed by using the EKS Pod Identity association role, then the credentials for this role are injected into the Pod.
         */
        public var targetRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.PodIdentityAssociation) : this() {
            this.associationArn = x.associationArn
            this.associationId = x.associationId
            this.clusterName = x.clusterName
            this.createdAt = x.createdAt
            this.disableSessionTags = x.disableSessionTags
            this.externalId = x.externalId
            this.modifiedAt = x.modifiedAt
            this.namespace = x.namespace
            this.ownerArn = x.ownerArn
            this.roleArn = x.roleArn
            this.serviceAccount = x.serviceAccount
            this.tags = x.tags
            this.targetRoleArn = x.targetRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.PodIdentityAssociation = PodIdentityAssociation(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
