// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The node group update configuration. An Amazon EKS managed node group updates by replacing nodes with new nodes of newer AMI versions in parallel. You choose the *maximum unavailable* and the *update strategy*.
 */
public class NodegroupUpdateConfig private constructor(builder: Builder) {
    /**
     * The maximum number of nodes unavailable at once during a version update. Nodes are updated in parallel. This value or `maxUnavailablePercentage` is required to have a value.The maximum number is 100.
     */
    public val maxUnavailable: kotlin.Int? = builder.maxUnavailable
    /**
     * The maximum percentage of nodes unavailable during a version update. This percentage of nodes are updated in parallel, up to 100 nodes at once. This value or `maxUnavailable` is required to have a value.
     */
    public val maxUnavailablePercentage: kotlin.Int? = builder.maxUnavailablePercentage
    /**
     * The configuration for the behavior to follow during a node group version update of this managed node group. You choose between two possible strategies for replacing nodes during an `UpdateNodegroupVersion`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateNodegroupVersion.html) action.
     *
     * An Amazon EKS managed node group updates by replacing nodes with new nodes of newer AMI versions in parallel. The *update strategy* changes the managed node update behavior of the managed node group for each quantity. The *default* strategy has guardrails to protect you from misconfiguration and launches the new instances first, before terminating the old instances. The *minimal* strategy removes the guardrails and terminates the old instances before launching the new instances. This minimal strategy is useful in scenarios where you are constrained to resources or costs (for example, with hardware accelerators such as GPUs).
     */
    public val updateStrategy: aws.sdk.kotlin.services.eks.model.NodegroupUpdateStrategies? = builder.updateStrategy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NodegroupUpdateConfig(")
        append("maxUnavailable=$maxUnavailable,")
        append("maxUnavailablePercentage=$maxUnavailablePercentage,")
        append("updateStrategy=$updateStrategy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxUnavailable ?: 0
        result = 31 * result + (maxUnavailablePercentage ?: 0)
        result = 31 * result + (updateStrategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NodegroupUpdateConfig

        if (maxUnavailable != other.maxUnavailable) return false
        if (maxUnavailablePercentage != other.maxUnavailablePercentage) return false
        if (updateStrategy != other.updateStrategy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum number of nodes unavailable at once during a version update. Nodes are updated in parallel. This value or `maxUnavailablePercentage` is required to have a value.The maximum number is 100.
         */
        public var maxUnavailable: kotlin.Int? = null
        /**
         * The maximum percentage of nodes unavailable during a version update. This percentage of nodes are updated in parallel, up to 100 nodes at once. This value or `maxUnavailable` is required to have a value.
         */
        public var maxUnavailablePercentage: kotlin.Int? = null
        /**
         * The configuration for the behavior to follow during a node group version update of this managed node group. You choose between two possible strategies for replacing nodes during an `UpdateNodegroupVersion`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateNodegroupVersion.html) action.
         *
         * An Amazon EKS managed node group updates by replacing nodes with new nodes of newer AMI versions in parallel. The *update strategy* changes the managed node update behavior of the managed node group for each quantity. The *default* strategy has guardrails to protect you from misconfiguration and launches the new instances first, before terminating the old instances. The *minimal* strategy removes the guardrails and terminates the old instances before launching the new instances. This minimal strategy is useful in scenarios where you are constrained to resources or costs (for example, with hardware accelerators such as GPUs).
         */
        public var updateStrategy: aws.sdk.kotlin.services.eks.model.NodegroupUpdateStrategies? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig) : this() {
            this.maxUnavailable = x.maxUnavailable
            this.maxUnavailablePercentage = x.maxUnavailablePercentage
            this.updateStrategy = x.updateStrategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig = NodegroupUpdateConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
