// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object representing the scaling configuration details for the Auto Scaling group that is associated with your node group. When creating a node group, you must specify all or none of the properties. When updating a node group, you can specify any or none of the properties.
 */
public class NodegroupScalingConfig private constructor(builder: Builder) {
    /**
     * The current number of nodes that the managed node group should maintain.
     *
     * If you use the Kubernetes [Cluster Autoscaler](https://github.com/kubernetes/autoscaler#kubernetes-autoscaler), you shouldn't change the `desiredSize` value directly, as this can cause the Cluster Autoscaler to suddenly scale up or scale down.
     *
     * Whenever this parameter changes, the number of worker nodes in the node group is updated to the specified size. If this parameter is given a value that is smaller than the current number of running worker nodes, the necessary number of worker nodes are terminated to match the given value. When using CloudFormation, no action occurs if you remove this parameter from your CFN template.
     *
     * This parameter can be different from `minSize` in some cases, such as when starting with extra hosts for testing. This parameter can also be different when you want to start with an estimated number of needed hosts, but let the Cluster Autoscaler reduce the number if there are too many. When the Cluster Autoscaler is used, the `desiredSize` parameter is altered by the Cluster Autoscaler (but can be out-of-date for short periods of time). the Cluster Autoscaler doesn't scale a managed node group lower than `minSize` or higher than `maxSize`.
     */
    public val desiredSize: kotlin.Int? = builder.desiredSize
    /**
     * The maximum number of nodes that the managed node group can scale out to. For information about the maximum number that you can specify, see [Amazon EKS service quotas](https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html) in the *Amazon EKS User Guide*.
     */
    public val maxSize: kotlin.Int? = builder.maxSize
    /**
     * The minimum number of nodes that the managed node group can scale in to.
     */
    public val minSize: kotlin.Int? = builder.minSize

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NodegroupScalingConfig(")
        append("desiredSize=$desiredSize,")
        append("maxSize=$maxSize,")
        append("minSize=$minSize")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = desiredSize ?: 0
        result = 31 * result + (maxSize ?: 0)
        result = 31 * result + (minSize ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NodegroupScalingConfig

        if (desiredSize != other.desiredSize) return false
        if (maxSize != other.maxSize) return false
        if (minSize != other.minSize) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The current number of nodes that the managed node group should maintain.
         *
         * If you use the Kubernetes [Cluster Autoscaler](https://github.com/kubernetes/autoscaler#kubernetes-autoscaler), you shouldn't change the `desiredSize` value directly, as this can cause the Cluster Autoscaler to suddenly scale up or scale down.
         *
         * Whenever this parameter changes, the number of worker nodes in the node group is updated to the specified size. If this parameter is given a value that is smaller than the current number of running worker nodes, the necessary number of worker nodes are terminated to match the given value. When using CloudFormation, no action occurs if you remove this parameter from your CFN template.
         *
         * This parameter can be different from `minSize` in some cases, such as when starting with extra hosts for testing. This parameter can also be different when you want to start with an estimated number of needed hosts, but let the Cluster Autoscaler reduce the number if there are too many. When the Cluster Autoscaler is used, the `desiredSize` parameter is altered by the Cluster Autoscaler (but can be out-of-date for short periods of time). the Cluster Autoscaler doesn't scale a managed node group lower than `minSize` or higher than `maxSize`.
         */
        public var desiredSize: kotlin.Int? = null
        /**
         * The maximum number of nodes that the managed node group can scale out to. For information about the maximum number that you can specify, see [Amazon EKS service quotas](https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html) in the *Amazon EKS User Guide*.
         */
        public var maxSize: kotlin.Int? = null
        /**
         * The minimum number of nodes that the managed node group can scale in to.
         */
        public var minSize: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig) : this() {
            this.desiredSize = x.desiredSize
            this.maxSize = x.maxSize
            this.minSize = x.minSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig = NodegroupScalingConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
