// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * Amazon EKS detected upgrade readiness issues. Call the `ListInsights`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListInsights.html) API to view detected upgrade blocking issues. Pass the `force`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateClusterVersion.html#API_UpdateClusterVersion_RequestBody) flag when updating to override upgrade readiness errors.
 */
public class InvalidStateException private constructor(builder: Builder) : EksException(builder.message) {

    /**
     * The Amazon EKS cluster associated with the exception.
     */
    public val clusterName: kotlin.String? = builder.clusterName

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.InvalidStateException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvalidStateException(")
        append("clusterName=$clusterName,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterName?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvalidStateException

        if (clusterName != other.clusterName) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.InvalidStateException = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon EKS cluster associated with the exception.
         */
        public var clusterName: kotlin.String? = null
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.InvalidStateException) : this() {
            this.clusterName = x.clusterName
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.InvalidStateException = InvalidStateException(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
