// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object representing an Fargate profile.
 */
public class FargateProfile private constructor(builder: Builder) {
    /**
     * The name of your cluster.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * The Unix epoch timestamp at object creation.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The full Amazon Resource Name (ARN) of the Fargate profile.
     */
    public val fargateProfileArn: kotlin.String? = builder.fargateProfileArn
    /**
     * The name of the Fargate profile.
     */
    public val fargateProfileName: kotlin.String? = builder.fargateProfileName
    /**
     * The health status of the Fargate profile. If there are issues with your Fargate profile's health, they are listed here.
     */
    public val health: aws.sdk.kotlin.services.eks.model.FargateProfileHealth? = builder.health
    /**
     * The Amazon Resource Name (ARN) of the `Pod` execution role to use for any `Pod` that matches the selectors in the Fargate profile. For more information, see `Pod`[ execution role](https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html) in the *Amazon EKS User Guide*.
     */
    public val podExecutionRoleArn: kotlin.String? = builder.podExecutionRoleArn
    /**
     * The selectors to match for a `Pod` to use this Fargate profile.
     */
    public val selectors: List<FargateProfileSelector>? = builder.selectors
    /**
     * The current status of the Fargate profile.
     */
    public val status: aws.sdk.kotlin.services.eks.model.FargateProfileStatus? = builder.status
    /**
     * The IDs of subnets to launch a `Pod` into.
     */
    public val subnets: List<String>? = builder.subnets
    /**
     * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.FargateProfile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FargateProfile(")
        append("clusterName=$clusterName,")
        append("createdAt=$createdAt,")
        append("fargateProfileArn=$fargateProfileArn,")
        append("fargateProfileName=$fargateProfileName,")
        append("health=$health,")
        append("podExecutionRoleArn=$podExecutionRoleArn,")
        append("selectors=$selectors,")
        append("status=$status,")
        append("subnets=$subnets,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterName?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (fargateProfileArn?.hashCode() ?: 0)
        result = 31 * result + (fargateProfileName?.hashCode() ?: 0)
        result = 31 * result + (health?.hashCode() ?: 0)
        result = 31 * result + (podExecutionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (selectors?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FargateProfile

        if (clusterName != other.clusterName) return false
        if (createdAt != other.createdAt) return false
        if (fargateProfileArn != other.fargateProfileArn) return false
        if (fargateProfileName != other.fargateProfileName) return false
        if (health != other.health) return false
        if (podExecutionRoleArn != other.podExecutionRoleArn) return false
        if (selectors != other.selectors) return false
        if (status != other.status) return false
        if (subnets != other.subnets) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.FargateProfile = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of your cluster.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The Unix epoch timestamp at object creation.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The full Amazon Resource Name (ARN) of the Fargate profile.
         */
        public var fargateProfileArn: kotlin.String? = null
        /**
         * The name of the Fargate profile.
         */
        public var fargateProfileName: kotlin.String? = null
        /**
         * The health status of the Fargate profile. If there are issues with your Fargate profile's health, they are listed here.
         */
        public var health: aws.sdk.kotlin.services.eks.model.FargateProfileHealth? = null
        /**
         * The Amazon Resource Name (ARN) of the `Pod` execution role to use for any `Pod` that matches the selectors in the Fargate profile. For more information, see `Pod`[ execution role](https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html) in the *Amazon EKS User Guide*.
         */
        public var podExecutionRoleArn: kotlin.String? = null
        /**
         * The selectors to match for a `Pod` to use this Fargate profile.
         */
        public var selectors: List<FargateProfileSelector>? = null
        /**
         * The current status of the Fargate profile.
         */
        public var status: aws.sdk.kotlin.services.eks.model.FargateProfileStatus? = null
        /**
         * The IDs of subnets to launch a `Pod` into.
         */
        public var subnets: List<String>? = null
        /**
         * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.FargateProfile) : this() {
            this.clusterName = x.clusterName
            this.createdAt = x.createdAt
            this.fargateProfileArn = x.fargateProfileArn
            this.fargateProfileName = x.fargateProfileName
            this.health = x.health
            this.podExecutionRoleArn = x.podExecutionRoleArn
            this.selectors = x.selectors
            this.status = x.status
            this.subnets = x.subnets
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.FargateProfile = FargateProfile(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.FargateProfileHealth] inside the given [block]
         */
        public fun health(block: aws.sdk.kotlin.services.eks.model.FargateProfileHealth.Builder.() -> kotlin.Unit) {
            this.health = aws.sdk.kotlin.services.eks.model.FargateProfileHealth.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
