// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Request to update the configuration of the compute capability of your EKS Auto Mode cluster. For example, enable the capability. For more information, see EKS Auto Mode compute capability in the *Amazon EKS User Guide*.
 */
public class ComputeConfigRequest private constructor(builder: Builder) {
    /**
     * Request to enable or disable the compute capability on your EKS Auto Mode cluster. If the compute capability is enabled, EKS Auto Mode will create and delete EC2 Managed Instances in your Amazon Web Services account.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * Configuration for node pools that defines the compute resources for your EKS Auto Mode cluster. For more information, see EKS Auto Mode Node Pools in the *Amazon EKS User Guide*.
     */
    public val nodePools: List<String>? = builder.nodePools
    /**
     * The ARN of the IAM Role EKS will assign to EC2 Managed Instances in your EKS Auto Mode cluster. This value cannot be changed after the compute capability of EKS Auto Mode is enabled. For more information, see the IAM Reference in the *Amazon EKS User Guide*.
     */
    public val nodeRoleArn: kotlin.String? = builder.nodeRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.ComputeConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComputeConfigRequest(")
        append("enabled=$enabled,")
        append("nodePools=$nodePools,")
        append("nodeRoleArn=$nodeRoleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (nodePools?.hashCode() ?: 0)
        result = 31 * result + (nodeRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComputeConfigRequest

        if (enabled != other.enabled) return false
        if (nodePools != other.nodePools) return false
        if (nodeRoleArn != other.nodeRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.ComputeConfigRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Request to enable or disable the compute capability on your EKS Auto Mode cluster. If the compute capability is enabled, EKS Auto Mode will create and delete EC2 Managed Instances in your Amazon Web Services account.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * Configuration for node pools that defines the compute resources for your EKS Auto Mode cluster. For more information, see EKS Auto Mode Node Pools in the *Amazon EKS User Guide*.
         */
        public var nodePools: List<String>? = null
        /**
         * The ARN of the IAM Role EKS will assign to EC2 Managed Instances in your EKS Auto Mode cluster. This value cannot be changed after the compute capability of EKS Auto Mode is enabled. For more information, see the IAM Reference in the *Amazon EKS User Guide*.
         */
        public var nodeRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.ComputeConfigRequest) : this() {
            this.enabled = x.enabled
            this.nodePools = x.nodePools
            this.nodeRoleArn = x.nodeRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.ComputeConfigRequest = ComputeConfigRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
