// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about a specific EKS cluster version.
 */
public class ClusterVersionInformation private constructor(builder: Builder) {
    /**
     * The type of cluster this version is for.
     */
    public val clusterType: kotlin.String? = builder.clusterType
    /**
     * The Kubernetes version for the cluster.
     */
    public val clusterVersion: kotlin.String? = builder.clusterVersion
    /**
     * Default platform version for this Kubernetes version.
     */
    public val defaultPlatformVersion: kotlin.String? = builder.defaultPlatformVersion
    /**
     * Indicates if this is a default version.
     */
    public val defaultVersion: kotlin.Boolean = builder.defaultVersion
    /**
     * Date when extended support ends for this version.
     */
    public val endOfExtendedSupportDate: aws.smithy.kotlin.runtime.time.Instant? = builder.endOfExtendedSupportDate
    /**
     * Date when standard support ends for this version.
     */
    public val endOfStandardSupportDate: aws.smithy.kotlin.runtime.time.Instant? = builder.endOfStandardSupportDate
    /**
     * The patch version of Kubernetes for this cluster version.
     */
    public val kubernetesPatchVersion: kotlin.String? = builder.kubernetesPatchVersion
    /**
     * The release date of this cluster version.
     */
    public val releaseDate: aws.smithy.kotlin.runtime.time.Instant? = builder.releaseDate
    /**
     * This field is deprecated. Use `versionStatus` instead, as that field matches for input and output of this action.
     *
     * Current status of this cluster version.
     */
    public val status: aws.sdk.kotlin.services.eks.model.ClusterVersionStatus? = builder.status
    /**
     * Current status of this cluster version.
     */
    public val versionStatus: aws.sdk.kotlin.services.eks.model.VersionStatus? = builder.versionStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.ClusterVersionInformation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterVersionInformation(")
        append("clusterType=$clusterType,")
        append("clusterVersion=$clusterVersion,")
        append("defaultPlatformVersion=$defaultPlatformVersion,")
        append("defaultVersion=$defaultVersion,")
        append("endOfExtendedSupportDate=$endOfExtendedSupportDate,")
        append("endOfStandardSupportDate=$endOfStandardSupportDate,")
        append("kubernetesPatchVersion=$kubernetesPatchVersion,")
        append("releaseDate=$releaseDate,")
        append("status=$status,")
        append("versionStatus=$versionStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterType?.hashCode() ?: 0
        result = 31 * result + (clusterVersion?.hashCode() ?: 0)
        result = 31 * result + (defaultPlatformVersion?.hashCode() ?: 0)
        result = 31 * result + (defaultVersion.hashCode())
        result = 31 * result + (endOfExtendedSupportDate?.hashCode() ?: 0)
        result = 31 * result + (endOfStandardSupportDate?.hashCode() ?: 0)
        result = 31 * result + (kubernetesPatchVersion?.hashCode() ?: 0)
        result = 31 * result + (releaseDate?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (versionStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterVersionInformation

        if (clusterType != other.clusterType) return false
        if (clusterVersion != other.clusterVersion) return false
        if (defaultPlatformVersion != other.defaultPlatformVersion) return false
        if (defaultVersion != other.defaultVersion) return false
        if (endOfExtendedSupportDate != other.endOfExtendedSupportDate) return false
        if (endOfStandardSupportDate != other.endOfStandardSupportDate) return false
        if (kubernetesPatchVersion != other.kubernetesPatchVersion) return false
        if (releaseDate != other.releaseDate) return false
        if (status != other.status) return false
        if (versionStatus != other.versionStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.ClusterVersionInformation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of cluster this version is for.
         */
        public var clusterType: kotlin.String? = null
        /**
         * The Kubernetes version for the cluster.
         */
        public var clusterVersion: kotlin.String? = null
        /**
         * Default platform version for this Kubernetes version.
         */
        public var defaultPlatformVersion: kotlin.String? = null
        /**
         * Indicates if this is a default version.
         */
        public var defaultVersion: kotlin.Boolean = false
        /**
         * Date when extended support ends for this version.
         */
        public var endOfExtendedSupportDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Date when standard support ends for this version.
         */
        public var endOfStandardSupportDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The patch version of Kubernetes for this cluster version.
         */
        public var kubernetesPatchVersion: kotlin.String? = null
        /**
         * The release date of this cluster version.
         */
        public var releaseDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This field is deprecated. Use `versionStatus` instead, as that field matches for input and output of this action.
         *
         * Current status of this cluster version.
         */
        public var status: aws.sdk.kotlin.services.eks.model.ClusterVersionStatus? = null
        /**
         * Current status of this cluster version.
         */
        public var versionStatus: aws.sdk.kotlin.services.eks.model.VersionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.ClusterVersionInformation) : this() {
            this.clusterType = x.clusterType
            this.clusterVersion = x.clusterVersion
            this.defaultPlatformVersion = x.defaultPlatformVersion
            this.defaultVersion = x.defaultVersion
            this.endOfExtendedSupportDate = x.endOfExtendedSupportDate
            this.endOfStandardSupportDate = x.endOfStandardSupportDate
            this.kubernetesPatchVersion = x.kubernetesPatchVersion
            this.releaseDate = x.releaseDate
            this.status = x.status
            this.versionStatus = x.versionStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.ClusterVersionInformation = ClusterVersionInformation(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
