// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object representing an Amazon EKS cluster.
 */
public class Cluster private constructor(builder: Builder) {
    /**
     * The access configuration for the cluster.
     */
    public val accessConfig: aws.sdk.kotlin.services.eks.model.AccessConfigResponse? = builder.accessConfig
    /**
     * The Amazon Resource Name (ARN) of the cluster.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The `certificate-authority-data` for your cluster.
     */
    public val certificateAuthority: aws.sdk.kotlin.services.eks.model.Certificate? = builder.certificateAuthority
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Indicates the current configuration of the compute capability on your EKS Auto Mode cluster. For example, if the capability is enabled or disabled. If the compute capability is enabled, EKS Auto Mode will create and delete EC2 Managed Instances in your Amazon Web Services account. For more information, see EKS Auto Mode compute capability in the *Amazon EKS User Guide*.
     */
    public val computeConfig: aws.sdk.kotlin.services.eks.model.ComputeConfigResponse? = builder.computeConfig
    /**
     * The configuration used to connect to a cluster for registration.
     */
    public val connectorConfig: aws.sdk.kotlin.services.eks.model.ConnectorConfigResponse? = builder.connectorConfig
    /**
     * The Unix epoch timestamp at object creation.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The current deletion protection setting for the cluster. When `true`, deletion protection is enabled and the cluster cannot be deleted until protection is disabled. When `false`, the cluster can be deleted normally. This setting only applies to clusters in an active state.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The encryption configuration for the cluster.
     */
    public val encryptionConfig: List<EncryptionConfig>? = builder.encryptionConfig
    /**
     * The endpoint for your Kubernetes API server.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * An object representing the health of your Amazon EKS cluster.
     */
    public val health: aws.sdk.kotlin.services.eks.model.ClusterHealth? = builder.health
    /**
     * The ID of your local Amazon EKS cluster on an Amazon Web Services Outpost. This property isn't available for an Amazon EKS cluster on the Amazon Web Services cloud.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The identity provider information for the cluster.
     */
    public val identity: aws.sdk.kotlin.services.eks.model.Identity? = builder.identity
    /**
     * The Kubernetes network configuration for the cluster.
     */
    public val kubernetesNetworkConfig: aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigResponse? = builder.kubernetesNetworkConfig
    /**
     * The logging configuration for your cluster.
     */
    public val logging: aws.sdk.kotlin.services.eks.model.Logging? = builder.logging
    /**
     * The name of your cluster.
     */
    public val name: kotlin.String? = builder.name
    /**
     * An object representing the configuration of your local Amazon EKS cluster on an Amazon Web Services Outpost. This object isn't available for clusters on the Amazon Web Services cloud.
     */
    public val outpostConfig: aws.sdk.kotlin.services.eks.model.OutpostConfigResponse? = builder.outpostConfig
    /**
     * The platform version of your Amazon EKS cluster. For more information about clusters deployed on the Amazon Web Services Cloud, see [Platform versions](https://docs.aws.amazon.com/eks/latest/userguide/platform-versions.html) in the **Amazon EKS User Guide**. For more information about local clusters deployed on an Outpost, see [Amazon EKS local cluster platform versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-platform-versions.html) in the **Amazon EKS User Guide**.
     */
    public val platformVersion: kotlin.String? = builder.platformVersion
    /**
     * The configuration in the cluster for EKS Hybrid Nodes. You can add, change, or remove this configuration after the cluster is created.
     */
    public val remoteNetworkConfig: aws.sdk.kotlin.services.eks.model.RemoteNetworkConfigResponse? = builder.remoteNetworkConfig
    /**
     * The VPC configuration used by the cluster control plane. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see [Cluster VPC considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) and [Cluster security group considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the *Amazon EKS User Guide*.
     */
    public val resourcesVpcConfig: aws.sdk.kotlin.services.eks.model.VpcConfigResponse? = builder.resourcesVpcConfig
    /**
     * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to Amazon Web Services API operations on your behalf.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The current status of the cluster.
     */
    public val status: aws.sdk.kotlin.services.eks.model.ClusterStatus? = builder.status
    /**
     * Indicates the current configuration of the block storage capability on your EKS Auto Mode cluster. For example, if the capability is enabled or disabled. If the block storage capability is enabled, EKS Auto Mode will create and delete EBS volumes in your Amazon Web Services account. For more information, see EKS Auto Mode block storage capability in the *Amazon EKS User Guide*.
     */
    public val storageConfig: aws.sdk.kotlin.services.eks.model.StorageConfigResponse? = builder.storageConfig
    /**
     * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * This value indicates if extended support is enabled or disabled for the cluster.
     *
     * *Amazon EKS User Guide*[.](https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html)
     */
    public val upgradePolicy: aws.sdk.kotlin.services.eks.model.UpgradePolicyResponse? = builder.upgradePolicy
    /**
     * The Kubernetes server version for the cluster.
     */
    public val version: kotlin.String? = builder.version
    /**
     * The configuration for zonal shift for the cluster.
     */
    public val zonalShiftConfig: aws.sdk.kotlin.services.eks.model.ZonalShiftConfigResponse? = builder.zonalShiftConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.Cluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Cluster(")
        append("accessConfig=$accessConfig,")
        append("arn=$arn,")
        append("certificateAuthority=$certificateAuthority,")
        append("clientRequestToken=$clientRequestToken,")
        append("computeConfig=$computeConfig,")
        append("connectorConfig=$connectorConfig,")
        append("createdAt=$createdAt,")
        append("deletionProtection=$deletionProtection,")
        append("encryptionConfig=$encryptionConfig,")
        append("endpoint=$endpoint,")
        append("health=$health,")
        append("id=$id,")
        append("identity=$identity,")
        append("kubernetesNetworkConfig=$kubernetesNetworkConfig,")
        append("logging=$logging,")
        append("name=$name,")
        append("outpostConfig=$outpostConfig,")
        append("platformVersion=$platformVersion,")
        append("remoteNetworkConfig=$remoteNetworkConfig,")
        append("resourcesVpcConfig=$resourcesVpcConfig,")
        append("roleArn=$roleArn,")
        append("status=$status,")
        append("storageConfig=$storageConfig,")
        append("tags=$tags,")
        append("upgradePolicy=$upgradePolicy,")
        append("version=$version,")
        append("zonalShiftConfig=$zonalShiftConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessConfig?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (certificateAuthority?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (computeConfig?.hashCode() ?: 0)
        result = 31 * result + (connectorConfig?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfig?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (health?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (identity?.hashCode() ?: 0)
        result = 31 * result + (kubernetesNetworkConfig?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outpostConfig?.hashCode() ?: 0)
        result = 31 * result + (platformVersion?.hashCode() ?: 0)
        result = 31 * result + (remoteNetworkConfig?.hashCode() ?: 0)
        result = 31 * result + (resourcesVpcConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (upgradePolicy?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (zonalShiftConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Cluster

        if (accessConfig != other.accessConfig) return false
        if (arn != other.arn) return false
        if (certificateAuthority != other.certificateAuthority) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (computeConfig != other.computeConfig) return false
        if (connectorConfig != other.connectorConfig) return false
        if (createdAt != other.createdAt) return false
        if (deletionProtection != other.deletionProtection) return false
        if (encryptionConfig != other.encryptionConfig) return false
        if (endpoint != other.endpoint) return false
        if (health != other.health) return false
        if (id != other.id) return false
        if (identity != other.identity) return false
        if (kubernetesNetworkConfig != other.kubernetesNetworkConfig) return false
        if (logging != other.logging) return false
        if (name != other.name) return false
        if (outpostConfig != other.outpostConfig) return false
        if (platformVersion != other.platformVersion) return false
        if (remoteNetworkConfig != other.remoteNetworkConfig) return false
        if (resourcesVpcConfig != other.resourcesVpcConfig) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false
        if (storageConfig != other.storageConfig) return false
        if (tags != other.tags) return false
        if (upgradePolicy != other.upgradePolicy) return false
        if (version != other.version) return false
        if (zonalShiftConfig != other.zonalShiftConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.Cluster = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The access configuration for the cluster.
         */
        public var accessConfig: aws.sdk.kotlin.services.eks.model.AccessConfigResponse? = null
        /**
         * The Amazon Resource Name (ARN) of the cluster.
         */
        public var arn: kotlin.String? = null
        /**
         * The `certificate-authority-data` for your cluster.
         */
        public var certificateAuthority: aws.sdk.kotlin.services.eks.model.Certificate? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Indicates the current configuration of the compute capability on your EKS Auto Mode cluster. For example, if the capability is enabled or disabled. If the compute capability is enabled, EKS Auto Mode will create and delete EC2 Managed Instances in your Amazon Web Services account. For more information, see EKS Auto Mode compute capability in the *Amazon EKS User Guide*.
         */
        public var computeConfig: aws.sdk.kotlin.services.eks.model.ComputeConfigResponse? = null
        /**
         * The configuration used to connect to a cluster for registration.
         */
        public var connectorConfig: aws.sdk.kotlin.services.eks.model.ConnectorConfigResponse? = null
        /**
         * The Unix epoch timestamp at object creation.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current deletion protection setting for the cluster. When `true`, deletion protection is enabled and the cluster cannot be deleted until protection is disabled. When `false`, the cluster can be deleted normally. This setting only applies to clusters in an active state.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The encryption configuration for the cluster.
         */
        public var encryptionConfig: List<EncryptionConfig>? = null
        /**
         * The endpoint for your Kubernetes API server.
         */
        public var endpoint: kotlin.String? = null
        /**
         * An object representing the health of your Amazon EKS cluster.
         */
        public var health: aws.sdk.kotlin.services.eks.model.ClusterHealth? = null
        /**
         * The ID of your local Amazon EKS cluster on an Amazon Web Services Outpost. This property isn't available for an Amazon EKS cluster on the Amazon Web Services cloud.
         */
        public var id: kotlin.String? = null
        /**
         * The identity provider information for the cluster.
         */
        public var identity: aws.sdk.kotlin.services.eks.model.Identity? = null
        /**
         * The Kubernetes network configuration for the cluster.
         */
        public var kubernetesNetworkConfig: aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigResponse? = null
        /**
         * The logging configuration for your cluster.
         */
        public var logging: aws.sdk.kotlin.services.eks.model.Logging? = null
        /**
         * The name of your cluster.
         */
        public var name: kotlin.String? = null
        /**
         * An object representing the configuration of your local Amazon EKS cluster on an Amazon Web Services Outpost. This object isn't available for clusters on the Amazon Web Services cloud.
         */
        public var outpostConfig: aws.sdk.kotlin.services.eks.model.OutpostConfigResponse? = null
        /**
         * The platform version of your Amazon EKS cluster. For more information about clusters deployed on the Amazon Web Services Cloud, see [Platform versions](https://docs.aws.amazon.com/eks/latest/userguide/platform-versions.html) in the **Amazon EKS User Guide**. For more information about local clusters deployed on an Outpost, see [Amazon EKS local cluster platform versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-platform-versions.html) in the **Amazon EKS User Guide**.
         */
        public var platformVersion: kotlin.String? = null
        /**
         * The configuration in the cluster for EKS Hybrid Nodes. You can add, change, or remove this configuration after the cluster is created.
         */
        public var remoteNetworkConfig: aws.sdk.kotlin.services.eks.model.RemoteNetworkConfigResponse? = null
        /**
         * The VPC configuration used by the cluster control plane. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see [Cluster VPC considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) and [Cluster security group considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the *Amazon EKS User Guide*.
         */
        public var resourcesVpcConfig: aws.sdk.kotlin.services.eks.model.VpcConfigResponse? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to Amazon Web Services API operations on your behalf.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The current status of the cluster.
         */
        public var status: aws.sdk.kotlin.services.eks.model.ClusterStatus? = null
        /**
         * Indicates the current configuration of the block storage capability on your EKS Auto Mode cluster. For example, if the capability is enabled or disabled. If the block storage capability is enabled, EKS Auto Mode will create and delete EBS volumes in your Amazon Web Services account. For more information, see EKS Auto Mode block storage capability in the *Amazon EKS User Guide*.
         */
        public var storageConfig: aws.sdk.kotlin.services.eks.model.StorageConfigResponse? = null
        /**
         * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         */
        public var tags: Map<String, String>? = null
        /**
         * This value indicates if extended support is enabled or disabled for the cluster.
         *
         * *Amazon EKS User Guide*[.](https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html)
         */
        public var upgradePolicy: aws.sdk.kotlin.services.eks.model.UpgradePolicyResponse? = null
        /**
         * The Kubernetes server version for the cluster.
         */
        public var version: kotlin.String? = null
        /**
         * The configuration for zonal shift for the cluster.
         */
        public var zonalShiftConfig: aws.sdk.kotlin.services.eks.model.ZonalShiftConfigResponse? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.Cluster) : this() {
            this.accessConfig = x.accessConfig
            this.arn = x.arn
            this.certificateAuthority = x.certificateAuthority
            this.clientRequestToken = x.clientRequestToken
            this.computeConfig = x.computeConfig
            this.connectorConfig = x.connectorConfig
            this.createdAt = x.createdAt
            this.deletionProtection = x.deletionProtection
            this.encryptionConfig = x.encryptionConfig
            this.endpoint = x.endpoint
            this.health = x.health
            this.id = x.id
            this.identity = x.identity
            this.kubernetesNetworkConfig = x.kubernetesNetworkConfig
            this.logging = x.logging
            this.name = x.name
            this.outpostConfig = x.outpostConfig
            this.platformVersion = x.platformVersion
            this.remoteNetworkConfig = x.remoteNetworkConfig
            this.resourcesVpcConfig = x.resourcesVpcConfig
            this.roleArn = x.roleArn
            this.status = x.status
            this.storageConfig = x.storageConfig
            this.tags = x.tags
            this.upgradePolicy = x.upgradePolicy
            this.version = x.version
            this.zonalShiftConfig = x.zonalShiftConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.Cluster = Cluster(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.AccessConfigResponse] inside the given [block]
         */
        public fun accessConfig(block: aws.sdk.kotlin.services.eks.model.AccessConfigResponse.Builder.() -> kotlin.Unit) {
            this.accessConfig = aws.sdk.kotlin.services.eks.model.AccessConfigResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.Certificate] inside the given [block]
         */
        public fun certificateAuthority(block: aws.sdk.kotlin.services.eks.model.Certificate.Builder.() -> kotlin.Unit) {
            this.certificateAuthority = aws.sdk.kotlin.services.eks.model.Certificate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.ComputeConfigResponse] inside the given [block]
         */
        public fun computeConfig(block: aws.sdk.kotlin.services.eks.model.ComputeConfigResponse.Builder.() -> kotlin.Unit) {
            this.computeConfig = aws.sdk.kotlin.services.eks.model.ComputeConfigResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.ConnectorConfigResponse] inside the given [block]
         */
        public fun connectorConfig(block: aws.sdk.kotlin.services.eks.model.ConnectorConfigResponse.Builder.() -> kotlin.Unit) {
            this.connectorConfig = aws.sdk.kotlin.services.eks.model.ConnectorConfigResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.ClusterHealth] inside the given [block]
         */
        public fun health(block: aws.sdk.kotlin.services.eks.model.ClusterHealth.Builder.() -> kotlin.Unit) {
            this.health = aws.sdk.kotlin.services.eks.model.ClusterHealth.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.Identity] inside the given [block]
         */
        public fun identity(block: aws.sdk.kotlin.services.eks.model.Identity.Builder.() -> kotlin.Unit) {
            this.identity = aws.sdk.kotlin.services.eks.model.Identity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigResponse] inside the given [block]
         */
        public fun kubernetesNetworkConfig(block: aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigResponse.Builder.() -> kotlin.Unit) {
            this.kubernetesNetworkConfig = aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.Logging] inside the given [block]
         */
        public fun logging(block: aws.sdk.kotlin.services.eks.model.Logging.Builder.() -> kotlin.Unit) {
            this.logging = aws.sdk.kotlin.services.eks.model.Logging.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.OutpostConfigResponse] inside the given [block]
         */
        public fun outpostConfig(block: aws.sdk.kotlin.services.eks.model.OutpostConfigResponse.Builder.() -> kotlin.Unit) {
            this.outpostConfig = aws.sdk.kotlin.services.eks.model.OutpostConfigResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.RemoteNetworkConfigResponse] inside the given [block]
         */
        public fun remoteNetworkConfig(block: aws.sdk.kotlin.services.eks.model.RemoteNetworkConfigResponse.Builder.() -> kotlin.Unit) {
            this.remoteNetworkConfig = aws.sdk.kotlin.services.eks.model.RemoteNetworkConfigResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.VpcConfigResponse] inside the given [block]
         */
        public fun resourcesVpcConfig(block: aws.sdk.kotlin.services.eks.model.VpcConfigResponse.Builder.() -> kotlin.Unit) {
            this.resourcesVpcConfig = aws.sdk.kotlin.services.eks.model.VpcConfigResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.StorageConfigResponse] inside the given [block]
         */
        public fun storageConfig(block: aws.sdk.kotlin.services.eks.model.StorageConfigResponse.Builder.() -> kotlin.Unit) {
            this.storageConfig = aws.sdk.kotlin.services.eks.model.StorageConfigResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.UpgradePolicyResponse] inside the given [block]
         */
        public fun upgradePolicy(block: aws.sdk.kotlin.services.eks.model.UpgradePolicyResponse.Builder.() -> kotlin.Unit) {
            this.upgradePolicy = aws.sdk.kotlin.services.eks.model.UpgradePolicyResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.ZonalShiftConfigResponse] inside the given [block]
         */
        public fun zonalShiftConfig(block: aws.sdk.kotlin.services.eks.model.ZonalShiftConfigResponse.Builder.() -> kotlin.Unit) {
            this.zonalShiftConfig = aws.sdk.kotlin.services.eks.model.ZonalShiftConfigResponse.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
