// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.eks.auth.DefaultEksAuthSchemeProvider
import aws.sdk.kotlin.services.eks.auth.EksAuthSchemeProvider
import aws.sdk.kotlin.services.eks.endpoints.DefaultEksEndpointProvider
import aws.sdk.kotlin.services.eks.endpoints.EksEndpointParameters
import aws.sdk.kotlin.services.eks.endpoints.EksEndpointProvider
import aws.sdk.kotlin.services.eks.model.AssociateAccessPolicyRequest
import aws.sdk.kotlin.services.eks.model.AssociateAccessPolicyResponse
import aws.sdk.kotlin.services.eks.model.AssociateEncryptionConfigRequest
import aws.sdk.kotlin.services.eks.model.AssociateEncryptionConfigResponse
import aws.sdk.kotlin.services.eks.model.AssociateIdentityProviderConfigRequest
import aws.sdk.kotlin.services.eks.model.AssociateIdentityProviderConfigResponse
import aws.sdk.kotlin.services.eks.model.CreateAccessEntryRequest
import aws.sdk.kotlin.services.eks.model.CreateAccessEntryResponse
import aws.sdk.kotlin.services.eks.model.CreateAddonRequest
import aws.sdk.kotlin.services.eks.model.CreateAddonResponse
import aws.sdk.kotlin.services.eks.model.CreateClusterRequest
import aws.sdk.kotlin.services.eks.model.CreateClusterResponse
import aws.sdk.kotlin.services.eks.model.CreateEksAnywhereSubscriptionRequest
import aws.sdk.kotlin.services.eks.model.CreateEksAnywhereSubscriptionResponse
import aws.sdk.kotlin.services.eks.model.CreateFargateProfileRequest
import aws.sdk.kotlin.services.eks.model.CreateFargateProfileResponse
import aws.sdk.kotlin.services.eks.model.CreateNodegroupRequest
import aws.sdk.kotlin.services.eks.model.CreateNodegroupResponse
import aws.sdk.kotlin.services.eks.model.CreatePodIdentityAssociationRequest
import aws.sdk.kotlin.services.eks.model.CreatePodIdentityAssociationResponse
import aws.sdk.kotlin.services.eks.model.DeleteAccessEntryRequest
import aws.sdk.kotlin.services.eks.model.DeleteAccessEntryResponse
import aws.sdk.kotlin.services.eks.model.DeleteAddonRequest
import aws.sdk.kotlin.services.eks.model.DeleteAddonResponse
import aws.sdk.kotlin.services.eks.model.DeleteClusterRequest
import aws.sdk.kotlin.services.eks.model.DeleteClusterResponse
import aws.sdk.kotlin.services.eks.model.DeleteEksAnywhereSubscriptionRequest
import aws.sdk.kotlin.services.eks.model.DeleteEksAnywhereSubscriptionResponse
import aws.sdk.kotlin.services.eks.model.DeleteFargateProfileRequest
import aws.sdk.kotlin.services.eks.model.DeleteFargateProfileResponse
import aws.sdk.kotlin.services.eks.model.DeleteNodegroupRequest
import aws.sdk.kotlin.services.eks.model.DeleteNodegroupResponse
import aws.sdk.kotlin.services.eks.model.DeletePodIdentityAssociationRequest
import aws.sdk.kotlin.services.eks.model.DeletePodIdentityAssociationResponse
import aws.sdk.kotlin.services.eks.model.DeregisterClusterRequest
import aws.sdk.kotlin.services.eks.model.DeregisterClusterResponse
import aws.sdk.kotlin.services.eks.model.DescribeAccessEntryRequest
import aws.sdk.kotlin.services.eks.model.DescribeAccessEntryResponse
import aws.sdk.kotlin.services.eks.model.DescribeAddonConfigurationRequest
import aws.sdk.kotlin.services.eks.model.DescribeAddonConfigurationResponse
import aws.sdk.kotlin.services.eks.model.DescribeAddonRequest
import aws.sdk.kotlin.services.eks.model.DescribeAddonResponse
import aws.sdk.kotlin.services.eks.model.DescribeAddonVersionsRequest
import aws.sdk.kotlin.services.eks.model.DescribeAddonVersionsResponse
import aws.sdk.kotlin.services.eks.model.DescribeClusterRequest
import aws.sdk.kotlin.services.eks.model.DescribeClusterResponse
import aws.sdk.kotlin.services.eks.model.DescribeClusterVersionsRequest
import aws.sdk.kotlin.services.eks.model.DescribeClusterVersionsResponse
import aws.sdk.kotlin.services.eks.model.DescribeEksAnywhereSubscriptionRequest
import aws.sdk.kotlin.services.eks.model.DescribeEksAnywhereSubscriptionResponse
import aws.sdk.kotlin.services.eks.model.DescribeFargateProfileRequest
import aws.sdk.kotlin.services.eks.model.DescribeFargateProfileResponse
import aws.sdk.kotlin.services.eks.model.DescribeIdentityProviderConfigRequest
import aws.sdk.kotlin.services.eks.model.DescribeIdentityProviderConfigResponse
import aws.sdk.kotlin.services.eks.model.DescribeInsightRequest
import aws.sdk.kotlin.services.eks.model.DescribeInsightResponse
import aws.sdk.kotlin.services.eks.model.DescribeInsightsRefreshRequest
import aws.sdk.kotlin.services.eks.model.DescribeInsightsRefreshResponse
import aws.sdk.kotlin.services.eks.model.DescribeNodegroupRequest
import aws.sdk.kotlin.services.eks.model.DescribeNodegroupResponse
import aws.sdk.kotlin.services.eks.model.DescribePodIdentityAssociationRequest
import aws.sdk.kotlin.services.eks.model.DescribePodIdentityAssociationResponse
import aws.sdk.kotlin.services.eks.model.DescribeUpdateRequest
import aws.sdk.kotlin.services.eks.model.DescribeUpdateResponse
import aws.sdk.kotlin.services.eks.model.DisassociateAccessPolicyRequest
import aws.sdk.kotlin.services.eks.model.DisassociateAccessPolicyResponse
import aws.sdk.kotlin.services.eks.model.DisassociateIdentityProviderConfigRequest
import aws.sdk.kotlin.services.eks.model.DisassociateIdentityProviderConfigResponse
import aws.sdk.kotlin.services.eks.model.ListAccessEntriesRequest
import aws.sdk.kotlin.services.eks.model.ListAccessEntriesResponse
import aws.sdk.kotlin.services.eks.model.ListAccessPoliciesRequest
import aws.sdk.kotlin.services.eks.model.ListAccessPoliciesResponse
import aws.sdk.kotlin.services.eks.model.ListAddonsRequest
import aws.sdk.kotlin.services.eks.model.ListAddonsResponse
import aws.sdk.kotlin.services.eks.model.ListAssociatedAccessPoliciesRequest
import aws.sdk.kotlin.services.eks.model.ListAssociatedAccessPoliciesResponse
import aws.sdk.kotlin.services.eks.model.ListClustersRequest
import aws.sdk.kotlin.services.eks.model.ListClustersResponse
import aws.sdk.kotlin.services.eks.model.ListEksAnywhereSubscriptionsRequest
import aws.sdk.kotlin.services.eks.model.ListEksAnywhereSubscriptionsResponse
import aws.sdk.kotlin.services.eks.model.ListFargateProfilesRequest
import aws.sdk.kotlin.services.eks.model.ListFargateProfilesResponse
import aws.sdk.kotlin.services.eks.model.ListIdentityProviderConfigsRequest
import aws.sdk.kotlin.services.eks.model.ListIdentityProviderConfigsResponse
import aws.sdk.kotlin.services.eks.model.ListInsightsRequest
import aws.sdk.kotlin.services.eks.model.ListInsightsResponse
import aws.sdk.kotlin.services.eks.model.ListNodegroupsRequest
import aws.sdk.kotlin.services.eks.model.ListNodegroupsResponse
import aws.sdk.kotlin.services.eks.model.ListPodIdentityAssociationsRequest
import aws.sdk.kotlin.services.eks.model.ListPodIdentityAssociationsResponse
import aws.sdk.kotlin.services.eks.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.eks.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.eks.model.ListUpdatesRequest
import aws.sdk.kotlin.services.eks.model.ListUpdatesResponse
import aws.sdk.kotlin.services.eks.model.RegisterClusterRequest
import aws.sdk.kotlin.services.eks.model.RegisterClusterResponse
import aws.sdk.kotlin.services.eks.model.StartInsightsRefreshRequest
import aws.sdk.kotlin.services.eks.model.StartInsightsRefreshResponse
import aws.sdk.kotlin.services.eks.model.TagResourceRequest
import aws.sdk.kotlin.services.eks.model.TagResourceResponse
import aws.sdk.kotlin.services.eks.model.UntagResourceRequest
import aws.sdk.kotlin.services.eks.model.UntagResourceResponse
import aws.sdk.kotlin.services.eks.model.UpdateAccessEntryRequest
import aws.sdk.kotlin.services.eks.model.UpdateAccessEntryResponse
import aws.sdk.kotlin.services.eks.model.UpdateAddonRequest
import aws.sdk.kotlin.services.eks.model.UpdateAddonResponse
import aws.sdk.kotlin.services.eks.model.UpdateClusterConfigRequest
import aws.sdk.kotlin.services.eks.model.UpdateClusterConfigResponse
import aws.sdk.kotlin.services.eks.model.UpdateClusterVersionRequest
import aws.sdk.kotlin.services.eks.model.UpdateClusterVersionResponse
import aws.sdk.kotlin.services.eks.model.UpdateEksAnywhereSubscriptionRequest
import aws.sdk.kotlin.services.eks.model.UpdateEksAnywhereSubscriptionResponse
import aws.sdk.kotlin.services.eks.model.UpdateNodegroupConfigRequest
import aws.sdk.kotlin.services.eks.model.UpdateNodegroupConfigResponse
import aws.sdk.kotlin.services.eks.model.UpdateNodegroupVersionRequest
import aws.sdk.kotlin.services.eks.model.UpdateNodegroupVersionResponse
import aws.sdk.kotlin.services.eks.model.UpdatePodIdentityAssociationRequest
import aws.sdk.kotlin.services.eks.model.UpdatePodIdentityAssociationResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "EKS"
public const val SdkVersion: String = "1.5.36"
public const val ServiceApiVersion: String = "2017-11-01"

/**
 * Amazon Elastic Kubernetes Service (Amazon EKS) is a managed service that makes it easy for you to run Kubernetes on Amazon Web Services without needing to setup or maintain your own Kubernetes control plane. Kubernetes is an open-source system for automating the deployment, scaling, and management of containerized applications.
 *
 * Amazon EKS runs up-to-date versions of the open-source Kubernetes software, so you can use all the existing plugins and tooling from the Kubernetes community. Applications running on Amazon EKS are fully compatible with applications running on any standard Kubernetes environment, whether running in on-premises data centers or public clouds. This means that you can easily migrate any standard Kubernetes application to Amazon EKS without any code modification required.
 */
public interface EksClient : SdkClient {
    /**
     * EksClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, EksClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Eks",
                "EKS",
                "eks",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, EksClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): EksClient = DefaultEksClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EksEndpointProvider = builder.endpointProvider ?: DefaultEksEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: EksAuthSchemeProvider = builder.authSchemeProvider ?: DefaultEksAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "EKS"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EksEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: EksAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates an access policy and its scope to an access entry. For more information about associating access policies, see [Associating and disassociating access policies to and from access entries](https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html) in the *Amazon EKS User Guide*.
     */
    public suspend fun associateAccessPolicy(input: AssociateAccessPolicyRequest): AssociateAccessPolicyResponse

    /**
     * Associates an encryption configuration to an existing cluster.
     *
     * Use this API to enable encryption on existing clusters that don't already have encryption enabled. This allows you to implement a defense-in-depth security strategy without migrating applications to new Amazon EKS clusters.
     */
    public suspend fun associateEncryptionConfig(input: AssociateEncryptionConfigRequest): AssociateEncryptionConfigResponse

    /**
     * Associates an identity provider configuration to a cluster.
     *
     * If you want to authenticate identities using an identity provider, you can create an identity provider configuration and associate it to your cluster. After configuring authentication to your cluster you can create Kubernetes `Role` and `ClusterRole` objects, assign permissions to them, and then bind them to the identities using Kubernetes `RoleBinding` and `ClusterRoleBinding` objects. For more information see [Using RBAC Authorization](https://kubernetes.io/docs/reference/access-authn-authz/rbac/) in the Kubernetes documentation.
     */
    public suspend fun associateIdentityProviderConfig(input: AssociateIdentityProviderConfigRequest): AssociateIdentityProviderConfigResponse

    /**
     * Creates an access entry.
     *
     * An access entry allows an IAM principal to access your cluster. Access entries can replace the need to maintain entries in the `aws-auth``ConfigMap` for authentication. You have the following options for authorizing an IAM principal to access Kubernetes objects on your cluster: Kubernetes role-based access control (RBAC), Amazon EKS, or both. Kubernetes RBAC authorization requires you to create and manage Kubernetes `Role`, `ClusterRole`, `RoleBinding`, and `ClusterRoleBinding` objects, in addition to managing access entries. If you use Amazon EKS authorization exclusively, you don't need to create and manage Kubernetes `Role`, `ClusterRole`, `RoleBinding`, and `ClusterRoleBinding` objects.
     *
     * For more information about access entries, see [Access entries](https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html) in the *Amazon EKS User Guide*.
     */
    public suspend fun createAccessEntry(input: CreateAccessEntryRequest): CreateAccessEntryResponse

    /**
     * Creates an Amazon EKS add-on.
     *
     * Amazon EKS add-ons help to automate the provisioning and lifecycle management of common operational software for Amazon EKS clusters. For more information, see [Amazon EKS add-ons](https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html) in the *Amazon EKS User Guide*.
     */
    public suspend fun createAddon(input: CreateAddonRequest): CreateAddonResponse

    /**
     * Creates an Amazon EKS control plane.
     *
     * The Amazon EKS control plane consists of control plane instances that run the Kubernetes software, such as `etcd` and the API server. The control plane runs in an account managed by Amazon Web Services, and the Kubernetes API is exposed by the Amazon EKS API server endpoint. Each Amazon EKS cluster control plane is single tenant and unique. It runs on its own set of Amazon EC2 instances.
     *
     * The cluster control plane is provisioned across multiple Availability Zones and fronted by an Elastic Load Balancing Network Load Balancer. Amazon EKS also provisions elastic network interfaces in your VPC subnets to provide connectivity from the control plane instances to the nodes (for example, to support `kubectl exec`, `logs`, and `proxy` data flows).
     *
     * Amazon EKS nodes run in your Amazon Web Services account and connect to your cluster's control plane over the Kubernetes API server endpoint and a certificate file that is created for your cluster.
     *
     * You can use the `endpointPublicAccess` and `endpointPrivateAccess` parameters to enable or disable public and private access to your cluster's Kubernetes API server endpoint. By default, public access is enabled, and private access is disabled. The endpoint domain name and IP address family depends on the value of the `ipFamily` for the cluster. For more information, see [Amazon EKS Cluster Endpoint Access Control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
     *
     * You can use the `logging` parameter to enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see [Amazon EKS Cluster Control Plane Logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html) in the **Amazon EKS User Guide**.
     *
     * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see [CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
     *
     * In most cases, it takes several minutes to create a cluster. After you create an Amazon EKS cluster, you must configure your Kubernetes tooling to communicate with the API server and launch nodes into your cluster. For more information, see [Allowing users to access your cluster](https://docs.aws.amazon.com/eks/latest/userguide/cluster-auth.html) and [Launching Amazon EKS nodes](https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html) in the *Amazon EKS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.eks.samples.CreateCluster.sample
     */
    public suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse

    /**
     * Creates an EKS Anywhere subscription. When a subscription is created, it is a contract agreement for the length of the term specified in the request. Licenses that are used to validate support are provisioned in Amazon Web Services License Manager and the caller account is granted access to EKS Anywhere Curated Packages.
     */
    public suspend fun createEksAnywhereSubscription(input: CreateEksAnywhereSubscriptionRequest): CreateEksAnywhereSubscriptionResponse

    /**
     * Creates an Fargate profile for your Amazon EKS cluster. You must have at least one Fargate profile in a cluster to be able to run pods on Fargate.
     *
     * The Fargate profile allows an administrator to declare which pods run on Fargate and specify which pods run on which Fargate profile. This declaration is done through the profile's selectors. Each profile can have up to five selectors that contain a namespace and labels. A namespace is required for every selector. The label field consists of multiple optional key-value pairs. Pods that match the selectors are scheduled on Fargate. If a to-be-scheduled pod matches any of the selectors in the Fargate profile, then that pod is run on Fargate.
     *
     * When you create a Fargate profile, you must specify a pod execution role to use with the pods that are scheduled with the profile. This role is added to the cluster's Kubernetes [Role Based Access Control](https://kubernetes.io/docs/reference/access-authn-authz/rbac/) (RBAC) for authorization so that the `kubelet` that is running on the Fargate infrastructure can register with your Amazon EKS cluster so that it can appear in your cluster as a node. The pod execution role also provides IAM permissions to the Fargate infrastructure to allow read access to Amazon ECR image repositories. For more information, see [Pod Execution Role](https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html) in the *Amazon EKS User Guide*.
     *
     * Fargate profiles are immutable. However, you can create a new updated profile to replace an existing profile and then delete the original after the updated profile has finished creating.
     *
     * If any Fargate profiles in a cluster are in the `DELETING` status, you must wait for that Fargate profile to finish deleting before you can create any other profiles in that cluster.
     *
     * For more information, see [Fargate profile](https://docs.aws.amazon.com/eks/latest/userguide/fargate-profile.html) in the *Amazon EKS User Guide*.
     */
    public suspend fun createFargateProfile(input: CreateFargateProfileRequest): CreateFargateProfileResponse

    /**
     * Creates a managed node group for an Amazon EKS cluster.
     *
     * You can only create a node group for your cluster that is equal to the current Kubernetes version for the cluster. All node groups are created with the latest AMI release version for the respective minor Kubernetes version of the cluster, unless you deploy a custom AMI using a launch template.
     *
     * For later updates, you will only be able to update a node group using a launch template only if it was originally deployed with a launch template. Additionally, the launch template ID or name must match what was used when the node group was created. You can update the launch template version with necessary changes. For more information about using launch templates, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html).
     *
     * An Amazon EKS managed node group is an Amazon EC2 Auto Scaling group and associated Amazon EC2 instances that are managed by Amazon Web Services for an Amazon EKS cluster. For more information, see [Managed node groups](https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html) in the *Amazon EKS User Guide*.
     *
     * Windows AMI types are only supported for commercial Amazon Web Services Regions that support Windows on Amazon EKS.
     */
    public suspend fun createNodegroup(input: CreateNodegroupRequest): CreateNodegroupResponse

    /**
     * Creates an EKS Pod Identity association between a service account in an Amazon EKS cluster and an IAM role with *EKS Pod Identity*. Use EKS Pod Identity to give temporary IAM credentials to Pods and the credentials are rotated automatically.
     *
     * Amazon EKS Pod Identity associations provide the ability to manage credentials for your applications, similar to the way that Amazon EC2 instance profiles provide credentials to Amazon EC2 instances.
     *
     * If a Pod uses a service account that has an association, Amazon EKS sets environment variables in the containers of the Pod. The environment variables configure the Amazon Web Services SDKs, including the Command Line Interface, to use the EKS Pod Identity credentials.
     *
     * EKS Pod Identity is a simpler method than *IAM roles for service accounts*, as this method doesn't use OIDC identity providers. Additionally, you can configure a role for EKS Pod Identity once, and reuse it across clusters.
     *
     * Similar to Amazon Web Services IAM behavior, EKS Pod Identity associations are eventually consistent, and may take several seconds to be effective after the initial API call returns successfully. You must design your applications to account for these potential delays. We recommend that you don’t include association create/updates in the critical, high-availability code paths of your application. Instead, make changes in a separate initialization or setup routine that you run less frequently.
     *
     * You can set a *target IAM role* in the same or a different account for advanced scenarios. With a target role, EKS Pod Identity automatically performs two role assumptions in sequence: first assuming the role in the association that is in this account, then using those credentials to assume the target IAM role. This process provides your Pod with temporary credentials that have the permissions defined in the target role, allowing secure access to resources in another Amazon Web Services account.
     */
    public suspend fun createPodIdentityAssociation(input: CreatePodIdentityAssociationRequest): CreatePodIdentityAssociationResponse

    /**
     * Deletes an access entry.
     *
     * Deleting an access entry of a type other than `Standard` can cause your cluster to function improperly. If you delete an access entry in error, you can recreate it.
     */
    public suspend fun deleteAccessEntry(input: DeleteAccessEntryRequest): DeleteAccessEntryResponse

    /**
     * Deletes an Amazon EKS add-on.
     *
     * When you remove an add-on, it's deleted from the cluster. You can always manually start an add-on on the cluster using the Kubernetes API.
     */
    public suspend fun deleteAddon(input: DeleteAddonRequest): DeleteAddonResponse

    /**
     * Deletes an Amazon EKS cluster control plane.
     *
     * If you have active services in your cluster that are associated with a load balancer, you must delete those services before deleting the cluster so that the load balancers are deleted properly. Otherwise, you can have orphaned resources in your VPC that prevent you from being able to delete the VPC. For more information, see [Deleting a cluster](https://docs.aws.amazon.com/eks/latest/userguide/delete-cluster.html) in the *Amazon EKS User Guide*.
     *
     * If you have managed node groups or Fargate profiles attached to the cluster, you must delete them first. For more information, see `DeleteNodgroup` and `DeleteFargateProfile`.
     *
     * @sample aws.sdk.kotlin.services.eks.samples.DeleteCluster.sample
     */
    public suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse

    /**
     * Deletes an expired or inactive subscription. Deleting inactive subscriptions removes them from the Amazon Web Services Management Console view and from list/describe API responses. Subscriptions can only be cancelled within 7 days of creation and are cancelled by creating a ticket in the Amazon Web Services Support Center.
     */
    public suspend fun deleteEksAnywhereSubscription(input: DeleteEksAnywhereSubscriptionRequest): DeleteEksAnywhereSubscriptionResponse

    /**
     * Deletes an Fargate profile.
     *
     * When you delete a Fargate profile, any `Pod` running on Fargate that was created with the profile is deleted. If the `Pod` matches another Fargate profile, then it is scheduled on Fargate with that profile. If it no longer matches any Fargate profiles, then it's not scheduled on Fargate and may remain in a pending state.
     *
     * Only one Fargate profile in a cluster can be in the `DELETING` status at a time. You must wait for a Fargate profile to finish deleting before you can delete any other profiles in that cluster.
     */
    public suspend fun deleteFargateProfile(input: DeleteFargateProfileRequest): DeleteFargateProfileResponse

    /**
     * Deletes a managed node group.
     */
    public suspend fun deleteNodegroup(input: DeleteNodegroupRequest): DeleteNodegroupResponse

    /**
     * Deletes a EKS Pod Identity association.
     *
     * The temporary Amazon Web Services credentials from the previous IAM role session might still be valid until the session expiry. If you need to immediately revoke the temporary session credentials, then go to the role in the IAM console.
     */
    public suspend fun deletePodIdentityAssociation(input: DeletePodIdentityAssociationRequest): DeletePodIdentityAssociationResponse

    /**
     * Deregisters a connected cluster to remove it from the Amazon EKS control plane.
     *
     * A connected cluster is a Kubernetes cluster that you've connected to your control plane using the [Amazon EKS Connector](https://docs.aws.amazon.com/eks/latest/userguide/eks-connector.html).
     */
    public suspend fun deregisterCluster(input: DeregisterClusterRequest): DeregisterClusterResponse

    /**
     * Describes an access entry.
     */
    public suspend fun describeAccessEntry(input: DescribeAccessEntryRequest): DescribeAccessEntryResponse

    /**
     * Describes an Amazon EKS add-on.
     */
    public suspend fun describeAddon(input: DescribeAddonRequest): DescribeAddonResponse

    /**
     * Returns configuration options.
     */
    public suspend fun describeAddonConfiguration(input: DescribeAddonConfigurationRequest): DescribeAddonConfigurationResponse

    /**
     * Describes the versions for an add-on.
     *
     * Information such as the Kubernetes versions that you can use the add-on with, the `owner`, `publisher`, and the `type` of the add-on are returned.
     */
    public suspend fun describeAddonVersions(input: DescribeAddonVersionsRequest = DescribeAddonVersionsRequest { }): DescribeAddonVersionsResponse

    /**
     * Describes an Amazon EKS cluster.
     *
     * The API server endpoint and certificate authority data returned by this operation are required for `kubelet` and `kubectl` to communicate with your Kubernetes API server. For more information, see `kubeconfig`[ file for an Amazon EKS cluster](https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html).
     *
     * The API server endpoint and certificate authority data aren't available until the cluster reaches the `ACTIVE` state.
     *
     * @sample aws.sdk.kotlin.services.eks.samples.DescribeCluster.sample
     */
    public suspend fun describeCluster(input: DescribeClusterRequest): DescribeClusterResponse

    /**
     * Lists available Kubernetes versions for Amazon EKS clusters.
     */
    public suspend fun describeClusterVersions(input: DescribeClusterVersionsRequest = DescribeClusterVersionsRequest { }): DescribeClusterVersionsResponse

    /**
     * Returns descriptive information about a subscription.
     */
    public suspend fun describeEksAnywhereSubscription(input: DescribeEksAnywhereSubscriptionRequest): DescribeEksAnywhereSubscriptionResponse

    /**
     * Describes an Fargate profile.
     */
    public suspend fun describeFargateProfile(input: DescribeFargateProfileRequest): DescribeFargateProfileResponse

    /**
     * Describes an identity provider configuration.
     */
    public suspend fun describeIdentityProviderConfig(input: DescribeIdentityProviderConfigRequest): DescribeIdentityProviderConfigResponse

    /**
     * Returns details about an insight that you specify using its ID.
     */
    public suspend fun describeInsight(input: DescribeInsightRequest): DescribeInsightResponse

    /**
     * Returns the status of the latest on-demand cluster insights refresh operation.
     */
    public suspend fun describeInsightsRefresh(input: DescribeInsightsRefreshRequest): DescribeInsightsRefreshResponse

    /**
     * Describes a managed node group.
     */
    public suspend fun describeNodegroup(input: DescribeNodegroupRequest): DescribeNodegroupResponse

    /**
     * Returns descriptive information about an EKS Pod Identity association.
     *
     * This action requires the ID of the association. You can get the ID from the response to the `CreatePodIdentityAssocation` for newly created associations. Or, you can list the IDs for associations with `ListPodIdentityAssociations` and filter the list by namespace or service account.
     */
    public suspend fun describePodIdentityAssociation(input: DescribePodIdentityAssociationRequest): DescribePodIdentityAssociationResponse

    /**
     * Describes an update to an Amazon EKS resource.
     *
     * When the status of the update is `Successful`, the update is complete. If an update fails, the status is `Failed`, and an error detail explains the reason for the failure.
     */
    public suspend fun describeUpdate(input: DescribeUpdateRequest): DescribeUpdateResponse

    /**
     * Disassociates an access policy from an access entry.
     */
    public suspend fun disassociateAccessPolicy(input: DisassociateAccessPolicyRequest): DisassociateAccessPolicyResponse

    /**
     * Disassociates an identity provider configuration from a cluster.
     *
     * If you disassociate an identity provider from your cluster, users included in the provider can no longer access the cluster. However, you can still access the cluster with IAM principals.
     */
    public suspend fun disassociateIdentityProviderConfig(input: DisassociateIdentityProviderConfigRequest): DisassociateIdentityProviderConfigResponse

    /**
     * Lists the access entries for your cluster.
     */
    public suspend fun listAccessEntries(input: ListAccessEntriesRequest): ListAccessEntriesResponse

    /**
     * Lists the available access policies.
     */
    public suspend fun listAccessPolicies(input: ListAccessPoliciesRequest = ListAccessPoliciesRequest { }): ListAccessPoliciesResponse

    /**
     * Lists the installed add-ons.
     */
    public suspend fun listAddons(input: ListAddonsRequest): ListAddonsResponse

    /**
     * Lists the access policies associated with an access entry.
     */
    public suspend fun listAssociatedAccessPolicies(input: ListAssociatedAccessPoliciesRequest): ListAssociatedAccessPoliciesResponse

    /**
     * Lists the Amazon EKS clusters in your Amazon Web Services account in the specified Amazon Web Services Region.
     *
     * @sample aws.sdk.kotlin.services.eks.samples.ListClusters.sample
     */
    public suspend fun listClusters(input: ListClustersRequest = ListClustersRequest { }): ListClustersResponse

    /**
     * Displays the full description of the subscription.
     */
    public suspend fun listEksAnywhereSubscriptions(input: ListEksAnywhereSubscriptionsRequest = ListEksAnywhereSubscriptionsRequest { }): ListEksAnywhereSubscriptionsResponse

    /**
     * Lists the Fargate profiles associated with the specified cluster in your Amazon Web Services account in the specified Amazon Web Services Region.
     */
    public suspend fun listFargateProfiles(input: ListFargateProfilesRequest): ListFargateProfilesResponse

    /**
     * Lists the identity provider configurations for your cluster.
     */
    public suspend fun listIdentityProviderConfigs(input: ListIdentityProviderConfigsRequest): ListIdentityProviderConfigsResponse

    /**
     * Returns a list of all insights checked for against the specified cluster. You can filter which insights are returned by category, associated Kubernetes version, and status. The default filter lists all categories and every status.
     *
     * The following lists the available categories:
     * + `UPGRADE_READINESS`: Amazon EKS identifies issues that could impact your ability to upgrade to new versions of Kubernetes. These are called upgrade insights.
     * + `MISCONFIGURATION`: Amazon EKS identifies misconfiguration in your EKS Hybrid Nodes setup that could impair functionality of your cluster or workloads. These are called configuration insights.
     */
    public suspend fun listInsights(input: ListInsightsRequest): ListInsightsResponse

    /**
     * Lists the managed node groups associated with the specified cluster in your Amazon Web Services account in the specified Amazon Web Services Region. Self-managed node groups aren't listed.
     */
    public suspend fun listNodegroups(input: ListNodegroupsRequest): ListNodegroupsResponse

    /**
     * List the EKS Pod Identity associations in a cluster. You can filter the list by the namespace that the association is in or the service account that the association uses.
     */
    public suspend fun listPodIdentityAssociations(input: ListPodIdentityAssociationsRequest): ListPodIdentityAssociationsResponse

    /**
     * List the tags for an Amazon EKS resource.
     *
     * @sample aws.sdk.kotlin.services.eks.samples.ListTagsForResource.sample
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the updates associated with an Amazon EKS resource in your Amazon Web Services account, in the specified Amazon Web Services Region.
     */
    public suspend fun listUpdates(input: ListUpdatesRequest): ListUpdatesResponse

    /**
     * Connects a Kubernetes cluster to the Amazon EKS control plane.
     *
     * Any Kubernetes cluster can be connected to the Amazon EKS control plane to view current information about the cluster and its nodes.
     *
     * Cluster connection requires two steps. First, send a `RegisterClusterRequest`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_RegisterClusterRequest.html) to add it to the Amazon EKS control plane.
     *
     * Second, a [Manifest](https://amazon-eks.s3.us-west-2.amazonaws.com/eks-connector/manifests/eks-connector/latest/eks-connector.yaml) containing the `activationID` and `activationCode` must be applied to the Kubernetes cluster through it's native provider to provide visibility.
     *
     * After the manifest is updated and applied, the connected cluster is visible to the Amazon EKS control plane. If the manifest isn't applied within three days, the connected cluster will no longer be visible and must be deregistered using `DeregisterCluster`.
     */
    public suspend fun registerCluster(input: RegisterClusterRequest): RegisterClusterResponse

    /**
     * Initiates an on-demand refresh operation for cluster insights, getting the latest analysis outside of the standard refresh schedule.
     */
    public suspend fun startInsightsRefresh(input: StartInsightsRefreshRequest): StartInsightsRefreshResponse

    /**
     * Associates the specified tags to an Amazon EKS resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they aren't changed. When a resource is deleted, the tags associated with that resource are also deleted. Tags that you create for Amazon EKS resources don't propagate to any other resources associated with the cluster. For example, if you tag a cluster with this operation, that tag doesn't automatically propagate to the subnets and nodes associated with the cluster.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes specified tags from an Amazon EKS resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an access entry.
     */
    public suspend fun updateAccessEntry(input: UpdateAccessEntryRequest): UpdateAccessEntryResponse

    /**
     * Updates an Amazon EKS add-on.
     */
    public suspend fun updateAddon(input: UpdateAddonRequest): UpdateAddonResponse

    /**
     * Updates an Amazon EKS cluster configuration. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with `DescribeUpdate`.
     *
     * You can use this operation to do the following actions:
     * + You can use this API operation to enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see [Amazon EKS Cluster control plane logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html) in the **Amazon EKS User Guide**.CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see [CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
     * + You can also use this API operation to enable or disable public and private access to your cluster's Kubernetes API server endpoint. By default, public access is enabled, and private access is disabled. For more information, see [ Cluster API server endpoint](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
     * + You can also use this API operation to choose different subnets and security groups for the cluster. You must specify at least two subnets that are in different Availability Zones. You can't change which VPC the subnets are from, the subnets must be in the same VPC as the subnets that the cluster was created with. For more information about the VPC requirements, see [https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) in the **Amazon EKS User Guide**.
     * + You can also use this API operation to enable or disable ARC zonal shift. If zonal shift is enabled, Amazon Web Services configures zonal autoshift for the cluster.
     * + You can also use this API operation to add, change, or remove the configuration in the cluster for EKS Hybrid Nodes. To remove the configuration, use the `remoteNetworkConfig` key with an object containing both subkeys with empty arrays for each. Here is an inline example: `"remoteNetworkConfig": { "remoteNodeNetworks": [], "remotePodNetworks": [] }`.
     *
     * Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster status moves to `UPDATING` (this status transition is eventually consistent). When the update is complete (either `Failed` or `Successful`), the cluster status moves to `Active`.
     */
    public suspend fun updateClusterConfig(input: UpdateClusterConfigRequest): UpdateClusterConfigResponse

    /**
     * Updates an Amazon EKS cluster to the specified Kubernetes version. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with the `DescribeUpdate`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeUpdate.html) API operation.
     *
     * Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster status moves to `UPDATING` (this status transition is eventually consistent). When the update is complete (either `Failed` or `Successful`), the cluster status moves to `Active`.
     *
     * If your cluster has managed node groups attached to it, all of your node groups' Kubernetes versions must match the cluster's Kubernetes version in order to update the cluster to a new Kubernetes version.
     */
    public suspend fun updateClusterVersion(input: UpdateClusterVersionRequest): UpdateClusterVersionResponse

    /**
     * Update an EKS Anywhere Subscription. Only auto renewal and tags can be updated after subscription creation.
     */
    public suspend fun updateEksAnywhereSubscription(input: UpdateEksAnywhereSubscriptionRequest): UpdateEksAnywhereSubscriptionResponse

    /**
     * Updates an Amazon EKS managed node group configuration. Your node group continues to function during the update. The response output includes an update ID that you can use to track the status of your node group update with the `DescribeUpdate`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeUpdate.html) API operation. You can update the Kubernetes labels and taints for a node group and the scaling and version update configuration.
     */
    public suspend fun updateNodegroupConfig(input: UpdateNodegroupConfigRequest): UpdateNodegroupConfigResponse

    /**
     * Updates the Kubernetes version or AMI version of an Amazon EKS managed node group.
     *
     * You can update a node group using a launch template only if the node group was originally deployed with a launch template. Additionally, the launch template ID or name must match what was used when the node group was created. You can update the launch template version with necessary changes.
     *
     * If you need to update a custom AMI in a node group that was deployed with a launch template, then update your custom AMI, specify the new ID in a new version of the launch template, and then update the node group to the new version of the launch template.
     *
     * If you update without a launch template, then you can update to the latest available AMI version of a node group's current Kubernetes version by not specifying a Kubernetes version in the request. You can update to the latest AMI version of your cluster's current Kubernetes version by specifying your cluster's Kubernetes version in the request. For information about Linux versions, see [Amazon EKS optimized Amazon Linux AMI versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html) in the *Amazon EKS User Guide*. For information about Windows versions, see [Amazon EKS optimized Windows AMI versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-ami-versions-windows.html) in the *Amazon EKS User Guide*.
     *
     * You cannot roll back a node group to an earlier Kubernetes version or AMI version.
     *
     * When a node in a managed node group is terminated due to a scaling action or update, every `Pod` on that node is drained first. Amazon EKS attempts to drain the nodes gracefully and will fail if it is unable to do so. You can `force` the update if Amazon EKS is unable to drain the nodes as a result of a `Pod` disruption budget issue.
     */
    public suspend fun updateNodegroupVersion(input: UpdateNodegroupVersionRequest): UpdateNodegroupVersionResponse

    /**
     * Updates a EKS Pod Identity association. In an update, you can change the IAM role, the target IAM role, or `disableSessionTags`. You must change at least one of these in an update. An association can't be moved between clusters, namespaces, or service accounts. If you need to edit the namespace or service account, you need to delete the association and then create a new association with your desired settings.
     *
     * Similar to Amazon Web Services IAM behavior, EKS Pod Identity associations are eventually consistent, and may take several seconds to be effective after the initial API call returns successfully. You must design your applications to account for these potential delays. We recommend that you don’t include association create/updates in the critical, high-availability code paths of your application. Instead, make changes in a separate initialization or setup routine that you run less frequently.
     *
     * You can set a *target IAM role* in the same or a different account for advanced scenarios. With a target role, EKS Pod Identity automatically performs two role assumptions in sequence: first assuming the role in the association that is in this account, then using those credentials to assume the target IAM role. This process provides your Pod with temporary credentials that have the permissions defined in the target role, allowing secure access to resources in another Amazon Web Services account.
     */
    public suspend fun updatePodIdentityAssociation(input: UpdatePodIdentityAssociationRequest): UpdatePodIdentityAssociationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun EksClient.withConfig(block: EksClient.Config.Builder.() -> Unit): EksClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultEksClient(newConfig)
}

/**
 * Associates an access policy and its scope to an access entry. For more information about associating access policies, see [Associating and disassociating access policies to and from access entries](https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html) in the *Amazon EKS User Guide*.
 */
public suspend inline fun EksClient.associateAccessPolicy(crossinline block: AssociateAccessPolicyRequest.Builder.() -> Unit): AssociateAccessPolicyResponse = associateAccessPolicy(AssociateAccessPolicyRequest.Builder().apply(block).build())

/**
 * Associates an encryption configuration to an existing cluster.
 *
 * Use this API to enable encryption on existing clusters that don't already have encryption enabled. This allows you to implement a defense-in-depth security strategy without migrating applications to new Amazon EKS clusters.
 */
public suspend inline fun EksClient.associateEncryptionConfig(crossinline block: AssociateEncryptionConfigRequest.Builder.() -> Unit): AssociateEncryptionConfigResponse = associateEncryptionConfig(AssociateEncryptionConfigRequest.Builder().apply(block).build())

/**
 * Associates an identity provider configuration to a cluster.
 *
 * If you want to authenticate identities using an identity provider, you can create an identity provider configuration and associate it to your cluster. After configuring authentication to your cluster you can create Kubernetes `Role` and `ClusterRole` objects, assign permissions to them, and then bind them to the identities using Kubernetes `RoleBinding` and `ClusterRoleBinding` objects. For more information see [Using RBAC Authorization](https://kubernetes.io/docs/reference/access-authn-authz/rbac/) in the Kubernetes documentation.
 */
public suspend inline fun EksClient.associateIdentityProviderConfig(crossinline block: AssociateIdentityProviderConfigRequest.Builder.() -> Unit): AssociateIdentityProviderConfigResponse = associateIdentityProviderConfig(AssociateIdentityProviderConfigRequest.Builder().apply(block).build())

/**
 * Creates an access entry.
 *
 * An access entry allows an IAM principal to access your cluster. Access entries can replace the need to maintain entries in the `aws-auth``ConfigMap` for authentication. You have the following options for authorizing an IAM principal to access Kubernetes objects on your cluster: Kubernetes role-based access control (RBAC), Amazon EKS, or both. Kubernetes RBAC authorization requires you to create and manage Kubernetes `Role`, `ClusterRole`, `RoleBinding`, and `ClusterRoleBinding` objects, in addition to managing access entries. If you use Amazon EKS authorization exclusively, you don't need to create and manage Kubernetes `Role`, `ClusterRole`, `RoleBinding`, and `ClusterRoleBinding` objects.
 *
 * For more information about access entries, see [Access entries](https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html) in the *Amazon EKS User Guide*.
 */
public suspend inline fun EksClient.createAccessEntry(crossinline block: CreateAccessEntryRequest.Builder.() -> Unit): CreateAccessEntryResponse = createAccessEntry(CreateAccessEntryRequest.Builder().apply(block).build())

/**
 * Creates an Amazon EKS add-on.
 *
 * Amazon EKS add-ons help to automate the provisioning and lifecycle management of common operational software for Amazon EKS clusters. For more information, see [Amazon EKS add-ons](https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html) in the *Amazon EKS User Guide*.
 */
public suspend inline fun EksClient.createAddon(crossinline block: CreateAddonRequest.Builder.() -> Unit): CreateAddonResponse = createAddon(CreateAddonRequest.Builder().apply(block).build())

/**
 * Creates an Amazon EKS control plane.
 *
 * The Amazon EKS control plane consists of control plane instances that run the Kubernetes software, such as `etcd` and the API server. The control plane runs in an account managed by Amazon Web Services, and the Kubernetes API is exposed by the Amazon EKS API server endpoint. Each Amazon EKS cluster control plane is single tenant and unique. It runs on its own set of Amazon EC2 instances.
 *
 * The cluster control plane is provisioned across multiple Availability Zones and fronted by an Elastic Load Balancing Network Load Balancer. Amazon EKS also provisions elastic network interfaces in your VPC subnets to provide connectivity from the control plane instances to the nodes (for example, to support `kubectl exec`, `logs`, and `proxy` data flows).
 *
 * Amazon EKS nodes run in your Amazon Web Services account and connect to your cluster's control plane over the Kubernetes API server endpoint and a certificate file that is created for your cluster.
 *
 * You can use the `endpointPublicAccess` and `endpointPrivateAccess` parameters to enable or disable public and private access to your cluster's Kubernetes API server endpoint. By default, public access is enabled, and private access is disabled. The endpoint domain name and IP address family depends on the value of the `ipFamily` for the cluster. For more information, see [Amazon EKS Cluster Endpoint Access Control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
 *
 * You can use the `logging` parameter to enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see [Amazon EKS Cluster Control Plane Logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html) in the **Amazon EKS User Guide**.
 *
 * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see [CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
 *
 * In most cases, it takes several minutes to create a cluster. After you create an Amazon EKS cluster, you must configure your Kubernetes tooling to communicate with the API server and launch nodes into your cluster. For more information, see [Allowing users to access your cluster](https://docs.aws.amazon.com/eks/latest/userguide/cluster-auth.html) and [Launching Amazon EKS nodes](https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html) in the *Amazon EKS User Guide*.
 *
 * @sample aws.sdk.kotlin.services.eks.samples.CreateCluster.sample
 */
public suspend inline fun EksClient.createCluster(crossinline block: CreateClusterRequest.Builder.() -> Unit): CreateClusterResponse = createCluster(CreateClusterRequest.Builder().apply(block).build())

/**
 * Creates an EKS Anywhere subscription. When a subscription is created, it is a contract agreement for the length of the term specified in the request. Licenses that are used to validate support are provisioned in Amazon Web Services License Manager and the caller account is granted access to EKS Anywhere Curated Packages.
 */
public suspend inline fun EksClient.createEksAnywhereSubscription(crossinline block: CreateEksAnywhereSubscriptionRequest.Builder.() -> Unit): CreateEksAnywhereSubscriptionResponse = createEksAnywhereSubscription(CreateEksAnywhereSubscriptionRequest.Builder().apply(block).build())

/**
 * Creates an Fargate profile for your Amazon EKS cluster. You must have at least one Fargate profile in a cluster to be able to run pods on Fargate.
 *
 * The Fargate profile allows an administrator to declare which pods run on Fargate and specify which pods run on which Fargate profile. This declaration is done through the profile's selectors. Each profile can have up to five selectors that contain a namespace and labels. A namespace is required for every selector. The label field consists of multiple optional key-value pairs. Pods that match the selectors are scheduled on Fargate. If a to-be-scheduled pod matches any of the selectors in the Fargate profile, then that pod is run on Fargate.
 *
 * When you create a Fargate profile, you must specify a pod execution role to use with the pods that are scheduled with the profile. This role is added to the cluster's Kubernetes [Role Based Access Control](https://kubernetes.io/docs/reference/access-authn-authz/rbac/) (RBAC) for authorization so that the `kubelet` that is running on the Fargate infrastructure can register with your Amazon EKS cluster so that it can appear in your cluster as a node. The pod execution role also provides IAM permissions to the Fargate infrastructure to allow read access to Amazon ECR image repositories. For more information, see [Pod Execution Role](https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html) in the *Amazon EKS User Guide*.
 *
 * Fargate profiles are immutable. However, you can create a new updated profile to replace an existing profile and then delete the original after the updated profile has finished creating.
 *
 * If any Fargate profiles in a cluster are in the `DELETING` status, you must wait for that Fargate profile to finish deleting before you can create any other profiles in that cluster.
 *
 * For more information, see [Fargate profile](https://docs.aws.amazon.com/eks/latest/userguide/fargate-profile.html) in the *Amazon EKS User Guide*.
 */
public suspend inline fun EksClient.createFargateProfile(crossinline block: CreateFargateProfileRequest.Builder.() -> Unit): CreateFargateProfileResponse = createFargateProfile(CreateFargateProfileRequest.Builder().apply(block).build())

/**
 * Creates a managed node group for an Amazon EKS cluster.
 *
 * You can only create a node group for your cluster that is equal to the current Kubernetes version for the cluster. All node groups are created with the latest AMI release version for the respective minor Kubernetes version of the cluster, unless you deploy a custom AMI using a launch template.
 *
 * For later updates, you will only be able to update a node group using a launch template only if it was originally deployed with a launch template. Additionally, the launch template ID or name must match what was used when the node group was created. You can update the launch template version with necessary changes. For more information about using launch templates, see [Customizing managed nodes with launch templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html).
 *
 * An Amazon EKS managed node group is an Amazon EC2 Auto Scaling group and associated Amazon EC2 instances that are managed by Amazon Web Services for an Amazon EKS cluster. For more information, see [Managed node groups](https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html) in the *Amazon EKS User Guide*.
 *
 * Windows AMI types are only supported for commercial Amazon Web Services Regions that support Windows on Amazon EKS.
 */
public suspend inline fun EksClient.createNodegroup(crossinline block: CreateNodegroupRequest.Builder.() -> Unit): CreateNodegroupResponse = createNodegroup(CreateNodegroupRequest.Builder().apply(block).build())

/**
 * Creates an EKS Pod Identity association between a service account in an Amazon EKS cluster and an IAM role with *EKS Pod Identity*. Use EKS Pod Identity to give temporary IAM credentials to Pods and the credentials are rotated automatically.
 *
 * Amazon EKS Pod Identity associations provide the ability to manage credentials for your applications, similar to the way that Amazon EC2 instance profiles provide credentials to Amazon EC2 instances.
 *
 * If a Pod uses a service account that has an association, Amazon EKS sets environment variables in the containers of the Pod. The environment variables configure the Amazon Web Services SDKs, including the Command Line Interface, to use the EKS Pod Identity credentials.
 *
 * EKS Pod Identity is a simpler method than *IAM roles for service accounts*, as this method doesn't use OIDC identity providers. Additionally, you can configure a role for EKS Pod Identity once, and reuse it across clusters.
 *
 * Similar to Amazon Web Services IAM behavior, EKS Pod Identity associations are eventually consistent, and may take several seconds to be effective after the initial API call returns successfully. You must design your applications to account for these potential delays. We recommend that you don’t include association create/updates in the critical, high-availability code paths of your application. Instead, make changes in a separate initialization or setup routine that you run less frequently.
 *
 * You can set a *target IAM role* in the same or a different account for advanced scenarios. With a target role, EKS Pod Identity automatically performs two role assumptions in sequence: first assuming the role in the association that is in this account, then using those credentials to assume the target IAM role. This process provides your Pod with temporary credentials that have the permissions defined in the target role, allowing secure access to resources in another Amazon Web Services account.
 */
public suspend inline fun EksClient.createPodIdentityAssociation(crossinline block: CreatePodIdentityAssociationRequest.Builder.() -> Unit): CreatePodIdentityAssociationResponse = createPodIdentityAssociation(CreatePodIdentityAssociationRequest.Builder().apply(block).build())

/**
 * Deletes an access entry.
 *
 * Deleting an access entry of a type other than `Standard` can cause your cluster to function improperly. If you delete an access entry in error, you can recreate it.
 */
public suspend inline fun EksClient.deleteAccessEntry(crossinline block: DeleteAccessEntryRequest.Builder.() -> Unit): DeleteAccessEntryResponse = deleteAccessEntry(DeleteAccessEntryRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon EKS add-on.
 *
 * When you remove an add-on, it's deleted from the cluster. You can always manually start an add-on on the cluster using the Kubernetes API.
 */
public suspend inline fun EksClient.deleteAddon(crossinline block: DeleteAddonRequest.Builder.() -> Unit): DeleteAddonResponse = deleteAddon(DeleteAddonRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon EKS cluster control plane.
 *
 * If you have active services in your cluster that are associated with a load balancer, you must delete those services before deleting the cluster so that the load balancers are deleted properly. Otherwise, you can have orphaned resources in your VPC that prevent you from being able to delete the VPC. For more information, see [Deleting a cluster](https://docs.aws.amazon.com/eks/latest/userguide/delete-cluster.html) in the *Amazon EKS User Guide*.
 *
 * If you have managed node groups or Fargate profiles attached to the cluster, you must delete them first. For more information, see `DeleteNodgroup` and `DeleteFargateProfile`.
 *
 * @sample aws.sdk.kotlin.services.eks.samples.DeleteCluster.sample
 */
public suspend inline fun EksClient.deleteCluster(crossinline block: DeleteClusterRequest.Builder.() -> Unit): DeleteClusterResponse = deleteCluster(DeleteClusterRequest.Builder().apply(block).build())

/**
 * Deletes an expired or inactive subscription. Deleting inactive subscriptions removes them from the Amazon Web Services Management Console view and from list/describe API responses. Subscriptions can only be cancelled within 7 days of creation and are cancelled by creating a ticket in the Amazon Web Services Support Center.
 */
public suspend inline fun EksClient.deleteEksAnywhereSubscription(crossinline block: DeleteEksAnywhereSubscriptionRequest.Builder.() -> Unit): DeleteEksAnywhereSubscriptionResponse = deleteEksAnywhereSubscription(DeleteEksAnywhereSubscriptionRequest.Builder().apply(block).build())

/**
 * Deletes an Fargate profile.
 *
 * When you delete a Fargate profile, any `Pod` running on Fargate that was created with the profile is deleted. If the `Pod` matches another Fargate profile, then it is scheduled on Fargate with that profile. If it no longer matches any Fargate profiles, then it's not scheduled on Fargate and may remain in a pending state.
 *
 * Only one Fargate profile in a cluster can be in the `DELETING` status at a time. You must wait for a Fargate profile to finish deleting before you can delete any other profiles in that cluster.
 */
public suspend inline fun EksClient.deleteFargateProfile(crossinline block: DeleteFargateProfileRequest.Builder.() -> Unit): DeleteFargateProfileResponse = deleteFargateProfile(DeleteFargateProfileRequest.Builder().apply(block).build())

/**
 * Deletes a managed node group.
 */
public suspend inline fun EksClient.deleteNodegroup(crossinline block: DeleteNodegroupRequest.Builder.() -> Unit): DeleteNodegroupResponse = deleteNodegroup(DeleteNodegroupRequest.Builder().apply(block).build())

/**
 * Deletes a EKS Pod Identity association.
 *
 * The temporary Amazon Web Services credentials from the previous IAM role session might still be valid until the session expiry. If you need to immediately revoke the temporary session credentials, then go to the role in the IAM console.
 */
public suspend inline fun EksClient.deletePodIdentityAssociation(crossinline block: DeletePodIdentityAssociationRequest.Builder.() -> Unit): DeletePodIdentityAssociationResponse = deletePodIdentityAssociation(DeletePodIdentityAssociationRequest.Builder().apply(block).build())

/**
 * Deregisters a connected cluster to remove it from the Amazon EKS control plane.
 *
 * A connected cluster is a Kubernetes cluster that you've connected to your control plane using the [Amazon EKS Connector](https://docs.aws.amazon.com/eks/latest/userguide/eks-connector.html).
 */
public suspend inline fun EksClient.deregisterCluster(crossinline block: DeregisterClusterRequest.Builder.() -> Unit): DeregisterClusterResponse = deregisterCluster(DeregisterClusterRequest.Builder().apply(block).build())

/**
 * Describes an access entry.
 */
public suspend inline fun EksClient.describeAccessEntry(crossinline block: DescribeAccessEntryRequest.Builder.() -> Unit): DescribeAccessEntryResponse = describeAccessEntry(DescribeAccessEntryRequest.Builder().apply(block).build())

/**
 * Describes an Amazon EKS add-on.
 */
public suspend inline fun EksClient.describeAddon(crossinline block: DescribeAddonRequest.Builder.() -> Unit): DescribeAddonResponse = describeAddon(DescribeAddonRequest.Builder().apply(block).build())

/**
 * Returns configuration options.
 */
public suspend inline fun EksClient.describeAddonConfiguration(crossinline block: DescribeAddonConfigurationRequest.Builder.() -> Unit): DescribeAddonConfigurationResponse = describeAddonConfiguration(DescribeAddonConfigurationRequest.Builder().apply(block).build())

/**
 * Describes the versions for an add-on.
 *
 * Information such as the Kubernetes versions that you can use the add-on with, the `owner`, `publisher`, and the `type` of the add-on are returned.
 */
public suspend inline fun EksClient.describeAddonVersions(crossinline block: DescribeAddonVersionsRequest.Builder.() -> Unit): DescribeAddonVersionsResponse = describeAddonVersions(DescribeAddonVersionsRequest.Builder().apply(block).build())

/**
 * Describes an Amazon EKS cluster.
 *
 * The API server endpoint and certificate authority data returned by this operation are required for `kubelet` and `kubectl` to communicate with your Kubernetes API server. For more information, see `kubeconfig`[ file for an Amazon EKS cluster](https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html).
 *
 * The API server endpoint and certificate authority data aren't available until the cluster reaches the `ACTIVE` state.
 *
 * @sample aws.sdk.kotlin.services.eks.samples.DescribeCluster.sample
 */
public suspend inline fun EksClient.describeCluster(crossinline block: DescribeClusterRequest.Builder.() -> Unit): DescribeClusterResponse = describeCluster(DescribeClusterRequest.Builder().apply(block).build())

/**
 * Lists available Kubernetes versions for Amazon EKS clusters.
 */
public suspend inline fun EksClient.describeClusterVersions(crossinline block: DescribeClusterVersionsRequest.Builder.() -> Unit): DescribeClusterVersionsResponse = describeClusterVersions(DescribeClusterVersionsRequest.Builder().apply(block).build())

/**
 * Returns descriptive information about a subscription.
 */
public suspend inline fun EksClient.describeEksAnywhereSubscription(crossinline block: DescribeEksAnywhereSubscriptionRequest.Builder.() -> Unit): DescribeEksAnywhereSubscriptionResponse = describeEksAnywhereSubscription(DescribeEksAnywhereSubscriptionRequest.Builder().apply(block).build())

/**
 * Describes an Fargate profile.
 */
public suspend inline fun EksClient.describeFargateProfile(crossinline block: DescribeFargateProfileRequest.Builder.() -> Unit): DescribeFargateProfileResponse = describeFargateProfile(DescribeFargateProfileRequest.Builder().apply(block).build())

/**
 * Describes an identity provider configuration.
 */
public suspend inline fun EksClient.describeIdentityProviderConfig(crossinline block: DescribeIdentityProviderConfigRequest.Builder.() -> Unit): DescribeIdentityProviderConfigResponse = describeIdentityProviderConfig(DescribeIdentityProviderConfigRequest.Builder().apply(block).build())

/**
 * Returns details about an insight that you specify using its ID.
 */
public suspend inline fun EksClient.describeInsight(crossinline block: DescribeInsightRequest.Builder.() -> Unit): DescribeInsightResponse = describeInsight(DescribeInsightRequest.Builder().apply(block).build())

/**
 * Returns the status of the latest on-demand cluster insights refresh operation.
 */
public suspend inline fun EksClient.describeInsightsRefresh(crossinline block: DescribeInsightsRefreshRequest.Builder.() -> Unit): DescribeInsightsRefreshResponse = describeInsightsRefresh(DescribeInsightsRefreshRequest.Builder().apply(block).build())

/**
 * Describes a managed node group.
 */
public suspend inline fun EksClient.describeNodegroup(crossinline block: DescribeNodegroupRequest.Builder.() -> Unit): DescribeNodegroupResponse = describeNodegroup(DescribeNodegroupRequest.Builder().apply(block).build())

/**
 * Returns descriptive information about an EKS Pod Identity association.
 *
 * This action requires the ID of the association. You can get the ID from the response to the `CreatePodIdentityAssocation` for newly created associations. Or, you can list the IDs for associations with `ListPodIdentityAssociations` and filter the list by namespace or service account.
 */
public suspend inline fun EksClient.describePodIdentityAssociation(crossinline block: DescribePodIdentityAssociationRequest.Builder.() -> Unit): DescribePodIdentityAssociationResponse = describePodIdentityAssociation(DescribePodIdentityAssociationRequest.Builder().apply(block).build())

/**
 * Describes an update to an Amazon EKS resource.
 *
 * When the status of the update is `Successful`, the update is complete. If an update fails, the status is `Failed`, and an error detail explains the reason for the failure.
 */
public suspend inline fun EksClient.describeUpdate(crossinline block: DescribeUpdateRequest.Builder.() -> Unit): DescribeUpdateResponse = describeUpdate(DescribeUpdateRequest.Builder().apply(block).build())

/**
 * Disassociates an access policy from an access entry.
 */
public suspend inline fun EksClient.disassociateAccessPolicy(crossinline block: DisassociateAccessPolicyRequest.Builder.() -> Unit): DisassociateAccessPolicyResponse = disassociateAccessPolicy(DisassociateAccessPolicyRequest.Builder().apply(block).build())

/**
 * Disassociates an identity provider configuration from a cluster.
 *
 * If you disassociate an identity provider from your cluster, users included in the provider can no longer access the cluster. However, you can still access the cluster with IAM principals.
 */
public suspend inline fun EksClient.disassociateIdentityProviderConfig(crossinline block: DisassociateIdentityProviderConfigRequest.Builder.() -> Unit): DisassociateIdentityProviderConfigResponse = disassociateIdentityProviderConfig(DisassociateIdentityProviderConfigRequest.Builder().apply(block).build())

/**
 * Lists the access entries for your cluster.
 */
public suspend inline fun EksClient.listAccessEntries(crossinline block: ListAccessEntriesRequest.Builder.() -> Unit): ListAccessEntriesResponse = listAccessEntries(ListAccessEntriesRequest.Builder().apply(block).build())

/**
 * Lists the available access policies.
 */
public suspend inline fun EksClient.listAccessPolicies(crossinline block: ListAccessPoliciesRequest.Builder.() -> Unit): ListAccessPoliciesResponse = listAccessPolicies(ListAccessPoliciesRequest.Builder().apply(block).build())

/**
 * Lists the installed add-ons.
 */
public suspend inline fun EksClient.listAddons(crossinline block: ListAddonsRequest.Builder.() -> Unit): ListAddonsResponse = listAddons(ListAddonsRequest.Builder().apply(block).build())

/**
 * Lists the access policies associated with an access entry.
 */
public suspend inline fun EksClient.listAssociatedAccessPolicies(crossinline block: ListAssociatedAccessPoliciesRequest.Builder.() -> Unit): ListAssociatedAccessPoliciesResponse = listAssociatedAccessPolicies(ListAssociatedAccessPoliciesRequest.Builder().apply(block).build())

/**
 * Lists the Amazon EKS clusters in your Amazon Web Services account in the specified Amazon Web Services Region.
 *
 * @sample aws.sdk.kotlin.services.eks.samples.ListClusters.sample
 */
public suspend inline fun EksClient.listClusters(crossinline block: ListClustersRequest.Builder.() -> Unit): ListClustersResponse = listClusters(ListClustersRequest.Builder().apply(block).build())

/**
 * Displays the full description of the subscription.
 */
public suspend inline fun EksClient.listEksAnywhereSubscriptions(crossinline block: ListEksAnywhereSubscriptionsRequest.Builder.() -> Unit): ListEksAnywhereSubscriptionsResponse = listEksAnywhereSubscriptions(ListEksAnywhereSubscriptionsRequest.Builder().apply(block).build())

/**
 * Lists the Fargate profiles associated with the specified cluster in your Amazon Web Services account in the specified Amazon Web Services Region.
 */
public suspend inline fun EksClient.listFargateProfiles(crossinline block: ListFargateProfilesRequest.Builder.() -> Unit): ListFargateProfilesResponse = listFargateProfiles(ListFargateProfilesRequest.Builder().apply(block).build())

/**
 * Lists the identity provider configurations for your cluster.
 */
public suspend inline fun EksClient.listIdentityProviderConfigs(crossinline block: ListIdentityProviderConfigsRequest.Builder.() -> Unit): ListIdentityProviderConfigsResponse = listIdentityProviderConfigs(ListIdentityProviderConfigsRequest.Builder().apply(block).build())

/**
 * Returns a list of all insights checked for against the specified cluster. You can filter which insights are returned by category, associated Kubernetes version, and status. The default filter lists all categories and every status.
 *
 * The following lists the available categories:
 * + `UPGRADE_READINESS`: Amazon EKS identifies issues that could impact your ability to upgrade to new versions of Kubernetes. These are called upgrade insights.
 * + `MISCONFIGURATION`: Amazon EKS identifies misconfiguration in your EKS Hybrid Nodes setup that could impair functionality of your cluster or workloads. These are called configuration insights.
 */
public suspend inline fun EksClient.listInsights(crossinline block: ListInsightsRequest.Builder.() -> Unit): ListInsightsResponse = listInsights(ListInsightsRequest.Builder().apply(block).build())

/**
 * Lists the managed node groups associated with the specified cluster in your Amazon Web Services account in the specified Amazon Web Services Region. Self-managed node groups aren't listed.
 */
public suspend inline fun EksClient.listNodegroups(crossinline block: ListNodegroupsRequest.Builder.() -> Unit): ListNodegroupsResponse = listNodegroups(ListNodegroupsRequest.Builder().apply(block).build())

/**
 * List the EKS Pod Identity associations in a cluster. You can filter the list by the namespace that the association is in or the service account that the association uses.
 */
public suspend inline fun EksClient.listPodIdentityAssociations(crossinline block: ListPodIdentityAssociationsRequest.Builder.() -> Unit): ListPodIdentityAssociationsResponse = listPodIdentityAssociations(ListPodIdentityAssociationsRequest.Builder().apply(block).build())

/**
 * List the tags for an Amazon EKS resource.
 *
 * @sample aws.sdk.kotlin.services.eks.samples.ListTagsForResource.sample
 */
public suspend inline fun EksClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the updates associated with an Amazon EKS resource in your Amazon Web Services account, in the specified Amazon Web Services Region.
 */
public suspend inline fun EksClient.listUpdates(crossinline block: ListUpdatesRequest.Builder.() -> Unit): ListUpdatesResponse = listUpdates(ListUpdatesRequest.Builder().apply(block).build())

/**
 * Connects a Kubernetes cluster to the Amazon EKS control plane.
 *
 * Any Kubernetes cluster can be connected to the Amazon EKS control plane to view current information about the cluster and its nodes.
 *
 * Cluster connection requires two steps. First, send a `RegisterClusterRequest`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_RegisterClusterRequest.html) to add it to the Amazon EKS control plane.
 *
 * Second, a [Manifest](https://amazon-eks.s3.us-west-2.amazonaws.com/eks-connector/manifests/eks-connector/latest/eks-connector.yaml) containing the `activationID` and `activationCode` must be applied to the Kubernetes cluster through it's native provider to provide visibility.
 *
 * After the manifest is updated and applied, the connected cluster is visible to the Amazon EKS control plane. If the manifest isn't applied within three days, the connected cluster will no longer be visible and must be deregistered using `DeregisterCluster`.
 */
public suspend inline fun EksClient.registerCluster(crossinline block: RegisterClusterRequest.Builder.() -> Unit): RegisterClusterResponse = registerCluster(RegisterClusterRequest.Builder().apply(block).build())

/**
 * Initiates an on-demand refresh operation for cluster insights, getting the latest analysis outside of the standard refresh schedule.
 */
public suspend inline fun EksClient.startInsightsRefresh(crossinline block: StartInsightsRefreshRequest.Builder.() -> Unit): StartInsightsRefreshResponse = startInsightsRefresh(StartInsightsRefreshRequest.Builder().apply(block).build())

/**
 * Associates the specified tags to an Amazon EKS resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they aren't changed. When a resource is deleted, the tags associated with that resource are also deleted. Tags that you create for Amazon EKS resources don't propagate to any other resources associated with the cluster. For example, if you tag a cluster with this operation, that tag doesn't automatically propagate to the subnets and nodes associated with the cluster.
 */
public suspend inline fun EksClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes specified tags from an Amazon EKS resource.
 */
public suspend inline fun EksClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an access entry.
 */
public suspend inline fun EksClient.updateAccessEntry(crossinline block: UpdateAccessEntryRequest.Builder.() -> Unit): UpdateAccessEntryResponse = updateAccessEntry(UpdateAccessEntryRequest.Builder().apply(block).build())

/**
 * Updates an Amazon EKS add-on.
 */
public suspend inline fun EksClient.updateAddon(crossinline block: UpdateAddonRequest.Builder.() -> Unit): UpdateAddonResponse = updateAddon(UpdateAddonRequest.Builder().apply(block).build())

/**
 * Updates an Amazon EKS cluster configuration. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with `DescribeUpdate`.
 *
 * You can use this operation to do the following actions:
 * + You can use this API operation to enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see [Amazon EKS Cluster control plane logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html) in the **Amazon EKS User Guide**.CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see [CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
 * + You can also use this API operation to enable or disable public and private access to your cluster's Kubernetes API server endpoint. By default, public access is enabled, and private access is disabled. For more information, see [ Cluster API server endpoint](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
 * + You can also use this API operation to choose different subnets and security groups for the cluster. You must specify at least two subnets that are in different Availability Zones. You can't change which VPC the subnets are from, the subnets must be in the same VPC as the subnets that the cluster was created with. For more information about the VPC requirements, see [https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) in the **Amazon EKS User Guide**.
 * + You can also use this API operation to enable or disable ARC zonal shift. If zonal shift is enabled, Amazon Web Services configures zonal autoshift for the cluster.
 * + You can also use this API operation to add, change, or remove the configuration in the cluster for EKS Hybrid Nodes. To remove the configuration, use the `remoteNetworkConfig` key with an object containing both subkeys with empty arrays for each. Here is an inline example: `"remoteNetworkConfig": { "remoteNodeNetworks": [], "remotePodNetworks": [] }`.
 *
 * Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster status moves to `UPDATING` (this status transition is eventually consistent). When the update is complete (either `Failed` or `Successful`), the cluster status moves to `Active`.
 */
public suspend inline fun EksClient.updateClusterConfig(crossinline block: UpdateClusterConfigRequest.Builder.() -> Unit): UpdateClusterConfigResponse = updateClusterConfig(UpdateClusterConfigRequest.Builder().apply(block).build())

/**
 * Updates an Amazon EKS cluster to the specified Kubernetes version. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with the `DescribeUpdate`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeUpdate.html) API operation.
 *
 * Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster status moves to `UPDATING` (this status transition is eventually consistent). When the update is complete (either `Failed` or `Successful`), the cluster status moves to `Active`.
 *
 * If your cluster has managed node groups attached to it, all of your node groups' Kubernetes versions must match the cluster's Kubernetes version in order to update the cluster to a new Kubernetes version.
 */
public suspend inline fun EksClient.updateClusterVersion(crossinline block: UpdateClusterVersionRequest.Builder.() -> Unit): UpdateClusterVersionResponse = updateClusterVersion(UpdateClusterVersionRequest.Builder().apply(block).build())

/**
 * Update an EKS Anywhere Subscription. Only auto renewal and tags can be updated after subscription creation.
 */
public suspend inline fun EksClient.updateEksAnywhereSubscription(crossinline block: UpdateEksAnywhereSubscriptionRequest.Builder.() -> Unit): UpdateEksAnywhereSubscriptionResponse = updateEksAnywhereSubscription(UpdateEksAnywhereSubscriptionRequest.Builder().apply(block).build())

/**
 * Updates an Amazon EKS managed node group configuration. Your node group continues to function during the update. The response output includes an update ID that you can use to track the status of your node group update with the `DescribeUpdate`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeUpdate.html) API operation. You can update the Kubernetes labels and taints for a node group and the scaling and version update configuration.
 */
public suspend inline fun EksClient.updateNodegroupConfig(crossinline block: UpdateNodegroupConfigRequest.Builder.() -> Unit): UpdateNodegroupConfigResponse = updateNodegroupConfig(UpdateNodegroupConfigRequest.Builder().apply(block).build())

/**
 * Updates the Kubernetes version or AMI version of an Amazon EKS managed node group.
 *
 * You can update a node group using a launch template only if the node group was originally deployed with a launch template. Additionally, the launch template ID or name must match what was used when the node group was created. You can update the launch template version with necessary changes.
 *
 * If you need to update a custom AMI in a node group that was deployed with a launch template, then update your custom AMI, specify the new ID in a new version of the launch template, and then update the node group to the new version of the launch template.
 *
 * If you update without a launch template, then you can update to the latest available AMI version of a node group's current Kubernetes version by not specifying a Kubernetes version in the request. You can update to the latest AMI version of your cluster's current Kubernetes version by specifying your cluster's Kubernetes version in the request. For information about Linux versions, see [Amazon EKS optimized Amazon Linux AMI versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html) in the *Amazon EKS User Guide*. For information about Windows versions, see [Amazon EKS optimized Windows AMI versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-ami-versions-windows.html) in the *Amazon EKS User Guide*.
 *
 * You cannot roll back a node group to an earlier Kubernetes version or AMI version.
 *
 * When a node in a managed node group is terminated due to a scaling action or update, every `Pod` on that node is drained first. Amazon EKS attempts to drain the nodes gracefully and will fail if it is unable to do so. You can `force` the update if Amazon EKS is unable to drain the nodes as a result of a `Pod` disruption budget issue.
 */
public suspend inline fun EksClient.updateNodegroupVersion(crossinline block: UpdateNodegroupVersionRequest.Builder.() -> Unit): UpdateNodegroupVersionResponse = updateNodegroupVersion(UpdateNodegroupVersionRequest.Builder().apply(block).build())

/**
 * Updates a EKS Pod Identity association. In an update, you can change the IAM role, the target IAM role, or `disableSessionTags`. You must change at least one of these in an update. An association can't be moved between clusters, namespaces, or service accounts. If you need to edit the namespace or service account, you need to delete the association and then create a new association with your desired settings.
 *
 * Similar to Amazon Web Services IAM behavior, EKS Pod Identity associations are eventually consistent, and may take several seconds to be effective after the initial API call returns successfully. You must design your applications to account for these potential delays. We recommend that you don’t include association create/updates in the critical, high-availability code paths of your application. Instead, make changes in a separate initialization or setup routine that you run less frequently.
 *
 * You can set a *target IAM role* in the same or a different account for advanced scenarios. With a target role, EKS Pod Identity automatically performs two role assumptions in sequence: first assuming the role in the association that is in this account, then using those credentials to assume the target IAM role. This process provides your Pod with temporary credentials that have the permissions defined in the target role, allowing secure access to resources in another Amazon Web Services account.
 */
public suspend inline fun EksClient.updatePodIdentityAssociation(crossinline block: UpdatePodIdentityAssociationRequest.Builder.() -> Unit): UpdatePodIdentityAssociationResponse = updatePodIdentityAssociation(UpdatePodIdentityAssociationRequest.Builder().apply(block).build())
