// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.serde

import aws.sdk.kotlin.services.eks.model.AddonPodIdentityAssociations
import aws.sdk.kotlin.services.eks.model.ResolveConflicts
import aws.sdk.kotlin.services.eks.model.UpdateAddonRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateAddonOperationSerializer: HttpSerializer.NonStreaming<UpdateAddonRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateAddonRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.clusterName) { "clusterName is bound to the URI and must not be null" }
            requireNotNull(input.addonName) { "addonName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("clusters"))
                add(PercentEncoding.SmithyLabel.encode(input.clusterName))
                add(PercentEncoding.Path.encode("addons"))
                add(PercentEncoding.SmithyLabel.encode(input.addonName))
                add(PercentEncoding.Path.encode("update"))
            }
        }

        val payload = serializeUpdateAddonOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateAddonOperationBody(context: ExecutionContext, input: UpdateAddonRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADDONVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("addonVersion"))
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val CONFIGURATIONVALUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("configurationValues"))
    val PODIDENTITYASSOCIATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("podIdentityAssociations"))
    val RESOLVECONFLICTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("resolveConflicts"))
    val SERVICEACCOUNTROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serviceAccountRoleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDONVERSION_DESCRIPTOR)
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(CONFIGURATIONVALUES_DESCRIPTOR)
        field(PODIDENTITYASSOCIATIONS_DESCRIPTOR)
        field(RESOLVECONFLICTS_DESCRIPTOR)
        field(SERVICEACCOUNTROLEARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.addonVersion?.let { field(ADDONVERSION_DESCRIPTOR, it) }
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.configurationValues?.let { field(CONFIGURATIONVALUES_DESCRIPTOR, it) }
        if (input.podIdentityAssociations != null) {
            listField(PODIDENTITYASSOCIATIONS_DESCRIPTOR) {
                for (el0 in input.podIdentityAssociations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAddonPodIdentityAssociationsDocument))
                }
            }
        }
        input.resolveConflicts?.let { field(RESOLVECONFLICTS_DESCRIPTOR, it.value) }
        input.serviceAccountRoleArn?.let { field(SERVICEACCOUNTROLEARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
