// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object representing the configuration of your local Amazon EKS cluster on an Amazon Web Services Outpost. This API isn't available for Amazon EKS clusters on the Amazon Web Services cloud.
 */
public class OutpostConfigResponse private constructor(builder: Builder) {
    /**
     * The Amazon EC2 instance type used for the control plane. The instance type is the same for all control plane instances.
     */
    public val controlPlaneInstanceType: kotlin.String = requireNotNull(builder.controlPlaneInstanceType) { "A non-null value must be provided for controlPlaneInstanceType" }
    /**
     * An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on an Amazon Web Services Outpost. For more information, see [Capacity considerations](https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html) in the *Amazon EKS User Guide*.
     */
    public val controlPlanePlacement: aws.sdk.kotlin.services.eks.model.ControlPlanePlacementResponse? = builder.controlPlanePlacement
    /**
     * The ARN of the Outpost that you specified for use with your local Amazon EKS cluster on Outposts.
     */
    public val outpostArns: List<String> = requireNotNull(builder.outpostArns) { "A non-null value must be provided for outpostArns" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.OutpostConfigResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OutpostConfigResponse(")
        append("controlPlaneInstanceType=$controlPlaneInstanceType,")
        append("controlPlanePlacement=$controlPlanePlacement,")
        append("outpostArns=$outpostArns")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = controlPlaneInstanceType.hashCode()
        result = 31 * result + (controlPlanePlacement?.hashCode() ?: 0)
        result = 31 * result + (outpostArns.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OutpostConfigResponse

        if (controlPlaneInstanceType != other.controlPlaneInstanceType) return false
        if (controlPlanePlacement != other.controlPlanePlacement) return false
        if (outpostArns != other.outpostArns) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.OutpostConfigResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon EC2 instance type used for the control plane. The instance type is the same for all control plane instances.
         */
        public var controlPlaneInstanceType: kotlin.String? = null
        /**
         * An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on an Amazon Web Services Outpost. For more information, see [Capacity considerations](https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html) in the *Amazon EKS User Guide*.
         */
        public var controlPlanePlacement: aws.sdk.kotlin.services.eks.model.ControlPlanePlacementResponse? = null
        /**
         * The ARN of the Outpost that you specified for use with your local Amazon EKS cluster on Outposts.
         */
        public var outpostArns: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.OutpostConfigResponse) : this() {
            this.controlPlaneInstanceType = x.controlPlaneInstanceType
            this.controlPlanePlacement = x.controlPlanePlacement
            this.outpostArns = x.outpostArns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.OutpostConfigResponse = OutpostConfigResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.ControlPlanePlacementResponse] inside the given [block]
         */
        public fun controlPlanePlacement(block: aws.sdk.kotlin.services.eks.model.ControlPlanePlacementResponse.Builder.() -> kotlin.Unit) {
            this.controlPlanePlacement = aws.sdk.kotlin.services.eks.model.ControlPlanePlacementResponse.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (controlPlaneInstanceType == null) controlPlaneInstanceType = ""
            if (outpostArns == null) outpostArns = emptyList()
            return this
        }
    }
}
