// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Kubernetes network configuration for the cluster. The response contains a value for **serviceIpv6Cidr** or **serviceIpv4Cidr**, but not both.
 */
public class KubernetesNetworkConfigResponse private constructor(builder: Builder) {
    /**
     * Indicates the current configuration of the load balancing capability on your EKS Auto Mode cluster. For example, if the capability is enabled or disabled.
     */
    public val elasticLoadBalancing: aws.sdk.kotlin.services.eks.model.ElasticLoadBalancing? = builder.elasticLoadBalancing
    /**
     * The IP family used to assign Kubernetes `Pod` and `Service` objects IP addresses. The IP family is always `ipv4`, unless you have a `1.21` or later cluster running version `1.10.1` or later of the Amazon VPC CNI plugin for Kubernetes and specified `ipv6` when you created the cluster.
     */
    public val ipFamily: aws.sdk.kotlin.services.eks.model.IpFamily? = builder.ipFamily
    /**
     * The CIDR block that Kubernetes `Pod` and `Service` object IP addresses are assigned from. Kubernetes assigns addresses from an `IPv4` CIDR block assigned to a subnet that the node is in. If you didn't specify a CIDR block when you created the cluster, then Kubernetes assigns addresses from either the `10.100.0.0/16` or `172.20.0.0/16` CIDR blocks. If this was specified, then it was specified when the cluster was created and it can't be changed.
     */
    public val serviceIpv4Cidr: kotlin.String? = builder.serviceIpv4Cidr
    /**
     * The CIDR block that Kubernetes pod and service IP addresses are assigned from if you created a 1.21 or later cluster with version 1.10.1 or later of the Amazon VPC CNI add-on and specified `ipv6` for **ipFamily** when you created the cluster. Kubernetes assigns service addresses from the unique local address range (`fc00::/7`) because you can't specify a custom IPv6 CIDR block when you create the cluster.
     */
    public val serviceIpv6Cidr: kotlin.String? = builder.serviceIpv6Cidr

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KubernetesNetworkConfigResponse(")
        append("elasticLoadBalancing=$elasticLoadBalancing,")
        append("ipFamily=$ipFamily,")
        append("serviceIpv4Cidr=$serviceIpv4Cidr,")
        append("serviceIpv6Cidr=$serviceIpv6Cidr")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = elasticLoadBalancing?.hashCode() ?: 0
        result = 31 * result + (ipFamily?.hashCode() ?: 0)
        result = 31 * result + (serviceIpv4Cidr?.hashCode() ?: 0)
        result = 31 * result + (serviceIpv6Cidr?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KubernetesNetworkConfigResponse

        if (elasticLoadBalancing != other.elasticLoadBalancing) return false
        if (ipFamily != other.ipFamily) return false
        if (serviceIpv4Cidr != other.serviceIpv4Cidr) return false
        if (serviceIpv6Cidr != other.serviceIpv6Cidr) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates the current configuration of the load balancing capability on your EKS Auto Mode cluster. For example, if the capability is enabled or disabled.
         */
        public var elasticLoadBalancing: aws.sdk.kotlin.services.eks.model.ElasticLoadBalancing? = null
        /**
         * The IP family used to assign Kubernetes `Pod` and `Service` objects IP addresses. The IP family is always `ipv4`, unless you have a `1.21` or later cluster running version `1.10.1` or later of the Amazon VPC CNI plugin for Kubernetes and specified `ipv6` when you created the cluster.
         */
        public var ipFamily: aws.sdk.kotlin.services.eks.model.IpFamily? = null
        /**
         * The CIDR block that Kubernetes `Pod` and `Service` object IP addresses are assigned from. Kubernetes assigns addresses from an `IPv4` CIDR block assigned to a subnet that the node is in. If you didn't specify a CIDR block when you created the cluster, then Kubernetes assigns addresses from either the `10.100.0.0/16` or `172.20.0.0/16` CIDR blocks. If this was specified, then it was specified when the cluster was created and it can't be changed.
         */
        public var serviceIpv4Cidr: kotlin.String? = null
        /**
         * The CIDR block that Kubernetes pod and service IP addresses are assigned from if you created a 1.21 or later cluster with version 1.10.1 or later of the Amazon VPC CNI add-on and specified `ipv6` for **ipFamily** when you created the cluster. Kubernetes assigns service addresses from the unique local address range (`fc00::/7`) because you can't specify a custom IPv6 CIDR block when you create the cluster.
         */
        public var serviceIpv6Cidr: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigResponse) : this() {
            this.elasticLoadBalancing = x.elasticLoadBalancing
            this.ipFamily = x.ipFamily
            this.serviceIpv4Cidr = x.serviceIpv4Cidr
            this.serviceIpv6Cidr = x.serviceIpv6Cidr
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigResponse = KubernetesNetworkConfigResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.ElasticLoadBalancing] inside the given [block]
         */
        public fun elasticLoadBalancing(block: aws.sdk.kotlin.services.eks.model.ElasticLoadBalancing.Builder.() -> kotlin.Unit) {
            this.elasticLoadBalancing = aws.sdk.kotlin.services.eks.model.ElasticLoadBalancing.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
