// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object representing an error when an asynchronous operation fails.
 */
public class ErrorDetail private constructor(builder: Builder) {
    /**
     * A brief description of the error.
     * + **SubnetNotFound**: We couldn't find one of the subnets associated with the cluster.
     * + **SecurityGroupNotFound**: We couldn't find one of the security groups associated with the cluster.
     * + **EniLimitReached**: You have reached the elastic network interface limit for your account.
     * + **IpNotAvailable**: A subnet associated with the cluster doesn't have any available IP addresses.
     * + **AccessDenied**: You don't have permissions to perform the specified operation.
     * + **OperationNotPermitted**: The service role associated with the cluster doesn't have the required access permissions for Amazon EKS.
     * + **VpcIdNotFound**: We couldn't find the VPC associated with the cluster.
     */
    public val errorCode: aws.sdk.kotlin.services.eks.model.ErrorCode? = builder.errorCode
    /**
     * A more complete description of the error.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * An optional field that contains the resource IDs associated with the error.
     */
    public val resourceIds: List<String>? = builder.resourceIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.ErrorDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ErrorDetail(")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage,")
        append("resourceIds=$resourceIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCode?.hashCode() ?: 0
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (resourceIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ErrorDetail

        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false
        if (resourceIds != other.resourceIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.ErrorDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A brief description of the error.
         * + **SubnetNotFound**: We couldn't find one of the subnets associated with the cluster.
         * + **SecurityGroupNotFound**: We couldn't find one of the security groups associated with the cluster.
         * + **EniLimitReached**: You have reached the elastic network interface limit for your account.
         * + **IpNotAvailable**: A subnet associated with the cluster doesn't have any available IP addresses.
         * + **AccessDenied**: You don't have permissions to perform the specified operation.
         * + **OperationNotPermitted**: The service role associated with the cluster doesn't have the required access permissions for Amazon EKS.
         * + **VpcIdNotFound**: We couldn't find the VPC associated with the cluster.
         */
        public var errorCode: aws.sdk.kotlin.services.eks.model.ErrorCode? = null
        /**
         * A more complete description of the error.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * An optional field that contains the resource IDs associated with the error.
         */
        public var resourceIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.ErrorDetail) : this() {
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
            this.resourceIds = x.resourceIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.ErrorDetail = ErrorDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
