// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAddonRequest private constructor(builder: Builder) {
    /**
     * The name of the add-on. The name must match one of the names returned by `DescribeAddonVersions`.
     */
    public val addonName: kotlin.String? = builder.addonName
    /**
     * The version of the add-on. The version must match one of the versions returned by `DescribeAddonVersions`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html).
     */
    public val addonVersion: kotlin.String? = builder.addonVersion
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The name of your cluster.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * The set of configuration values for the add-on that's created. The values that you provide are validated against the schema returned by `DescribeAddonConfiguration`.
     */
    public val configurationValues: kotlin.String? = builder.configurationValues
    /**
     * The namespace configuration for the addon. If specified, this will override the default namespace for the addon.
     */
    public val namespaceConfig: aws.sdk.kotlin.services.eks.model.AddonNamespaceConfigRequest? = builder.namespaceConfig
    /**
     * An array of EKS Pod Identity associations to be created. Each association maps a Kubernetes service account to an IAM role.
     *
     * For more information, see [Attach an IAM Role to an Amazon EKS add-on using EKS Pod Identity](https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html) in the *Amazon EKS User Guide*.
     */
    public val podIdentityAssociations: List<AddonPodIdentityAssociations>? = builder.podIdentityAssociations
    /**
     * How to resolve field value conflicts for an Amazon EKS add-on. Conflicts are handled based on the value you choose:
     * + **None** – If the self-managed version of the add-on is installed on your cluster, Amazon EKS doesn't change the value. Creation of the add-on might fail.
     * + **Overwrite** – If the self-managed version of the add-on is installed on your cluster and the Amazon EKS default value is different than the existing value, Amazon EKS changes the value to the Amazon EKS default value.
     * + **Preserve** – This is similar to the NONE option. If the self-managed version of the add-on is installed on your cluster Amazon EKS doesn't change the add-on resource properties. Creation of the add-on might fail if conflicts are detected. This option works differently during the update operation. For more information, see `UpdateAddon`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html).
     *
     * If you don't currently have the self-managed version of the add-on installed on your cluster, the Amazon EKS add-on is installed. Amazon EKS sets all values to default values, regardless of the option that you specify.
     */
    public val resolveConflicts: aws.sdk.kotlin.services.eks.model.ResolveConflicts? = builder.resolveConflicts
    /**
     * The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html) in the *Amazon EKS User Guide*.
     *
     * To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see [Enabling IAM roles for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html) in the *Amazon EKS User Guide*.
     */
    public val serviceAccountRoleArn: kotlin.String? = builder.serviceAccountRoleArn
    /**
     * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.CreateAddonRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAddonRequest(")
        append("addonName=$addonName,")
        append("addonVersion=$addonVersion,")
        append("clientRequestToken=$clientRequestToken,")
        append("clusterName=$clusterName,")
        append("configurationValues=$configurationValues,")
        append("namespaceConfig=$namespaceConfig,")
        append("podIdentityAssociations=$podIdentityAssociations,")
        append("resolveConflicts=$resolveConflicts,")
        append("serviceAccountRoleArn=$serviceAccountRoleArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addonName?.hashCode() ?: 0
        result = 31 * result + (addonVersion?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (configurationValues?.hashCode() ?: 0)
        result = 31 * result + (namespaceConfig?.hashCode() ?: 0)
        result = 31 * result + (podIdentityAssociations?.hashCode() ?: 0)
        result = 31 * result + (resolveConflicts?.hashCode() ?: 0)
        result = 31 * result + (serviceAccountRoleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAddonRequest

        if (addonName != other.addonName) return false
        if (addonVersion != other.addonVersion) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (clusterName != other.clusterName) return false
        if (configurationValues != other.configurationValues) return false
        if (namespaceConfig != other.namespaceConfig) return false
        if (podIdentityAssociations != other.podIdentityAssociations) return false
        if (resolveConflicts != other.resolveConflicts) return false
        if (serviceAccountRoleArn != other.serviceAccountRoleArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.CreateAddonRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the add-on. The name must match one of the names returned by `DescribeAddonVersions`.
         */
        public var addonName: kotlin.String? = null
        /**
         * The version of the add-on. The version must match one of the versions returned by `DescribeAddonVersions`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html).
         */
        public var addonVersion: kotlin.String? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The name of your cluster.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The set of configuration values for the add-on that's created. The values that you provide are validated against the schema returned by `DescribeAddonConfiguration`.
         */
        public var configurationValues: kotlin.String? = null
        /**
         * The namespace configuration for the addon. If specified, this will override the default namespace for the addon.
         */
        public var namespaceConfig: aws.sdk.kotlin.services.eks.model.AddonNamespaceConfigRequest? = null
        /**
         * An array of EKS Pod Identity associations to be created. Each association maps a Kubernetes service account to an IAM role.
         *
         * For more information, see [Attach an IAM Role to an Amazon EKS add-on using EKS Pod Identity](https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html) in the *Amazon EKS User Guide*.
         */
        public var podIdentityAssociations: List<AddonPodIdentityAssociations>? = null
        /**
         * How to resolve field value conflicts for an Amazon EKS add-on. Conflicts are handled based on the value you choose:
         * + **None** – If the self-managed version of the add-on is installed on your cluster, Amazon EKS doesn't change the value. Creation of the add-on might fail.
         * + **Overwrite** – If the self-managed version of the add-on is installed on your cluster and the Amazon EKS default value is different than the existing value, Amazon EKS changes the value to the Amazon EKS default value.
         * + **Preserve** – This is similar to the NONE option. If the self-managed version of the add-on is installed on your cluster Amazon EKS doesn't change the add-on resource properties. Creation of the add-on might fail if conflicts are detected. This option works differently during the update operation. For more information, see `UpdateAddon`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html).
         *
         * If you don't currently have the self-managed version of the add-on installed on your cluster, the Amazon EKS add-on is installed. Amazon EKS sets all values to default values, regardless of the option that you specify.
         */
        public var resolveConflicts: aws.sdk.kotlin.services.eks.model.ResolveConflicts? = null
        /**
         * The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html) in the *Amazon EKS User Guide*.
         *
         * To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see [Enabling IAM roles for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html) in the *Amazon EKS User Guide*.
         */
        public var serviceAccountRoleArn: kotlin.String? = null
        /**
         * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.CreateAddonRequest) : this() {
            this.addonName = x.addonName
            this.addonVersion = x.addonVersion
            this.clientRequestToken = x.clientRequestToken
            this.clusterName = x.clusterName
            this.configurationValues = x.configurationValues
            this.namespaceConfig = x.namespaceConfig
            this.podIdentityAssociations = x.podIdentityAssociations
            this.resolveConflicts = x.resolveConflicts
            this.serviceAccountRoleArn = x.serviceAccountRoleArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.CreateAddonRequest = CreateAddonRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.AddonNamespaceConfigRequest] inside the given [block]
         */
        public fun namespaceConfig(block: aws.sdk.kotlin.services.eks.model.AddonNamespaceConfigRequest.Builder.() -> kotlin.Unit) {
            this.namespaceConfig = aws.sdk.kotlin.services.eks.model.AddonNamespaceConfigRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
