// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An access entry allows an IAM principal (user or role) to access your cluster. Access entries can replace the need to maintain the `aws-auth``ConfigMap` for authentication. For more information about access entries, see [Access entries](https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html) in the *Amazon EKS User Guide*.
 */
public class AccessEntry private constructor(builder: Builder) {
    /**
     * The ARN of the access entry.
     */
    public val accessEntryArn: kotlin.String? = builder.accessEntryArn
    /**
     * The name of your cluster.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * The Unix epoch timestamp at object creation.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * A `name` that you've specified in a Kubernetes `RoleBinding` or `ClusterRoleBinding` object so that Kubernetes authorizes the `principalARN` access to cluster objects.
     */
    public val kubernetesGroups: List<String>? = builder.kubernetesGroups
    /**
     * The Unix epoch timestamp for the last modification to the object.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedAt
    /**
     * The ARN of the IAM principal for the access entry. If you ever delete the IAM principal with this ARN, the access entry isn't automatically deleted. We recommend that you delete the access entry with an ARN for an IAM principal that you delete. If you don't delete the access entry and ever recreate the IAM principal, even if it has the same ARN, the access entry won't work. This is because even though the ARN is the same for the recreated IAM principal, the `roleID` or `userID` (you can see this with the Security Token Service `GetCallerIdentity` API) is different for the recreated IAM principal than it was for the original IAM principal. Even though you don't see the IAM principal's `roleID` or `userID` for an access entry, Amazon EKS stores it with the access entry.
     */
    public val principalArn: kotlin.String? = builder.principalArn
    /**
     * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of the access entry.
     */
    public val type: kotlin.String? = builder.type
    /**
     * The `name` of a user that can authenticate to your cluster.
     */
    public val username: kotlin.String? = builder.username

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.AccessEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessEntry(")
        append("accessEntryArn=$accessEntryArn,")
        append("clusterName=$clusterName,")
        append("createdAt=$createdAt,")
        append("kubernetesGroups=$kubernetesGroups,")
        append("modifiedAt=$modifiedAt,")
        append("principalArn=$principalArn,")
        append("tags=$tags,")
        append("type=$type,")
        append("username=$username")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessEntryArn?.hashCode() ?: 0
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (kubernetesGroups?.hashCode() ?: 0)
        result = 31 * result + (modifiedAt?.hashCode() ?: 0)
        result = 31 * result + (principalArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessEntry

        if (accessEntryArn != other.accessEntryArn) return false
        if (clusterName != other.clusterName) return false
        if (createdAt != other.createdAt) return false
        if (kubernetesGroups != other.kubernetesGroups) return false
        if (modifiedAt != other.modifiedAt) return false
        if (principalArn != other.principalArn) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.AccessEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the access entry.
         */
        public var accessEntryArn: kotlin.String? = null
        /**
         * The name of your cluster.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The Unix epoch timestamp at object creation.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A `name` that you've specified in a Kubernetes `RoleBinding` or `ClusterRoleBinding` object so that Kubernetes authorizes the `principalARN` access to cluster objects.
         */
        public var kubernetesGroups: List<String>? = null
        /**
         * The Unix epoch timestamp for the last modification to the object.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the IAM principal for the access entry. If you ever delete the IAM principal with this ARN, the access entry isn't automatically deleted. We recommend that you delete the access entry with an ARN for an IAM principal that you delete. If you don't delete the access entry and ever recreate the IAM principal, even if it has the same ARN, the access entry won't work. This is because even though the ARN is the same for the recreated IAM principal, the `roleID` or `userID` (you can see this with the Security Token Service `GetCallerIdentity` API) is different for the recreated IAM principal than it was for the original IAM principal. Even though you don't see the IAM principal's `roleID` or `userID` for an access entry, Amazon EKS stores it with the access entry.
         */
        public var principalArn: kotlin.String? = null
        /**
         * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of the access entry.
         */
        public var type: kotlin.String? = null
        /**
         * The `name` of a user that can authenticate to your cluster.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.AccessEntry) : this() {
            this.accessEntryArn = x.accessEntryArn
            this.clusterName = x.clusterName
            this.createdAt = x.createdAt
            this.kubernetesGroups = x.kubernetesGroups
            this.modifiedAt = x.modifiedAt
            this.principalArn = x.principalArn
            this.tags = x.tags
            this.type = x.type
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.AccessEntry = AccessEntry(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
