// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant


/**
 * The latest known metered size (in bytes) of data stored in the file system, in its `Value` field, and the time at which that size was determined in its `Timestamp` field. The value doesn't represent the size of a consistent snapshot of the file system, but it is eventually consistent when there are no writes to the file system. That is, the value represents the actual size only if the file system is not modified for a period longer than a couple of hours. Otherwise, the value is not necessarily the exact size the file system was at any instant in time.
 */
public class FileSystemSize private constructor(builder: Builder) {
    /**
     * The time at which the size of data, returned in the `Value` field, was determined. The value is the integer number of seconds since 1970-01-01T00:00:00Z.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp
    /**
     * The latest known metered size (in bytes) of data stored in the file system.
     */
    public val value: kotlin.Long = builder.value
    /**
     * The latest known metered size (in bytes) of data stored in the Archive storage class.
     */
    public val valueInArchive: kotlin.Long? = builder.valueInArchive
    /**
     * The latest known metered size (in bytes) of data stored in the Infrequent Access storage class.
     */
    public val valueInIa: kotlin.Long? = builder.valueInIa
    /**
     * The latest known metered size (in bytes) of data stored in the Standard storage class.
     */
    public val valueInStandard: kotlin.Long? = builder.valueInStandard

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.FileSystemSize = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FileSystemSize(")
        append("timestamp=$timestamp,")
        append("value=$value,")
        append("valueInArchive=$valueInArchive,")
        append("valueInIa=$valueInIa,")
        append("valueInStandard=$valueInStandard")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = timestamp?.hashCode() ?: 0
        result = 31 * result + (this.value.hashCode())
        result = 31 * result + (this.valueInArchive?.hashCode() ?: 0)
        result = 31 * result + (this.valueInIa?.hashCode() ?: 0)
        result = 31 * result + (this.valueInStandard?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FileSystemSize

        if (timestamp != other.timestamp) return false
        if (value != other.value) return false
        if (valueInArchive != other.valueInArchive) return false
        if (valueInIa != other.valueInIa) return false
        if (valueInStandard != other.valueInStandard) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.FileSystemSize = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time at which the size of data, returned in the `Value` field, was determined. The value is the integer number of seconds since 1970-01-01T00:00:00Z.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The latest known metered size (in bytes) of data stored in the file system.
         */
        public var value: kotlin.Long = 0L
        /**
         * The latest known metered size (in bytes) of data stored in the Archive storage class.
         */
        public var valueInArchive: kotlin.Long? = null
        /**
         * The latest known metered size (in bytes) of data stored in the Infrequent Access storage class.
         */
        public var valueInIa: kotlin.Long? = null
        /**
         * The latest known metered size (in bytes) of data stored in the Standard storage class.
         */
        public var valueInStandard: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.FileSystemSize) : this() {
            this.timestamp = x.timestamp
            this.value = x.value
            this.valueInArchive = x.valueInArchive
            this.valueInIa = x.valueInIa
            this.valueInStandard = x.valueInStandard
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.FileSystemSize = FileSystemSize(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
