// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata


/**
 * Returned if the file system you are trying to create already exists, with the creation token you provided.
 */
public class FileSystemAlreadyExists private constructor(builder: Builder) : EfsException(builder.message) {

    /**
     * The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type.
     */
    public val errorCode: kotlin.String = requireNotNull(builder.errorCode) { "A non-null value must be provided for errorCode" }
    public val fileSystemId: kotlin.String = requireNotNull(builder.fileSystemId) { "A non-null value must be provided for fileSystemId" }

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.FileSystemAlreadyExists = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FileSystemAlreadyExists(")
        append("errorCode=$errorCode,")
        append("fileSystemId=$fileSystemId,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCode.hashCode()
        result = 31 * result + (this.fileSystemId.hashCode())
        result = 31 * result + (this.message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FileSystemAlreadyExists

        if (errorCode != other.errorCode) return false
        if (fileSystemId != other.fileSystemId) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.FileSystemAlreadyExists = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type.
         */
        public var errorCode: kotlin.String? = null
        public var fileSystemId: kotlin.String? = null
        /**
         * The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.
         */
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.FileSystemAlreadyExists) : this() {
            this.errorCode = x.errorCode
            this.fileSystemId = x.fileSystemId
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.FileSystemAlreadyExists = FileSystemAlreadyExists(this)

        internal fun correctErrors(): Builder {
            if (errorCode == null) errorCode = ""
            if (fileSystemId == null) fileSystemId = ""
            return this
        }
    }
}
